/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.dynamic;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mvel2.ParserContext;
import org.mvel2.compiler.Accessor;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.AbstractOptimizer;
import org.mvel2.optimizers.AccessorOptimizer;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.optimizers.dynamic.DynamicAccessor;
import org.mvel2.optimizers.dynamic.DynamicClassLoader;
import org.mvel2.optimizers.dynamic.DynamicCollectionAccessor;
import org.mvel2.optimizers.dynamic.DynamicGetAccessor;
import org.mvel2.optimizers.dynamic.DynamicSetAccessor;
import org.mvel2.optimizers.impl.asm.ASMAccessorOptimizer;

public class DynamicOptimizer
extends AbstractOptimizer
implements AccessorOptimizer {
    private AccessorOptimizer firstStage = OptimizerFactory.getAccessorCompiler(OptimizerFactory.SAFE_REFLECTIVE);
    private static final Object oLock = new Object();
    private static volatile DynamicClassLoader classLoader;
    public static int tenuringThreshold;
    public static long timeSpan;
    public static int maximumTenure;
    public static int totalRecycled;
    private static volatile boolean useSafeClassloading;
    private static ReadWriteLock lock;
    private static Lock readLock;
    private static Lock writeLock;
    public static final int REGULAR_ACCESSOR = 0;
    public static final int SET_ACCESSOR = 1;
    public static final int COLLECTION = 2;
    public static final int OBJ_CREATION = 3;

    @Override
    public void init() {
        DynamicOptimizer._init();
    }

    private static void _init() {
        classLoader = new DynamicClassLoader(Thread.currentThread().getContextClassLoader(), maximumTenure);
        ASMAccessorOptimizer.setMVELClassLoader(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enforceTenureLimit() {
        writeLock.lock();
        try {
            if (classLoader.isOverloaded()) {
                classLoader.deoptimizeAll();
                totalRecycled = classLoader.getTotalClasses();
                DynamicOptimizer._init();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Accessor optimizeAccessor(ParserContext pCtx, char[] property2, int start, int offset, Object ctx, Object thisRef, VariableResolverFactory factory, boolean rootThisRef, Class ingressType) {
        readLock.lock();
        try {
            pCtx.optimizationNotify();
            DynamicAccessor dynamicAccessor = classLoader.registerDynamicAccessor(new DynamicGetAccessor(pCtx, property2, start, offset, 0, this.firstStage.optimizeAccessor(pCtx, property2, start, offset, ctx, thisRef, factory, rootThisRef, ingressType)));
            return dynamicAccessor;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Accessor optimizeSetAccessor(ParserContext pCtx, char[] property2, int start, int offset, Object ctx, Object thisRef, VariableResolverFactory factory, boolean rootThisRef, Object value2, Class valueType) {
        readLock.lock();
        try {
            DynamicAccessor dynamicAccessor = classLoader.registerDynamicAccessor(new DynamicSetAccessor(pCtx, property2, start, offset, this.firstStage.optimizeSetAccessor(pCtx, property2, start, offset, ctx, thisRef, factory, rootThisRef, value2, valueType)));
            return dynamicAccessor;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Accessor optimizeCollection(ParserContext pCtx, Object rootObject, Class type2, char[] property2, int start, int offset, Object ctx, Object thisRef, VariableResolverFactory factory) {
        readLock.lock();
        try {
            DynamicAccessor dynamicAccessor = classLoader.registerDynamicAccessor(new DynamicCollectionAccessor(pCtx, rootObject, type2, property2, start, offset, 2, this.firstStage.optimizeCollection(pCtx, rootObject, type2, property2, start, offset, ctx, thisRef, factory)));
            return dynamicAccessor;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Accessor optimizeObjectCreation(ParserContext pCtx, char[] property2, int start, int offset, Object ctx, Object thisRef, VariableResolverFactory factory) {
        readLock.lock();
        try {
            DynamicAccessor dynamicAccessor = classLoader.registerDynamicAccessor(new DynamicGetAccessor(pCtx, property2, start, offset, 3, this.firstStage.optimizeObjectCreation(pCtx, property2, start, offset, ctx, thisRef, factory)));
            return dynamicAccessor;
        }
        finally {
            readLock.unlock();
        }
    }

    public static boolean isOverloaded() {
        return classLoader.isOverloaded();
    }

    @Override
    public Object getResultOptPass() {
        return this.firstStage.getResultOptPass();
    }

    @Override
    public Class getEgressType() {
        return this.firstStage.getEgressType();
    }

    @Override
    public boolean isLiteralOnly() {
        return this.firstStage.isLiteralOnly();
    }

    static {
        tenuringThreshold = 50;
        timeSpan = 100L;
        maximumTenure = 1500;
        totalRecycled = 0;
        useSafeClassloading = false;
        lock = new ReentrantReadWriteLock();
        readLock = lock.readLock();
        writeLock = lock.writeLock();
    }
}

