/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.management.ObjectName;
import org.apache.catalina.Executor;
import org.apache.catalina.Globals;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Service;
import org.apache.catalina.connector.CoyoteAdapter;
import org.apache.catalina.connector.MapperListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.AprLifecycleListener;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.CharsetUtil;
import org.apache.tomcat.util.buf.EncodedSolidusHandling;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.http.mapper.Mapper;
import org.apache.tomcat.util.res.StringManager;

public class Connector
extends LifecycleMBeanBase {
    private static final Log log = LogFactory.getLog(Connector.class);
    public static final boolean RECYCLE_FACADES = Boolean.parseBoolean(System.getProperty("org.apache.catalina.connector.RECYCLE_FACADES", "false"));
    protected Service service = null;
    protected boolean allowTrace = false;
    protected long asyncTimeout = 10000L;
    protected boolean enableLookups = false;
    protected boolean xpoweredBy = false;
    protected static final String info = "org.apache.catalina.connector.Connector/2.1";
    protected int port = -1;
    protected String proxyName = null;
    protected int proxyPort = 0;
    protected boolean discardFacades = RECYCLE_FACADES;
    protected int redirectPort = 443;
    protected String scheme = "http";
    protected boolean secure = false;
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.connector");
    protected int maxParameterCount = 10000;
    protected int maxPostSize = 0x200000;
    protected int maxSavePostSize = 4096;
    protected String parseBodyMethods = "POST";
    protected HashSet<String> parseBodyMethodsSet;
    protected boolean useIPVHosts = false;
    protected String protocolHandlerClassName = "org.apache.coyote.http11.Http11Protocol";
    protected ProtocolHandler protocolHandler = null;
    protected Adapter adapter = null;
    protected Mapper mapper = new Mapper();
    protected MapperListener mapperListener = new MapperListener(this.mapper, this);
    protected String URIEncoding = null;
    private EncodedSolidusHandling encodedSolidusHandling = UDecoder.ALLOW_ENCODED_SLASH ? EncodedSolidusHandling.DECODE : EncodedSolidusHandling.REJECT;
    protected boolean useBodyEncodingForURI = false;
    protected static HashMap<String, String> replacements = new HashMap();

    public Connector() {
        this(null);
    }

    public Connector(String string) {
        this.setProtocol(string);
        try {
            Class<?> clazz = Class.forName(this.protocolHandlerClassName);
            this.protocolHandler = (ProtocolHandler)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("coyoteConnector.protocolHandlerInstantiationFailed"), (Throwable)exception);
        }
        if (Boolean.parseBoolean(System.getProperty("org.apache.tomcat.util.buf.UDecoder.ALLOW_ENCODED_SLASH", "false"))) {
            this.encodedSolidusHandling = EncodedSolidusHandling.DECODE;
        }
    }

    public Object getProperty(String string) {
        String string2 = string;
        if (replacements.get(string) != null) {
            string2 = replacements.get(string);
        }
        return IntrospectionUtils.getProperty((Object)this.protocolHandler, (String)string2);
    }

    public boolean setProperty(String string, String string2) {
        String string3 = string;
        if (replacements.get(string) != null) {
            string3 = replacements.get(string);
        }
        return IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)string3, (String)string2);
    }

    @Deprecated
    public Object getAttribute(String string) {
        return this.getProperty(string);
    }

    @Deprecated
    public void setAttribute(String string, Object object) {
        this.setProperty(string, String.valueOf(object));
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public boolean getAllowTrace() {
        return this.allowTrace;
    }

    public void setAllowTrace(boolean bl) {
        this.allowTrace = bl;
        this.setProperty("allowTrace", String.valueOf(bl));
    }

    public long getAsyncTimeout() {
        return this.asyncTimeout;
    }

    public void setAsyncTimeout(long l) {
        this.asyncTimeout = l;
        this.setProperty("asyncTimeout", String.valueOf(l));
    }

    public boolean getDiscardFacades() {
        return this.discardFacades || Globals.IS_SECURITY_ENABLED;
    }

    public void setDiscardFacades(boolean bl) {
        this.discardFacades = bl;
    }

    public boolean getEnableLookups() {
        return this.enableLookups;
    }

    public void setEnableLookups(boolean bl) {
        this.enableLookups = bl;
        this.setProperty("enableLookups", String.valueOf(bl));
    }

    public String getInfo() {
        return info;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public int getMaxHeaderCount() {
        return (Integer)this.getProperty("maxHeaderCount");
    }

    public void setMaxHeaderCount(int n) {
        this.setProperty("maxHeaderCount", String.valueOf(n));
    }

    public int getMaxParameterCount() {
        return this.maxParameterCount;
    }

    public void setMaxParameterCount(int n) {
        this.maxParameterCount = n;
    }

    public int getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setMaxPostSize(int n) {
        this.maxPostSize = n;
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(int n) {
        this.maxSavePostSize = n;
        this.setProperty("maxSavePostSize", String.valueOf(n));
    }

    public String getParseBodyMethods() {
        return this.parseBodyMethods;
    }

    public void setParseBodyMethods(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (null != string) {
            hashSet.addAll(Arrays.asList(string.split("\\s*,\\s*")));
        }
        if (hashSet.contains("TRACE")) {
            throw new IllegalArgumentException(sm.getString("coyoteConnector.parseBodyMethodNoTrace"));
        }
        this.parseBodyMethods = string;
        this.parseBodyMethodsSet = hashSet;
    }

    protected boolean isParseBodyMethod(String string) {
        return this.parseBodyMethodsSet.contains(string);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
        this.setProperty("port", String.valueOf(n));
    }

    public int getLocalPort() {
        return (Integer)this.getProperty("localPort");
    }

    public String getProtocol() {
        if ("org.apache.coyote.http11.Http11Protocol".equals(this.getProtocolHandlerClassName()) || "org.apache.coyote.http11.Http11AprProtocol".equals(this.getProtocolHandlerClassName())) {
            return "HTTP/1.1";
        }
        if ("org.apache.coyote.ajp.AjpProtocol".equals(this.getProtocolHandlerClassName()) || "org.apache.coyote.ajp.AjpAprProtocol".equals(this.getProtocolHandlerClassName())) {
            return "AJP/1.3";
        }
        return this.getProtocolHandlerClassName();
    }

    public void setProtocol(String string) {
        if (AprLifecycleListener.isAprAvailable()) {
            if ("HTTP/1.1".equals(string)) {
                this.setProtocolHandlerClassName("org.apache.coyote.http11.Http11AprProtocol");
            } else if ("AJP/1.3".equals(string)) {
                this.setProtocolHandlerClassName("org.apache.coyote.ajp.AjpAprProtocol");
            } else if (string != null) {
                this.setProtocolHandlerClassName(string);
            } else {
                this.setProtocolHandlerClassName("org.apache.coyote.http11.Http11AprProtocol");
            }
        } else if ("HTTP/1.1".equals(string)) {
            this.setProtocolHandlerClassName("org.apache.coyote.http11.Http11Protocol");
        } else if ("AJP/1.3".equals(string)) {
            this.setProtocolHandlerClassName("org.apache.coyote.ajp.AjpProtocol");
        } else if (string != null) {
            this.setProtocolHandlerClassName(string);
        }
    }

    public String getProtocolHandlerClassName() {
        return this.protocolHandlerClassName;
    }

    public void setProtocolHandlerClassName(String string) {
        this.protocolHandlerClassName = string;
    }

    public ProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public void setProxyName(String string) {
        this.proxyName = string != null && string.length() > 0 ? string : null;
        this.setProperty("proxyName", this.proxyName);
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int n) {
        this.proxyPort = n;
        this.setProperty("proxyPort", String.valueOf(n));
    }

    public int getRedirectPort() {
        return this.redirectPort;
    }

    public void setRedirectPort(int n) {
        this.redirectPort = n;
        this.setProperty("redirectPort", String.valueOf(n));
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String string) {
        this.scheme = string;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
        this.setProperty("secure", Boolean.toString(bl));
    }

    public String getURIEncoding() {
        return this.URIEncoding;
    }

    public void setURIEncoding(String string) {
        this.URIEncoding = string;
        try {
            Charset charset = B2CConverter.getCharset((String)string);
            if (!CharsetUtil.isAsciiSuperset((Charset)charset)) {
                log.error((Object)sm.getString("coyoteConnector.notAsciiSuperset", new Object[]{string}));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public boolean getUseBodyEncodingForURI() {
        return this.useBodyEncodingForURI;
    }

    public void setUseBodyEncodingForURI(boolean bl) {
        this.useBodyEncodingForURI = bl;
        this.setProperty("useBodyEncodingForURI", String.valueOf(bl));
    }

    public boolean getXpoweredBy() {
        return this.xpoweredBy;
    }

    public void setXpoweredBy(boolean bl) {
        this.xpoweredBy = bl;
        this.setProperty("xpoweredBy", String.valueOf(bl));
    }

    public void setUseIPVHosts(boolean bl) {
        this.useIPVHosts = bl;
        this.setProperty("useIPVHosts", String.valueOf(bl));
    }

    public boolean getUseIPVHosts() {
        return this.useIPVHosts;
    }

    public String getExecutorName() {
        java.util.concurrent.Executor executor = this.protocolHandler.getExecutor();
        if (executor instanceof Executor) {
            return ((Executor)executor).getName();
        }
        return "Internal";
    }

    public String getEncodedSolidusHandling() {
        return this.encodedSolidusHandling.getValue();
    }

    public void setEncodedSolidusHandling(String string) {
        this.encodedSolidusHandling = EncodedSolidusHandling.fromString((String)string);
    }

    public EncodedSolidusHandling getEncodedSolidusHandlingInternal() {
        return this.encodedSolidusHandling;
    }

    public Request createRequest() {
        Request request = new Request();
        request.setConnector(this);
        return request;
    }

    public Response createResponse() {
        Response response = new Response();
        response.setConnector(this);
        return response;
    }

    protected String createObjectNameKeyProperties(String string) {
        Object object = this.getProperty("address");
        StringBuilder stringBuilder = new StringBuilder("type=");
        stringBuilder.append(string);
        stringBuilder.append(",port=");
        int n = this.getPort();
        if (n > 0) {
            stringBuilder.append(n);
        } else {
            stringBuilder.append("auto-");
            stringBuilder.append(this.getProperty("nameIndex"));
        }
        String string2 = "";
        if (object instanceof InetAddress) {
            string2 = ((InetAddress)object).getHostAddress();
        } else if (object != null) {
            string2 = object.toString();
        }
        if (string2.length() > 0) {
            stringBuilder.append(",address=");
            stringBuilder.append(ObjectName.quote(string2));
        }
        return stringBuilder.toString();
    }

    public void pause() {
        try {
            this.protocolHandler.pause();
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("coyoteConnector.protocolHandlerPauseFailed"), (Throwable)exception);
        }
    }

    public void resume() {
        try {
            this.protocolHandler.resume();
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("coyoteConnector.protocolHandlerResumeFailed"), (Throwable)exception);
        }
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        this.adapter = new CoyoteAdapter(this);
        this.protocolHandler.setAdapter(this.adapter);
        if (null == this.parseBodyMethodsSet) {
            this.setParseBodyMethods(this.getParseBodyMethods());
        }
        if (this.protocolHandler.isAprRequired() && !AprLifecycleListener.isAprAvailable()) {
            throw new LifecycleException(sm.getString("coyoteConnector.protocolHandlerNoApr", new Object[]{this.getProtocolHandlerClassName()}));
        }
        try {
            this.protocolHandler.init();
        }
        catch (Exception exception) {
            throw new LifecycleException(sm.getString("coyoteConnector.protocolHandlerInitializationFailed"), exception);
        }
        this.mapperListener.init();
    }

    @Override
    protected void startInternal() throws LifecycleException {
        if (this.getPort() < 0) {
            throw new LifecycleException(sm.getString("coyoteConnector.invalidPort", new Object[]{this.getPort()}));
        }
        this.setState(LifecycleState.STARTING);
        try {
            this.protocolHandler.start();
        }
        catch (Exception exception) {
            String string = "";
            if (this.service != null) {
                string = string + "service.getName(): \"" + this.service.getName() + "\"; ";
            }
            throw new LifecycleException(string + " " + sm.getString("coyoteConnector.protocolHandlerStartFailed"), exception);
        }
        this.mapperListener.start();
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        try {
            this.protocolHandler.stop();
        }
        catch (Exception exception) {
            throw new LifecycleException(sm.getString("coyoteConnector.protocolHandlerStopFailed"), exception);
        }
        this.mapperListener.stop();
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        this.mapperListener.destroy();
        try {
            this.protocolHandler.destroy();
        }
        catch (Exception exception) {
            throw new LifecycleException(sm.getString("coyoteConnector.protocolHandlerDestroyFailed"), exception);
        }
        if (this.getService() != null) {
            this.getService().removeConnector(this);
        }
        super.destroyInternal();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Connector[");
        stringBuilder.append(this.getProtocol());
        stringBuilder.append('-');
        int n = this.getPort();
        if (n > 0) {
            stringBuilder.append(n);
        } else {
            stringBuilder.append("auto-");
            stringBuilder.append(this.getProperty("nameIndex"));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    protected String getDomainInternal() {
        return MBeanUtils.getDomain(this.getService());
    }

    @Override
    protected String getObjectNameKeyProperties() {
        return this.createObjectNameKeyProperties("Connector");
    }

    static {
        replacements.put("acceptCount", "backlog");
        replacements.put("connectionLinger", "soLinger");
        replacements.put("connectionTimeout", "soTimeout");
        replacements.put("rootFile", "rootfile");
    }
}

