/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.ServletInputStream;
import org.apache.catalina.connector.InputBuffer;
import org.apache.catalina.security.SecurityUtil;

public class CoyoteInputStream
extends ServletInputStream {
    protected InputBuffer ib;

    protected CoyoteInputStream(InputBuffer inputBuffer) {
        this.ib = inputBuffer;
    }

    void clear() {
        this.ib = null;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int read() throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer n = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer n = CoyoteInputStream.this.ib.readByte();
                        return n;
                    }
                });
                return n;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception.getMessage(), exception);
            }
        }
        return this.ib.readByte();
    }

    public int available() throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer n = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer n = CoyoteInputStream.this.ib.available();
                        return n;
                    }
                });
                return n;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception.getMessage(), exception);
            }
        }
        return this.ib.available();
    }

    public int read(final byte[] byArray) throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer n = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer n = CoyoteInputStream.this.ib.read(byArray, 0, byArray.length);
                        return n;
                    }
                });
                return n;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception.getMessage(), exception);
            }
        }
        return this.ib.read(byArray, 0, byArray.length);
    }

    public int read(final byte[] byArray, final int n, final int n2) throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer n3 = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer n3 = CoyoteInputStream.this.ib.read(byArray, n, n2);
                        return n3;
                    }
                });
                return n3;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception.getMessage(), exception);
            }
        }
        return this.ib.read(byArray, n, n2);
    }

    public int readLine(byte[] byArray, int n, int n2) throws IOException {
        return super.readLine(byArray, n, n2);
    }

    public void close() throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        CoyoteInputStream.this.ib.close();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception.getMessage(), exception);
            }
        } else {
            this.ib.close();
        }
    }
}

