/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.catalina.Globals;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.Request;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Response;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.C2BConverter;
import org.apache.tomcat.util.buf.CharChunk;

public class OutputBuffer
extends Writer
implements ByteChunk.ByteOutputChannel,
CharChunk.CharOutputChannel {
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private final ByteChunk bb;
    private final CharChunk cb;
    private boolean initial = true;
    private long bytesWritten = 0L;
    private long charsWritten = 0L;
    private boolean closed = false;
    private boolean doFlush = false;
    private final ByteChunk outputChunk = new ByteChunk();
    private CharChunk outputCharChunk = new CharChunk();
    private String enc;
    private boolean gotEnc = false;
    protected final ConcurrentHashMap<String, C2BConverter> encoders = new ConcurrentHashMap();
    protected C2BConverter conv;
    private Response coyoteResponse;
    private boolean suspended = false;

    public OutputBuffer() {
        this(8192);
    }

    public OutputBuffer(int n) {
        this.bb = new ByteChunk(n);
        this.bb.setLimit(n);
        this.bb.setByteOutputChannel((ByteChunk.ByteOutputChannel)this);
        this.cb = new CharChunk(n);
        this.cb.setLimit(n);
        this.cb.setOptimizedWrite(false);
        this.cb.setCharOutputChannel((CharChunk.CharOutputChannel)this);
    }

    public void setResponse(Response response) {
        this.coyoteResponse = response;
    }

    @Deprecated
    public Response getResponse() {
        return this.coyoteResponse;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean bl) {
        this.suspended = bl;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void recycle() {
        this.initial = true;
        this.bytesWritten = 0L;
        this.charsWritten = 0L;
        this.bb.recycle();
        this.cb.recycle();
        this.outputCharChunk.setChars(null, 0, 0);
        this.closed = false;
        this.suspended = false;
        this.doFlush = false;
        if (this.conv != null) {
            this.conv.recycle();
        }
        this.gotEnc = false;
        this.enc = null;
    }

    public void clearEncoders() {
        this.encoders.clear();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.suspended) {
            return;
        }
        if (this.cb.getLength() > 0) {
            this.cb.flushBuffer();
        }
        if (!(this.coyoteResponse.isCommitted() || this.coyoteResponse.getContentLengthLong() != -1L || this.coyoteResponse.getRequest().method().equals("HEAD") || this.coyoteResponse.isCommitted())) {
            this.coyoteResponse.setContentLength((long)this.bb.getLength());
        }
        if (this.coyoteResponse.getStatus() == 101) {
            this.doFlush(true);
        } else {
            this.doFlush(false);
        }
        this.closed = true;
        Request request = (Request)this.coyoteResponse.getRequest().getNote(1);
        request.inputBuffer.close();
        this.coyoteResponse.finish();
    }

    @Override
    public void flush() throws IOException {
        this.doFlush(true);
    }

    protected void doFlush(boolean bl) throws IOException {
        if (this.suspended) {
            return;
        }
        try {
            this.doFlush = true;
            if (this.initial) {
                this.coyoteResponse.sendHeaders();
                this.initial = false;
            }
            if (this.cb.getLength() > 0) {
                this.cb.flushBuffer();
            }
            if (this.bb.getLength() > 0) {
                this.bb.flushBuffer();
            }
        }
        finally {
            this.doFlush = false;
        }
        if (bl) {
            this.coyoteResponse.action(ActionCode.CLIENT_FLUSH, null);
            if (this.coyoteResponse.isExceptionPresent()) {
                throw new ClientAbortException(this.coyoteResponse.getErrorException());
            }
        }
    }

    public void realWriteBytes(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            return;
        }
        if (this.coyoteResponse == null) {
            return;
        }
        if (n2 > 0) {
            this.outputChunk.setBytes(byArray, n, n2);
            try {
                this.coyoteResponse.doWrite(this.outputChunk);
            }
            catch (IOException iOException) {
                throw new ClientAbortException(iOException);
            }
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.suspended) {
            return;
        }
        this.writeBytes(byArray, n, n2);
    }

    private void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            return;
        }
        this.bb.append(byArray, n, n2);
        this.bytesWritten += (long)n2;
        if (this.doFlush) {
            this.bb.flushBuffer();
        }
    }

    public void writeByte(int n) throws IOException {
        if (this.suspended) {
            return;
        }
        this.bb.append((byte)n);
        ++this.bytesWritten;
    }

    public void realWriteChars(char[] cArray, int n, int n2) throws IOException {
        this.outputCharChunk.setChars(cArray, n, n2);
        while (this.outputCharChunk.getLength() > 0) {
            this.conv.convert(this.outputCharChunk, this.bb);
            if (this.bb.getLength() == 0) break;
            if (this.outputCharChunk.getLength() > 0) {
                if (this.bb.getBuffer().length == this.bb.getEnd() && this.bb.getLength() < this.bb.getLimit()) {
                    this.bb.makeSpace(this.outputCharChunk.getLength());
                    continue;
                }
                this.bb.flushBuffer();
                continue;
            }
            if (!this.conv.isUndeflow() || this.bb.getLength() - 4 >= this.bb.getLimit()) continue;
            this.bb.flushBuffer();
        }
    }

    @Override
    public void write(int n) throws IOException {
        if (this.suspended) {
            return;
        }
        this.cb.append((char)n);
        ++this.charsWritten;
    }

    @Override
    public void write(char[] cArray) throws IOException {
        if (this.suspended) {
            return;
        }
        this.write(cArray, 0, cArray.length);
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.suspended) {
            return;
        }
        this.cb.append(cArray, n, n2);
        this.charsWritten += (long)n2;
    }

    @Override
    public void write(String string, int n, int n2) throws IOException {
        if (this.suspended) {
            return;
        }
        this.charsWritten += (long)n2;
        if (string == null) {
            string = "null";
        }
        this.cb.append(string, n, n2);
        this.charsWritten += (long)n2;
    }

    @Override
    public void write(String string) throws IOException {
        if (this.suspended) {
            return;
        }
        if (string == null) {
            string = "null";
        }
        this.cb.append(string);
        this.charsWritten += (long)string.length();
    }

    public void setEncoding(String string) {
        this.enc = string;
    }

    public void checkConverter() throws IOException {
        if (!this.gotEnc) {
            this.setConverter();
        }
    }

    protected void setConverter() throws IOException {
        if (this.coyoteResponse != null) {
            this.enc = this.coyoteResponse.getCharacterEncoding();
        }
        this.gotEnc = true;
        if (this.enc == null) {
            this.enc = DEFAULT_ENCODING;
        }
        this.conv = this.encoders.get(this.enc);
        if (this.conv == null) {
            if (Globals.IS_SECURITY_ENABLED) {
                try {
                    this.conv = AccessController.doPrivileged(new PrivilegedExceptionAction<C2BConverter>(){

                        @Override
                        public C2BConverter run() throws IOException {
                            return new C2BConverter(OutputBuffer.this.enc);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = privilegedActionException.getException();
                    if (exception instanceof IOException) {
                        throw (IOException)exception;
                    }
                    throw new IOException(privilegedActionException);
                }
            } else {
                this.conv = new C2BConverter(this.enc);
            }
            this.encoders.put(this.enc, this.conv);
        }
    }

    public long getContentWritten() {
        return this.bytesWritten + this.charsWritten;
    }

    public boolean isNew() {
        return this.bytesWritten == 0L && this.charsWritten == 0L;
    }

    public void setBufferSize(int n) {
        if (n > this.bb.getLimit()) {
            this.bb.setLimit(n);
        }
    }

    public void reset() {
        this.reset(false);
    }

    public void reset(boolean bl) {
        this.bb.recycle();
        this.cb.recycle();
        this.bytesWritten = 0L;
        this.charsWritten = 0L;
        if (bl) {
            this.gotEnc = false;
            this.enc = null;
        }
        this.initial = true;
    }

    public int getBufferSize() {
        return this.bb.getLimit();
    }
}

