/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.deploy;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import javax.servlet.HttpConstraintElement;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.ServletSecurity;
import org.apache.catalina.deploy.SecurityCollection;

public class SecurityConstraint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean allRoles = false;
    private boolean authConstraint = false;
    private String[] authRoles = new String[0];
    private SecurityCollection[] collections = new SecurityCollection[0];
    private String displayName = null;
    private String userConstraint = "NONE";

    public boolean getAllRoles() {
        return this.allRoles;
    }

    public boolean getAuthConstraint() {
        return this.authConstraint;
    }

    public void setAuthConstraint(boolean bl) {
        this.authConstraint = bl;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getUserConstraint() {
        return this.userConstraint;
    }

    public void setUserConstraint(String string) {
        if (string != null) {
            this.userConstraint = string;
        }
    }

    public void addAuthRole(String string) {
        if (string == null) {
            return;
        }
        if ("*".equals(string)) {
            this.allRoles = true;
            return;
        }
        String[] stringArray = new String[this.authRoles.length + 1];
        for (int i = 0; i < this.authRoles.length; ++i) {
            stringArray[i] = this.authRoles[i];
        }
        stringArray[this.authRoles.length] = string;
        this.authRoles = stringArray;
        this.authConstraint = true;
    }

    public void addCollection(SecurityCollection securityCollection) {
        if (securityCollection == null) {
            return;
        }
        SecurityCollection[] securityCollectionArray = new SecurityCollection[this.collections.length + 1];
        for (int i = 0; i < this.collections.length; ++i) {
            securityCollectionArray[i] = this.collections[i];
        }
        securityCollectionArray[this.collections.length] = securityCollection;
        this.collections = securityCollectionArray;
    }

    public boolean findAuthRole(String string) {
        if (string == null) {
            return false;
        }
        for (String string2 : this.authRoles) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public String[] findAuthRoles() {
        return this.authRoles;
    }

    public SecurityCollection findCollection(String string) {
        if (string == null) {
            return null;
        }
        for (SecurityCollection securityCollection : this.collections) {
            if (!string.equals(securityCollection.getName())) continue;
            return securityCollection;
        }
        return null;
    }

    public SecurityCollection[] findCollections() {
        return this.collections;
    }

    public boolean included(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        for (SecurityCollection securityCollection : this.collections) {
            String[] stringArray;
            if (!securityCollection.findMethod(string2)) continue;
            for (String string3 : stringArray = securityCollection.findPatterns()) {
                if (!this.matchPattern(string, string3)) continue;
                return true;
            }
        }
        return false;
    }

    public void removeAuthRole(String string) {
        int n;
        if (string == null) {
            return;
        }
        int n2 = -1;
        for (n = 0; n < this.authRoles.length; ++n) {
            if (!this.authRoles[n].equals(string)) continue;
            n2 = n;
            break;
        }
        if (n2 >= 0) {
            n = 0;
            String[] stringArray = new String[this.authRoles.length - 1];
            for (int i = 0; i < this.authRoles.length; ++i) {
                if (i == n2) continue;
                stringArray[n++] = this.authRoles[i];
            }
            this.authRoles = stringArray;
        }
    }

    public void removeCollection(SecurityCollection securityCollection) {
        int n;
        if (securityCollection == null) {
            return;
        }
        int n2 = -1;
        for (n = 0; n < this.collections.length; ++n) {
            if (!this.collections[n].equals(securityCollection)) continue;
            n2 = n;
            break;
        }
        if (n2 >= 0) {
            n = 0;
            SecurityCollection[] securityCollectionArray = new SecurityCollection[this.collections.length - 1];
            for (int i = 0; i < this.collections.length; ++i) {
                if (i == n2) continue;
                securityCollectionArray[n++] = this.collections[i];
            }
            this.collections = securityCollectionArray;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("SecurityConstraint[");
        for (int i = 0; i < this.collections.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.collections[i].getName());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private boolean matchPattern(String string, String string2) {
        if (string == null || string.length() == 0) {
            string = "/";
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "/";
        }
        if (string.equals(string2)) {
            return true;
        }
        if (string2.startsWith("/") && string2.endsWith("/*")) {
            if ((string2 = string2.substring(0, string2.length() - 2)).length() == 0) {
                return true;
            }
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            while (true) {
                if (string2.equals(string)) {
                    return true;
                }
                int n = string.lastIndexOf(47);
                if (n <= 0) break;
                string = string.substring(0, n);
            }
            return false;
        }
        if (string2.startsWith("*.")) {
            int n = string.lastIndexOf(47);
            int n2 = string.lastIndexOf(46);
            return n >= 0 && n2 > n && string.endsWith(string2.substring(1));
        }
        return string2.equals("/");
    }

    public static SecurityConstraint[] createConstraints(ServletSecurityElement servletSecurityElement, String string) {
        Object object;
        Serializable serializable;
        Object object22;
        HashSet<Object> hashSet = new HashSet<Object>();
        Collection collection = servletSecurityElement.getHttpMethodConstraints();
        for (Object object22 : collection) {
            serializable = SecurityConstraint.createConstraint((HttpConstraintElement)object22, string, true);
            object = ((SecurityConstraint)serializable).findCollections()[0];
            ((SecurityCollection)object).addMethod(object22.getMethodName());
            hashSet.add(serializable);
        }
        object22 = SecurityConstraint.createConstraint((HttpConstraintElement)servletSecurityElement, string, false);
        if (object22 != null) {
            serializable = ((SecurityConstraint)object22).findCollections()[0];
            object = servletSecurityElement.getMethodNames().iterator();
            while (object.hasNext()) {
                ((SecurityCollection)serializable).addOmittedMethod((String)object.next());
            }
            hashSet.add(object22);
        }
        return hashSet.toArray(new SecurityConstraint[0]);
    }

    private static SecurityConstraint createConstraint(HttpConstraintElement httpConstraintElement, String string, boolean bl) {
        SecurityConstraint securityConstraint = new SecurityConstraint();
        SecurityCollection securityCollection = new SecurityCollection();
        boolean bl2 = bl;
        if (httpConstraintElement.getTransportGuarantee() != ServletSecurity.TransportGuarantee.NONE) {
            securityConstraint.setUserConstraint(httpConstraintElement.getTransportGuarantee().name());
            bl2 = true;
        }
        if (httpConstraintElement.getRolesAllowed().length > 0) {
            String[] stringArray;
            for (String string2 : stringArray = httpConstraintElement.getRolesAllowed()) {
                securityConstraint.addAuthRole(string2);
            }
            bl2 = true;
        }
        if (httpConstraintElement.getEmptyRoleSemantic() != ServletSecurity.EmptyRoleSemantic.PERMIT) {
            securityConstraint.setAuthConstraint(true);
            bl2 = true;
        }
        if (bl2) {
            securityCollection.addPattern(string);
            securityConstraint.addCollection(securityCollection);
            return securityConstraint;
        }
        return null;
    }
}

