/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.descriptor.TaglibDescriptor;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ApplicationListener;
import org.apache.catalina.startup.TldRuleSet;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.descriptor.DigesterFactory;
import org.apache.tomcat.util.descriptor.XmlErrorHandler;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.scan.Jar;
import org.apache.tomcat.util.scan.JarFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class TldConfig
implements LifecycleListener {
    private static final String TLD_EXT = ".tld";
    private static final String WEB_INF = "/WEB-INF/";
    private static final String WEB_INF_LIB = "/WEB-INF/lib/";
    private static volatile Set<String> noTldJars = null;
    private static final Log log = LogFactory.getLog(TldConfig.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.startup");
    private static Digester[] tldDigesters = new Digester[4];
    private Context context = null;
    private Digester tldDigester = null;
    private Set<String> taglibUris = new HashSet<String>();
    private Set<String> webxmlTaglibUris = new HashSet<String>();
    private ArrayList<String> listeners = new ArrayList();

    private static synchronized Digester createTldDigester(boolean bl, boolean bl2) {
        Digester digester;
        int n = 0;
        if (bl) {
            ++n;
        }
        if (bl2) {
            n += 2;
        }
        if ((digester = tldDigesters[n]) == null) {
            digester = DigesterFactory.newDigester((boolean)bl, (boolean)true, (RuleSet)new TldRuleSet(), (boolean)bl2);
            digester.getParser();
            TldConfig.tldDigesters[n] = digester;
        }
        return digester;
    }

    public static synchronized void setNoTldJars(String string) {
        if (string == null) {
            noTldJars = null;
        } else {
            if (noTldJars == null) {
                noTldJars = new HashSet<String>();
            } else {
                noTldJars.clear();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.length() <= 0) continue;
                noTldJars.add(string2);
            }
        }
    }

    public void addTaglibUri(String string) {
        this.taglibUris.add(string);
    }

    public boolean isKnownTaglibUri(String string) {
        return this.taglibUris.contains(string);
    }

    public boolean isKnownWebxmlTaglibUri(String string) {
        return this.webxmlTaglibUris.contains(string);
    }

    @Deprecated
    public Context getContext() {
        return this.context;
    }

    @Deprecated
    public void setContext(Context context) {
        this.context = context;
    }

    public void addApplicationListener(String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add tld listener " + string));
        }
        this.listeners.add(string);
    }

    public String[] getTldListeners() {
        String[] stringArray = new String[this.listeners.size()];
        this.listeners.toArray(stringArray);
        return stringArray;
    }

    public void execute() {
        long l = System.currentTimeMillis();
        this.tldScanWebXml();
        this.tldScanResourcePaths(WEB_INF);
        JarScanner jarScanner = this.context.getJarScanner();
        TldJarScannerCallback tldJarScannerCallback = new TldJarScannerCallback();
        jarScanner.scan(this.context.getServletContext(), this.context.getLoader().getClassLoader(), (JarScannerCallback)tldJarScannerCallback, noTldJars);
        if (tldJarScannerCallback.scanFoundNoTLDs()) {
            log.info((Object)sm.getString("tldConfig.noTldSummary"));
        }
        String[] stringArray = this.getTldListeners();
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("tldConfig.addListeners", new Object[]{stringArray.length}));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.context.addApplicationListener(new ApplicationListener(stringArray[i], true));
        }
        long l2 = System.currentTimeMillis();
        if (this.context instanceof StandardContext) {
            ((StandardContext)this.context).setTldScanTime(l2 - l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tldScanWebXml() {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("tldConfig.webxmlStart"));
        }
        Collection collection = this.context.getJspConfigDescriptor().getTaglibs();
        for (TaglibDescriptor taglibDescriptor : collection) {
            String string = taglibDescriptor.getTaglibLocation();
            if (!string.startsWith("/")) {
                string = WEB_INF + string;
            }
            if (this.taglibUris.contains(taglibDescriptor.getTaglibURI())) {
                log.warn((Object)sm.getString("tldConfig.webxmlSkip", new Object[]{string, taglibDescriptor.getTaglibURI()}));
                continue;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)sm.getString("tldConfig.webxmlAdd", new Object[]{string, taglibDescriptor.getTaglibURI()}));
            }
            InputStream inputStream = null;
            try {
                inputStream = this.context.getServletContext().getResourceAsStream(string);
                if (inputStream != null) {
                    XmlErrorHandler xmlErrorHandler = this.tldScanStream(inputStream);
                    xmlErrorHandler.logFindings(log, string);
                    this.taglibUris.add(taglibDescriptor.getTaglibURI());
                    this.webxmlTaglibUris.add(taglibDescriptor.getTaglibURI());
                    continue;
                }
                log.warn((Object)sm.getString("tldConfig.webxmlFailPathDoesNotExist", new Object[]{string, taglibDescriptor.getTaglibURI()}));
            }
            catch (IOException iOException) {
                log.warn((Object)sm.getString("tldConfig.webxmlFail", new Object[]{string, taglibDescriptor.getTaglibURI()}), (Throwable)iOException);
            }
            finally {
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tldScanResourcePaths(String string) {
        ServletContext servletContext;
        Set set;
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("tldConfig.webinfScan", new Object[]{string}));
        }
        if ((set = (servletContext = this.context.getServletContext()).getResourcePaths(string)) != null) {
            for (String string2 : set) {
                if (!string2.endsWith(TLD_EXT) && (string2.startsWith(WEB_INF_LIB) || string2.startsWith("/WEB-INF/classes/"))) continue;
                if (string2.endsWith(TLD_EXT)) {
                    if (string2.startsWith("/WEB-INF/tags/") && !string2.endsWith("implicit.tld")) continue;
                    InputStream inputStream = servletContext.getResourceAsStream(string2);
                    try {
                        XmlErrorHandler xmlErrorHandler = this.tldScanStream(inputStream);
                        xmlErrorHandler.logFindings(log, string2);
                        continue;
                    }
                    catch (IOException iOException) {
                        log.warn((Object)sm.getString("tldConfig.webinfFail", new Object[]{string2}), (Throwable)iOException);
                        continue;
                    }
                    finally {
                        if (inputStream == null) continue;
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            ExceptionUtils.handleThrowable((Throwable)throwable);
                        }
                        continue;
                    }
                }
                this.tldScanResourcePaths(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tldScanDir(File file) {
        File[] fileArray;
        boolean bl = false;
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("tldConfig.dirScan", new Object[]{file.getAbsolutePath()}));
        }
        if ((fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    this.tldScanDir(fileArray[i]);
                    continue;
                }
                if (!fileArray[i].getAbsolutePath().endsWith(TLD_EXT)) continue;
                FileInputStream fileInputStream = null;
                bl = true;
                try {
                    fileInputStream = new FileInputStream(fileArray[i]);
                    XmlErrorHandler xmlErrorHandler = this.tldScanStream(fileInputStream);
                    xmlErrorHandler.logFindings(log, fileArray[i].getAbsolutePath());
                    continue;
                }
                catch (IOException iOException) {
                    log.warn((Object)sm.getString("tldConfig.dirFail", new Object[]{fileArray[i].getAbsolutePath()}), (Throwable)iOException);
                    continue;
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (Throwable throwable) {
                            ExceptionUtils.handleThrowable((Throwable)throwable);
                        }
                    }
                }
            }
        }
        if (!bl && log.isDebugEnabled()) {
            log.debug((Object)sm.getString("tldConfig.noTldInDir", new Object[]{file.getAbsolutePath()}));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tldScanJar(JarURLConnection jarURLConnection) {
        Jar jar = null;
        boolean bl = false;
        try {
            jar = JarFactory.newInstance((URL)jarURLConnection.getURL());
            jar.nextEntry();
            String string = jar.getEntryName();
            while (string != null) {
                if (string.startsWith("META-INF/") && string.endsWith(TLD_EXT)) {
                    bl = true;
                    InputStream inputStream = null;
                    try {
                        inputStream = jar.getEntryInputStream();
                        XmlErrorHandler xmlErrorHandler = this.tldScanStream(inputStream);
                        xmlErrorHandler.logFindings(log, jarURLConnection.getURL() + string);
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                jar.nextEntry();
                string = jar.getEntryName();
            }
            if (!bl && log.isDebugEnabled()) {
                log.debug((Object)sm.getString("tldConfig.noTldInJar", new Object[]{jarURLConnection.getURL().getFile()}));
            }
        }
        catch (IOException iOException) {
            log.warn((Object)sm.getString("tldConfig.jarFail", new Object[]{jarURLConnection.getURL()}), (Throwable)iOException);
        }
        finally {
            if (jar != null) {
                jar.close();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlErrorHandler tldScanStream(InputStream inputStream) throws IOException {
        InputSource inputSource = new InputSource(inputStream);
        XmlErrorHandler xmlErrorHandler = new XmlErrorHandler();
        Digester digester = this.tldDigester;
        synchronized (digester) {
            try {
                this.tldDigester.setErrorHandler((ErrorHandler)xmlErrorHandler);
                this.tldDigester.push((Object)this);
                this.tldDigester.parse(inputSource);
            }
            catch (SAXException sAXException) {
                throw new IOException(sAXException);
            }
            finally {
                this.tldDigester.reset();
            }
            return xmlErrorHandler;
        }
    }

    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        try {
            this.context = (Context)lifecycleEvent.getLifecycle();
        }
        catch (ClassCastException classCastException) {
            log.error((Object)sm.getString("tldConfig.cce", new Object[]{lifecycleEvent.getLifecycle()}), (Throwable)classCastException);
            return;
        }
        if (lifecycleEvent.getType().equals("after_init")) {
            this.init();
        } else if (lifecycleEvent.getType().equals("configure_start")) {
            try {
                this.execute();
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("tldConfig.execute", new Object[]{this.context.getName()}), (Throwable)exception);
            }
        } else if (lifecycleEvent.getType().equals("stop")) {
            this.taglibUris.clear();
            this.webxmlTaglibUris.clear();
            this.listeners.clear();
        }
    }

    private void init() {
        if (this.tldDigester == null) {
            this.tldDigester = TldConfig.createTldDigester(this.context.getTldValidation(), this.context.getXmlBlockExternal());
        }
    }

    static {
        StringBuilder stringBuilder = new StringBuilder(System.getProperty("tomcat.util.scan.DefaultJarScanner.jarsToSkip", ""));
        String string = System.getProperty("org.apache.catalina.startup.TldConfig.jarsToSkip", "");
        if (string.length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string);
        }
        if (stringBuilder.length() > 0) {
            TldConfig.setNoTldJars(stringBuilder.toString());
        }
    }

    private class TldJarScannerCallback
    implements JarScannerCallback {
        boolean tldFound = true;

        private TldJarScannerCallback() {
        }

        public void scan(JarURLConnection jarURLConnection) throws IOException {
            this.tldFound = TldConfig.this.tldScanJar(jarURLConnection);
        }

        public void scan(File file) {
            File file2 = new File(file, "META-INF");
            if (file2.isDirectory()) {
                this.tldFound = TldConfig.this.tldScanDir(file2);
            }
        }

        private boolean scanFoundNoTLDs() {
            return !this.tldFound;
        }
    }
}

