/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.catalina.websocket.WsFrame;
import org.apache.coyote.http11.upgrade.UpgradeOutbound;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.res.StringManager;

@Deprecated
public class WsOutbound {
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.websocket");
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private final Object stateLock = new Object();
    private UpgradeOutbound upgradeOutbound;
    private StreamInbound streamInbound;
    private ByteBuffer bb;
    private CharBuffer cb;
    private boolean closed = false;
    private Boolean text = null;
    private boolean firstFrame = true;

    public WsOutbound(UpgradeOutbound upgradeOutbound, StreamInbound streamInbound) {
        this(upgradeOutbound, streamInbound, 8192, 8192);
    }

    public WsOutbound(UpgradeOutbound upgradeOutbound, StreamInbound streamInbound, int n, int n2) {
        this.upgradeOutbound = upgradeOutbound;
        this.streamInbound = streamInbound;
        this.bb = ByteBuffer.allocate(n);
        this.cb = CharBuffer.allocate(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBinaryData(int n) throws IOException {
        try {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.closed) {
                    throw new IOException(sm.getString("outbound.closed"));
                }
                if (this.bb.position() == this.bb.capacity()) {
                    this.doFlush(false);
                }
                if (this.text == null) {
                    this.text = Boolean.FALSE;
                } else if (Boolean.TRUE.equals(this.text)) {
                    this.flush();
                    this.text = Boolean.FALSE;
                }
                this.bb.put((byte)(n & 0xFF));
            }
        }
        catch (IOException iOException) {
            this.streamInbound.doOnClose(1006);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTextData(char c) throws IOException {
        try {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.closed) {
                    throw new IOException(sm.getString("outbound.closed"));
                }
                if (this.cb.position() == this.cb.capacity()) {
                    this.doFlush(false);
                }
                if (this.text == null) {
                    this.text = Boolean.TRUE;
                } else if (Boolean.FALSE.equals(this.text)) {
                    this.flush();
                    this.text = Boolean.TRUE;
                }
                this.cb.append(c);
            }
        }
        catch (IOException iOException) {
            this.streamInbound.doOnClose(1006);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBinaryMessage(ByteBuffer byteBuffer) throws IOException {
        try {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.closed) {
                    throw new IOException(sm.getString("outbound.closed"));
                }
                if (this.text != null) {
                    this.flush();
                }
                this.text = Boolean.FALSE;
                this.doWriteBytes(byteBuffer, true);
            }
        }
        catch (IOException iOException) {
            this.streamInbound.doOnClose(1006);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTextMessage(CharBuffer charBuffer) throws IOException {
        try {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.closed) {
                    throw new IOException(sm.getString("outbound.closed"));
                }
                if (this.text != null) {
                    this.flush();
                }
                this.text = Boolean.TRUE;
                this.doWriteText(charBuffer, true);
            }
        }
        catch (IOException iOException) {
            this.streamInbound.doOnClose(1006);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        try {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.closed) {
                    throw new IOException(sm.getString("outbound.closed"));
                }
                this.doFlush(true);
            }
        }
        catch (IOException iOException) {
            this.streamInbound.doOnClose(1006);
            throw iOException;
        }
    }

    private void doFlush(boolean bl) throws IOException {
        if (this.text == null) {
            return;
        }
        if (this.text.booleanValue()) {
            this.cb.flip();
            this.doWriteText(this.cb, bl);
        } else {
            this.bb.flip();
            this.doWriteBytes(this.bb, bl);
        }
    }

    protected void close(WsFrame wsFrame) throws IOException {
        if (wsFrame.getPayLoadLength() > 0L) {
            if (wsFrame.getPayLoadLength() == 1L) {
                throw new IOException();
            }
            int n = (wsFrame.getPayLoad().get() & 0xFF) << 8;
            if (this.validateCloseStatus(n += wsFrame.getPayLoad().get() & 0xFF)) {
                this.close(n, wsFrame.getPayLoad());
            } else {
                this.close(1002, null);
            }
        } else {
            this.close(0, null);
        }
    }

    private boolean validateCloseStatus(int n) {
        return n == 1000 || n == 1001 || n == 1002 || n == 1003 || n == 1007 || n == 1008 || n == 1009 || n == 1010 || n == 1011 || n > 2999 && n < 5000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int n, ByteBuffer byteBuffer) throws IOException {
        try {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                try {
                    this.doFlush(false);
                }
                finally {
                    this.closed = true;
                }
                this.upgradeOutbound.write(136);
                if (n == 0) {
                    this.upgradeOutbound.write(0);
                } else if (byteBuffer == null || byteBuffer.position() == byteBuffer.limit()) {
                    this.upgradeOutbound.write(2);
                    this.upgradeOutbound.write(n >>> 8);
                    this.upgradeOutbound.write(n);
                } else {
                    this.upgradeOutbound.write(2 + byteBuffer.limit() - byteBuffer.position());
                    this.upgradeOutbound.write(n >>> 8);
                    this.upgradeOutbound.write(n);
                    this.upgradeOutbound.write(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit() - byteBuffer.position());
                }
                this.upgradeOutbound.flush();
                this.bb = null;
                this.cb = null;
                this.upgradeOutbound = null;
            }
        }
        catch (IOException iOException) {
            this.streamInbound.doOnClose(1006);
            throw iOException;
        }
    }

    public void pong(ByteBuffer byteBuffer) throws IOException {
        this.sendControlMessage(byteBuffer, (byte)10);
    }

    public void ping(ByteBuffer byteBuffer) throws IOException {
        this.sendControlMessage(byteBuffer, (byte)9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendControlMessage(ByteBuffer byteBuffer, byte by) throws IOException {
        try {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.closed) {
                    throw new IOException(sm.getString("outbound.closed"));
                }
                this.doFlush(false);
                this.upgradeOutbound.write(0x80 | by);
                if (byteBuffer == null) {
                    this.upgradeOutbound.write(0);
                } else {
                    this.upgradeOutbound.write(byteBuffer.limit() - byteBuffer.position());
                    this.upgradeOutbound.write(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit() - byteBuffer.position());
                }
                this.upgradeOutbound.flush();
            }
        }
        catch (IOException iOException) {
            this.streamInbound.doOnClose(1006);
            throw iOException;
        }
    }

    private void doWriteBytes(ByteBuffer byteBuffer, boolean bl) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("outbound.closed"));
        }
        int n = 0;
        if (bl) {
            n += 128;
        }
        if (this.firstFrame) {
            n = this.text.booleanValue() ? ++n : (n += 2);
        }
        this.upgradeOutbound.write(n);
        if (byteBuffer.limit() < 126) {
            this.upgradeOutbound.write(byteBuffer.limit());
        } else if (byteBuffer.limit() < 65536) {
            this.upgradeOutbound.write(126);
            this.upgradeOutbound.write(byteBuffer.limit() >>> 8);
            this.upgradeOutbound.write(byteBuffer.limit() & 0xFF);
        } else {
            this.upgradeOutbound.write(127);
            this.upgradeOutbound.write(0);
            this.upgradeOutbound.write(0);
            this.upgradeOutbound.write(0);
            this.upgradeOutbound.write(0);
            this.upgradeOutbound.write(byteBuffer.limit() >>> 24);
            this.upgradeOutbound.write(byteBuffer.limit() >>> 16);
            this.upgradeOutbound.write(byteBuffer.limit() >>> 8);
            this.upgradeOutbound.write(byteBuffer.limit() & 0xFF);
        }
        this.upgradeOutbound.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
        this.upgradeOutbound.flush();
        if (bl) {
            this.text = null;
            this.firstFrame = true;
        } else {
            this.firstFrame = false;
        }
        this.bb.clear();
    }

    private void doWriteText(CharBuffer charBuffer, boolean bl) throws IOException {
        CharsetEncoder charsetEncoder = B2CConverter.UTF_8.newEncoder();
        do {
            CoderResult coderResult;
            if ((coderResult = charsetEncoder.encode(charBuffer, this.bb, true)).isError()) {
                coderResult.throwException();
            }
            this.bb.flip();
            if (charBuffer.hasRemaining()) {
                this.doWriteBytes(this.bb, false);
                continue;
            }
            this.doWriteBytes(this.bb, bl);
        } while (charBuffer.hasRemaining());
        this.cb.clear();
    }
}

