/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.Iterator;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.WebXml;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.jasper.xmlparser.TreeNode;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class JspConfig {
    private final Log log = LogFactory.getLog(JspConfig.class);
    private Vector<JspPropertyGroup> jspProperties = null;
    private ServletContext ctxt;
    private volatile boolean initialized = false;
    private static final String defaultIsXml = null;
    private String defaultIsELIgnored = null;
    private static final String defaultIsScriptingInvalid = null;
    private String defaultDeferedSyntaxAllowedAsLiteral = null;
    private static final String defaultTrimDirectiveWhitespaces = null;
    private static final String defaultDefaultContentType = null;
    private static final String defaultBuffer = null;
    private static final String defaultErrorOnUndeclaredNamespace = "false";
    private JspProperty defaultJspProperty;

    public JspConfig(ServletContext servletContext) {
        this.ctxt = servletContext;
    }

    private double getVersion(TreeNode treeNode) {
        String string = treeNode.findAttribute("version");
        if (string != null) {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 2.3;
    }

    private void processWebDotXml() throws JasperException {
        WebXml webXml = null;
        try {
            Object object;
            webXml = new WebXml(this.ctxt);
            boolean bl = Boolean.parseBoolean(this.ctxt.getInitParameter("org.apache.jasper.XML_VALIDATE"));
            String string = this.ctxt.getInitParameter("org.apache.jasper.XML_BLOCK_EXTERNAL");
            boolean bl2 = string == null ? true : Boolean.parseBoolean(string);
            TreeNode treeNode = null;
            if (webXml.getInputSource() != null) {
                object = new ParserUtils(bl, bl2);
                treeNode = ((ParserUtils)object).parseXMLDocument(webXml.getSystemId(), webXml.getInputSource());
            }
            if (treeNode == null || this.getVersion(treeNode) < 2.4) {
                this.defaultIsELIgnored = "true";
                this.defaultDeferedSyntaxAllowedAsLiteral = "true";
                return;
            }
            if (this.getVersion(treeNode) < 2.5) {
                this.defaultDeferedSyntaxAllowedAsLiteral = "true";
            }
            if ((object = treeNode.findChild("jsp-config")) == null) {
                return;
            }
            this.jspProperties = new Vector();
            Iterator<TreeNode> iterator = ((TreeNode)object).findChildren("jsp-property-group");
            while (iterator.hasNext()) {
                TreeNode treeNode2 = iterator.next();
                Iterator<TreeNode> iterator2 = treeNode2.findChildren();
                Vector<String> vector = new Vector<String>();
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                Vector<String> vector2 = new Vector<String>();
                Vector<String> vector3 = new Vector<String>();
                String string6 = null;
                String string7 = null;
                String string8 = null;
                String string9 = null;
                String string10 = null;
                while (iterator2.hasNext()) {
                    treeNode2 = iterator2.next();
                    String string11 = treeNode2.getName();
                    if ("url-pattern".equals(string11)) {
                        vector.addElement(treeNode2.getBody());
                        continue;
                    }
                    if ("page-encoding".equals(string11)) {
                        string2 = treeNode2.getBody();
                        continue;
                    }
                    if ("is-xml".equals(string11)) {
                        string5 = treeNode2.getBody();
                        continue;
                    }
                    if ("el-ignored".equals(string11)) {
                        string4 = treeNode2.getBody();
                        continue;
                    }
                    if ("scripting-invalid".equals(string11)) {
                        string3 = treeNode2.getBody();
                        continue;
                    }
                    if ("include-prelude".equals(string11)) {
                        vector2.addElement(treeNode2.getBody());
                        continue;
                    }
                    if ("include-coda".equals(string11)) {
                        vector3.addElement(treeNode2.getBody());
                        continue;
                    }
                    if ("deferred-syntax-allowed-as-literal".equals(string11)) {
                        string6 = treeNode2.getBody();
                        continue;
                    }
                    if ("trim-directive-whitespaces".equals(string11)) {
                        string7 = treeNode2.getBody();
                        continue;
                    }
                    if ("default-content-type".equals(string11)) {
                        string8 = treeNode2.getBody();
                        continue;
                    }
                    if ("buffer".equals(string11)) {
                        string9 = treeNode2.getBody();
                        continue;
                    }
                    if (!"error-on-undeclared-namespace".equals(string11)) continue;
                    string10 = treeNode2.getBody();
                }
                if (vector.size() == 0) continue;
                for (int i = 0; i < vector.size(); ++i) {
                    Object object2;
                    String string12 = (String)vector.elementAt(i);
                    String string13 = null;
                    String string14 = null;
                    if (string12.indexOf(42) < 0) {
                        string13 = string12;
                    } else {
                        int n = string12.lastIndexOf(47);
                        if (n >= 0) {
                            string13 = string12.substring(0, n + 1);
                            object2 = string12.substring(n + 1);
                        } else {
                            object2 = string12;
                        }
                        if (((String)object2).equals("*")) {
                            string14 = "*";
                        } else if (((String)object2).startsWith("*.")) {
                            string14 = ((String)object2).substring(((String)object2).indexOf(46) + 1);
                        }
                        boolean bl3 = "*".equals(string14);
                        if (string13 == null && (string14 == null || bl3) || string13 != null && !bl3) {
                            if (!this.log.isWarnEnabled()) continue;
                            this.log.warn((Object)Localizer.getMessage("jsp.warning.bad.urlpattern.propertygroup", string12));
                            continue;
                        }
                    }
                    JspProperty jspProperty = new JspProperty(string5, string4, string3, string2, vector2, vector3, string6, string7, string8, string9, string10);
                    object2 = new JspPropertyGroup(string13, string14, jspProperty);
                    this.jspProperties.addElement((JspPropertyGroup)object2);
                }
            }
        }
        catch (Exception exception) {
            throw new JasperException(exception);
        }
        finally {
            if (webXml != null) {
                webXml.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws JasperException {
        if (!this.initialized) {
            JspConfig jspConfig = this;
            synchronized (jspConfig) {
                if (!this.initialized) {
                    this.processWebDotXml();
                    this.defaultJspProperty = new JspProperty(defaultIsXml, this.defaultIsELIgnored, defaultIsScriptingInvalid, null, null, null, this.defaultDeferedSyntaxAllowedAsLiteral, defaultTrimDirectiveWhitespaces, defaultDefaultContentType, defaultBuffer, defaultErrorOnUndeclaredNamespace);
                    this.initialized = true;
                }
            }
        }
    }

    private JspPropertyGroup selectProperty(JspPropertyGroup jspPropertyGroup, JspPropertyGroup jspPropertyGroup2) {
        if (jspPropertyGroup == null) {
            return jspPropertyGroup2;
        }
        if (jspPropertyGroup.getExtension() == null) {
            return jspPropertyGroup;
        }
        if (jspPropertyGroup2.getExtension() == null) {
            return jspPropertyGroup2;
        }
        String string = jspPropertyGroup.getPath();
        String string2 = jspPropertyGroup2.getPath();
        if (string == null && string2 == null) {
            return jspPropertyGroup;
        }
        if (string == null && string2 != null) {
            return jspPropertyGroup2;
        }
        if (string != null && string2 == null) {
            return jspPropertyGroup;
        }
        if (string.length() >= string2.length()) {
            return jspPropertyGroup;
        }
        return jspPropertyGroup2;
    }

    /*
     * WARNING - void declaration
     */
    public JspProperty findJspProperty(String string) throws JasperException {
        void var17_20;
        String string2;
        String string3;
        Object object;
        this.init();
        if (this.jspProperties == null || string.endsWith(".tag") || string.endsWith(".tagx")) {
            return this.defaultJspProperty;
        }
        String string4 = null;
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            string4 = string.substring(0, n + 1);
        }
        String string5 = null;
        n = string.lastIndexOf(46);
        if (n >= 0) {
            string5 = string.substring(n + 1);
        }
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        JspPropertyGroup jspPropertyGroup = null;
        JspPropertyGroup jspPropertyGroup2 = null;
        JspPropertyGroup jspPropertyGroup3 = null;
        JspPropertyGroup jspPropertyGroup4 = null;
        JspPropertyGroup jspPropertyGroup5 = null;
        JspPropertyGroup jspPropertyGroup6 = null;
        JspPropertyGroup jspPropertyGroup7 = null;
        JspPropertyGroup jspPropertyGroup8 = null;
        JspPropertyGroup jspPropertyGroup9 = null;
        for (JspPropertyGroup object22 : this.jspProperties) {
            object = object22.getJspProperty();
            string3 = object22.getExtension();
            string2 = object22.getPath();
            if (string3 != null ? string2 != null && string4 != null && !string4.startsWith(string2) || !string3.equals("*") && !string3.equals(string5) : !string.equals(string2)) continue;
            if (((JspProperty)object).getIncludePrelude() != null) {
                vector.addAll(((JspProperty)object).getIncludePrelude());
            }
            if (((JspProperty)object).getIncludeCoda() != null) {
                vector2.addAll(((JspProperty)object).getIncludeCoda());
            }
            if (((JspProperty)object).isXml() != null) {
                jspPropertyGroup = this.selectProperty(jspPropertyGroup, object22);
            }
            if (((JspProperty)object).isELIgnored() != null) {
                jspPropertyGroup2 = this.selectProperty(jspPropertyGroup2, object22);
            }
            if (((JspProperty)object).isScriptingInvalid() != null) {
                jspPropertyGroup3 = this.selectProperty(jspPropertyGroup3, object22);
            }
            if (((JspProperty)object).getPageEncoding() != null) {
                jspPropertyGroup4 = this.selectProperty(jspPropertyGroup4, object22);
            }
            if (((JspProperty)object).isDeferedSyntaxAllowedAsLiteral() != null) {
                jspPropertyGroup5 = this.selectProperty(jspPropertyGroup5, object22);
            }
            if (((JspProperty)object).isTrimDirectiveWhitespaces() != null) {
                jspPropertyGroup6 = this.selectProperty(jspPropertyGroup6, object22);
            }
            if (((JspProperty)object).getDefaultContentType() != null) {
                jspPropertyGroup7 = this.selectProperty(jspPropertyGroup7, object22);
            }
            if (((JspProperty)object).getBuffer() != null) {
                jspPropertyGroup8 = this.selectProperty(jspPropertyGroup8, object22);
            }
            if (((JspProperty)object).isErrorOnUndeclaredNamespace() == null) continue;
            jspPropertyGroup9 = this.selectProperty(jspPropertyGroup9, object22);
        }
        String string6 = defaultIsXml;
        object = this.defaultIsELIgnored;
        string3 = defaultIsScriptingInvalid;
        string2 = null;
        String string7 = this.defaultDeferedSyntaxAllowedAsLiteral;
        String string8 = defaultTrimDirectiveWhitespaces;
        String string9 = defaultDefaultContentType;
        String string10 = defaultBuffer;
        String string11 = defaultErrorOnUndeclaredNamespace;
        if (jspPropertyGroup != null) {
            String string12 = jspPropertyGroup.getJspProperty().isXml();
        }
        if (jspPropertyGroup2 != null) {
            object = jspPropertyGroup2.getJspProperty().isELIgnored();
        }
        if (jspPropertyGroup3 != null) {
            string3 = jspPropertyGroup3.getJspProperty().isScriptingInvalid();
        }
        if (jspPropertyGroup4 != null) {
            string2 = jspPropertyGroup4.getJspProperty().getPageEncoding();
        }
        if (jspPropertyGroup5 != null) {
            string7 = jspPropertyGroup5.getJspProperty().isDeferedSyntaxAllowedAsLiteral();
        }
        if (jspPropertyGroup6 != null) {
            string8 = jspPropertyGroup6.getJspProperty().isTrimDirectiveWhitespaces();
        }
        if (jspPropertyGroup7 != null) {
            string9 = jspPropertyGroup7.getJspProperty().getDefaultContentType();
        }
        if (jspPropertyGroup8 != null) {
            string10 = jspPropertyGroup8.getJspProperty().getBuffer();
        }
        if (jspPropertyGroup9 != null) {
            string11 = jspPropertyGroup9.getJspProperty().isErrorOnUndeclaredNamespace();
        }
        return new JspProperty((String)var17_20, (String)object, string3, string2, vector, vector2, string7, string8, string9, string10, string11);
    }

    public boolean isJspPage(String string) throws JasperException {
        this.init();
        if (this.jspProperties == null) {
            return false;
        }
        String string2 = null;
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            string2 = string.substring(0, n + 1);
        }
        String string3 = null;
        n = string.lastIndexOf(46);
        if (n >= 0) {
            string3 = string.substring(n + 1);
        }
        for (JspPropertyGroup jspPropertyGroup : this.jspProperties) {
            String string4 = jspPropertyGroup.getExtension();
            String string5 = jspPropertyGroup.getPath();
            if (!(string4 == null ? string.equals(string5) : !(string5 != null && !string5.equals(string2) || !string4.equals("*") && !string4.equals(string3)))) continue;
            return true;
        }
        return false;
    }

    public static class JspProperty {
        private String isXml;
        private String elIgnored;
        private String scriptingInvalid;
        private String pageEncoding;
        private Vector<String> includePrelude;
        private Vector<String> includeCoda;
        private String deferedSyntaxAllowedAsLiteral;
        private String trimDirectiveWhitespaces;
        private String defaultContentType;
        private String buffer;
        private String errorOnUndeclaredNamespace;

        public JspProperty(String string, String string2, String string3, String string4, Vector<String> vector, Vector<String> vector2, String string5, String string6, String string7, String string8, String string9) {
            this.isXml = string;
            this.elIgnored = string2;
            this.scriptingInvalid = string3;
            this.pageEncoding = string4;
            this.includePrelude = vector;
            this.includeCoda = vector2;
            this.deferedSyntaxAllowedAsLiteral = string5;
            this.trimDirectiveWhitespaces = string6;
            this.defaultContentType = string7;
            this.buffer = string8;
            this.errorOnUndeclaredNamespace = string9;
        }

        public String isXml() {
            return this.isXml;
        }

        public String isELIgnored() {
            return this.elIgnored;
        }

        public String isScriptingInvalid() {
            return this.scriptingInvalid;
        }

        public String getPageEncoding() {
            return this.pageEncoding;
        }

        public Vector<String> getIncludePrelude() {
            return this.includePrelude;
        }

        public Vector<String> getIncludeCoda() {
            return this.includeCoda;
        }

        public String isDeferedSyntaxAllowedAsLiteral() {
            return this.deferedSyntaxAllowedAsLiteral;
        }

        public String isTrimDirectiveWhitespaces() {
            return this.trimDirectiveWhitespaces;
        }

        public String getDefaultContentType() {
            return this.defaultContentType;
        }

        public String getBuffer() {
            return this.buffer;
        }

        public String isErrorOnUndeclaredNamespace() {
            return this.errorOnUndeclaredNamespace;
        }
    }

    public static class JspPropertyGroup {
        private String path;
        private String extension;
        private JspProperty jspProperty;

        JspPropertyGroup(String string, String string2, JspProperty jspProperty) {
            this.path = string;
            this.extension = string2;
            this.jspProperty = jspProperty;
        }

        public String getPath() {
            return this.path;
        }

        public String getExtension() {
            return this.extension;
        }

        public JspProperty getJspProperty() {
            return this.jspProperty;
        }
    }
}

