/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.xmlparser;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.xmlparser.TreeNode;
import org.apache.tomcat.util.descriptor.DigesterFactory;
import org.apache.tomcat.util.descriptor.LocalResolver;
import org.apache.tomcat.util.descriptor.XmlErrorHandler;
import org.apache.tomcat.util.security.PrivilegedGetTccl;
import org.apache.tomcat.util.security.PrivilegedSetTccl;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ParserUtils {
    static EntityResolver entityResolver;
    private final EntityResolver entityResolverInstance;
    private final boolean validating;

    public ParserUtils(boolean bl) {
        this(bl, Constants.IS_SECURITY_ENABLED);
    }

    public ParserUtils(boolean bl, boolean bl2) {
        this.validating = bl;
        this.entityResolverInstance = entityResolver == null ? new LocalResolver(DigesterFactory.SERVLET_API_PUBLIC_IDS, DigesterFactory.SERVLET_API_SYSTEM_IDS, bl2) : entityResolver;
    }

    public TreeNode parseXMLDocument(String string, InputSource inputSource) throws JasperException {
        ClassLoader classLoader;
        Object object;
        Document document = null;
        if (Constants.IS_SECURITY_ENABLED) {
            object = new PrivilegedGetTccl();
            classLoader = (ClassLoader)AccessController.doPrivileged(object);
        } else {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        try {
            if (Constants.IS_SECURITY_ENABLED) {
                object = new PrivilegedSetTccl(ParserUtils.class.getClassLoader());
                AccessController.doPrivileged(object);
            } else {
                Thread.currentThread().setContextClassLoader(ParserUtils.class.getClassLoader());
            }
            object = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object).setNamespaceAware(true);
            ((DocumentBuilderFactory)object).setValidating(this.validating);
            if (this.validating) {
                ((DocumentBuilderFactory)object).setFeature("http://xml.org/sax/features/validation", true);
                ((DocumentBuilderFactory)object).setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            documentBuilder.setEntityResolver(this.entityResolverInstance);
            XmlErrorHandler xmlErrorHandler = new XmlErrorHandler();
            documentBuilder.setErrorHandler((ErrorHandler)xmlErrorHandler);
            document = documentBuilder.parse(inputSource);
            if (!xmlErrorHandler.getErrors().isEmpty()) {
                throw (SAXParseException)xmlErrorHandler.getErrors().iterator().next();
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JasperException(Localizer.getMessage("jsp.error.parse.xml", string), parserConfigurationException);
        }
        catch (SAXParseException sAXParseException) {
            throw new JasperException(Localizer.getMessage("jsp.error.parse.xml.line", string, Integer.toString(sAXParseException.getLineNumber()), Integer.toString(sAXParseException.getColumnNumber())), sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new JasperException(Localizer.getMessage("jsp.error.parse.xml", string), sAXException);
        }
        catch (IOException iOException) {
            throw new JasperException(Localizer.getMessage("jsp.error.parse.xml", string), iOException);
        }
        finally {
            if (Constants.IS_SECURITY_ENABLED) {
                PrivilegedSetTccl privilegedSetTccl = new PrivilegedSetTccl(classLoader);
                AccessController.doPrivileged(privilegedSetTccl);
            } else {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        return this.convert(null, document.getDocumentElement());
    }

    public TreeNode parseXMLDocument(String string, InputStream inputStream) throws JasperException {
        return this.parseXMLDocument(string, new InputSource(inputStream));
    }

    public static void setEntityResolver(EntityResolver entityResolver) {
        ParserUtils.entityResolver = entityResolver;
    }

    protected TreeNode convert(TreeNode treeNode, Node node) {
        NodeList nodeList;
        int n;
        TreeNode treeNode2 = new TreeNode(node.getNodeName(), treeNode);
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n2 = namedNodeMap.getLength();
            for (n = 0; n < n2; ++n) {
                Node node2 = namedNodeMap.item(n);
                treeNode2.addAttribute(node2.getNodeName(), node2.getNodeValue());
            }
        }
        if ((nodeList = node.getChildNodes()) != null) {
            n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node3 = nodeList.item(i);
                if (node3 instanceof Comment) continue;
                if (node3 instanceof Text) {
                    String string = ((Text)node3).getData();
                    if (string == null || (string = string.trim()).length() <= 0) continue;
                    treeNode2.setBody(string);
                    continue;
                }
                this.convert(treeNode2, node3);
            }
        }
        return treeNode2;
    }
}

