/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.LogManager;
import org.apache.juli.logging.DirectJDKLog;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogConfigurationException;

public class LogFactory {
    public static final String FACTORY_PROPERTY = "org.apache.commons.logging.LogFactory";
    public static final String FACTORY_DEFAULT = "org.apache.commons.logging.impl.LogFactoryImpl";
    public static final String FACTORY_PROPERTIES = "commons-logging.properties";
    public static final String HASHTABLE_IMPLEMENTATION_PROPERTY = "org.apache.commons.logging.LogFactory.HashtableImpl";
    private static LogFactory singleton = new LogFactory();
    Properties logConfig;

    private LogFactory() {
        try {
            Class<?> clazz = Class.forName("java.nio.file.FileSystems");
            Method method = clazz.getMethod("getDefault", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        this.logConfig = new Properties();
    }

    void setLogConfig(Properties properties) {
        this.logConfig = properties;
    }

    public Log getInstance(String string) throws LogConfigurationException {
        return DirectJDKLog.getInstance(string);
    }

    public void release() {
        DirectJDKLog.release();
    }

    public Object getAttribute(String string) {
        return this.logConfig.get(string);
    }

    public String[] getAttributeNames() {
        String[] stringArray = new String[this.logConfig.size()];
        return this.logConfig.keySet().toArray(stringArray);
    }

    public void removeAttribute(String string) {
        this.logConfig.remove(string);
    }

    public void setAttribute(String string, Object object) {
        this.logConfig.put(string, object);
    }

    public Log getInstance(Class<?> clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    public static LogFactory getFactory() throws LogConfigurationException {
        return singleton;
    }

    public static Log getLog(Class<?> clazz) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(clazz);
    }

    public static Log getLog(String string) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(string);
    }

    public static void release(ClassLoader classLoader) {
        if (!LogManager.getLogManager().getClass().getName().equals("java.util.logging.LogManager")) {
            LogManager.getLogManager().reset();
        }
    }

    public static void releaseAll() {
        singleton.release();
    }

    public static String objectId(Object object) {
        if (object == null) {
            return "null";
        }
        return object.getClass().getName() + "@" + System.identityHashCode(object);
    }
}

