/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Constants;

public class CaseInsensitiveKeyMap<V>
extends AbstractMap<String, V> {
    private static final StringManager sm = StringManager.getManager((String)Constants.PACKAGE_NAME);
    private final Map<Key, V> map = new HashMap<Key, V>();

    @Override
    public V get(Object object) {
        return this.map.get(Key.getInstance(object));
    }

    @Override
    public V put(String string, V v) {
        Key key = Key.getInstance(string);
        if (key == null) {
            throw new NullPointerException(sm.getString("caseInsensitiveKeyMap.nullKey"));
        }
        return this.map.put(key, v);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> map) {
        super.putAll(map);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(Key.getInstance(object));
    }

    @Override
    public V remove(Object object) {
        return this.map.remove(Key.getInstance(object));
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return new EntrySet<V>(this.map.entrySet());
    }

    private static class Key {
        private final String key;
        private final String lcKey;

        private Key(String string) {
            this.key = string;
            this.lcKey = string.toLowerCase(Locale.ENGLISH);
        }

        public String getKey() {
            return this.key;
        }

        public int hashCode() {
            return this.lcKey.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Key key = (Key)object;
            return this.lcKey.equals(key.lcKey);
        }

        public static Key getInstance(Object object) {
            if (object instanceof String) {
                return new Key((String)object);
            }
            return null;
        }
    }

    private static class EntryImpl<V>
    implements Map.Entry<String, V> {
        private final String key;
        private final V value;

        public EntryImpl(String string, V v) {
            this.key = string;
            this.value = v;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException();
        }
    }

    private static class EntryIterator<V>
    implements Iterator<Map.Entry<String, V>> {
        private final Iterator<Map.Entry<Key, V>> iterator;

        public EntryIterator(Iterator<Map.Entry<Key, V>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<String, V> next() {
            Map.Entry<Key, V> entry = this.iterator.next();
            return new EntryImpl<V>(entry.getKey().getKey(), entry.getValue());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static class EntrySet<V>
    extends AbstractSet<Map.Entry<String, V>> {
        private final Set<Map.Entry<Key, V>> entrySet;

        public EntrySet(Set<Map.Entry<Key, V>> set) {
            this.entrySet = set;
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return new EntryIterator<V>(this.entrySet.iterator());
        }

        @Override
        public int size() {
            return this.entrySet.size();
        }
    }
}

