/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.el.util.JreCompat;

class Jre9Compat
extends JreCompat {
    private static final Method canAccessMethod;

    Jre9Compat() {
    }

    public static boolean isSupported() {
        return canAccessMethod != null;
    }

    @Override
    public boolean canAccess(Object object, AccessibleObject accessibleObject) {
        try {
            return (Boolean)canAccessMethod.invoke((Object)accessibleObject, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
    }

    static {
        Method method = null;
        try {
            method = AccessibleObject.class.getMethod("canAccess", Object.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        canAccessMethod = method;
    }
}

