/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp.datasources;

import java.io.IOException;
import java.util.Map;
import javax.naming.RefAddr;
import javax.naming.Reference;
import org.apache.tomcat.dbcp.dbcp.datasources.InstanceKeyDataSource;
import org.apache.tomcat.dbcp.dbcp.datasources.InstanceKeyObjectFactory;
import org.apache.tomcat.dbcp.dbcp.datasources.PerUserPoolDataSource;

public class PerUserPoolDataSourceFactory
extends InstanceKeyObjectFactory {
    private static final String PER_USER_POOL_CLASSNAME = PerUserPoolDataSource.class.getName();

    @Override
    protected boolean isCorrectClass(String string) {
        return PER_USER_POOL_CLASSNAME.equals(string);
    }

    @Override
    protected InstanceKeyDataSource getNewInstance(Reference reference) throws IOException, ClassNotFoundException {
        byte[] byArray;
        PerUserPoolDataSource perUserPoolDataSource = new PerUserPoolDataSource();
        RefAddr refAddr = reference.get("defaultMaxActive");
        if (refAddr != null && refAddr.getContent() != null) {
            perUserPoolDataSource.setDefaultMaxActive(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("defaultMaxIdle")) != null && refAddr.getContent() != null) {
            perUserPoolDataSource.setDefaultMaxIdle(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("defaultMaxWait")) != null && refAddr.getContent() != null) {
            perUserPoolDataSource.setDefaultMaxWait(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("perUserDefaultAutoCommit")) != null && refAddr.getContent() != null) {
            byArray = (byte[])refAddr.getContent();
            perUserPoolDataSource.perUserDefaultAutoCommit = (Map)PerUserPoolDataSourceFactory.deserialize(byArray);
        }
        if ((refAddr = reference.get("perUserDefaultTransactionIsolation")) != null && refAddr.getContent() != null) {
            byArray = (byte[])refAddr.getContent();
            perUserPoolDataSource.perUserDefaultTransactionIsolation = (Map)PerUserPoolDataSourceFactory.deserialize(byArray);
        }
        if ((refAddr = reference.get("perUserMaxActive")) != null && refAddr.getContent() != null) {
            byArray = (byte[])refAddr.getContent();
            perUserPoolDataSource.perUserMaxActive = (Map)PerUserPoolDataSourceFactory.deserialize(byArray);
        }
        if ((refAddr = reference.get("perUserMaxIdle")) != null && refAddr.getContent() != null) {
            byArray = (byte[])refAddr.getContent();
            perUserPoolDataSource.perUserMaxIdle = (Map)PerUserPoolDataSourceFactory.deserialize(byArray);
        }
        if ((refAddr = reference.get("perUserMaxWait")) != null && refAddr.getContent() != null) {
            byArray = (byte[])refAddr.getContent();
            perUserPoolDataSource.perUserMaxWait = (Map)PerUserPoolDataSourceFactory.deserialize(byArray);
        }
        if ((refAddr = reference.get("perUserDefaultReadOnly")) != null && refAddr.getContent() != null) {
            byArray = (byte[])refAddr.getContent();
            perUserPoolDataSource.perUserDefaultReadOnly = (Map)PerUserPoolDataSourceFactory.deserialize(byArray);
        }
        return perUserPoolDataSource;
    }
}

