/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.Processor;
import org.apache.coyote.ajp.AbstractAjpProtocol;
import org.apache.coyote.ajp.AjpAprProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.net.SocketWrapper;

public class AjpAprProtocol
extends AbstractAjpProtocol<Long> {
    private static final Log log = LogFactory.getLog(AjpAprProtocol.class);
    private AjpConnectionHandler cHandler;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected AbstractEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    @Override
    public boolean isAprRequired() {
        return true;
    }

    public AjpAprProtocol() {
        this.endpoint = new AprEndpoint();
        this.endpoint.setAddress(JreCompat.getInstance().getLoopbackAddress());
        this.cHandler = new AjpConnectionHandler(this);
        ((AprEndpoint)this.endpoint).setHandler(this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(-1);
        this.setTcpNoDelay(true);
        ((AprEndpoint)this.endpoint).setUseSendfile(false);
    }

    public int getPollTime() {
        return ((AprEndpoint)this.endpoint).getPollTime();
    }

    public void setPollTime(int n) {
        ((AprEndpoint)this.endpoint).setPollTime(n);
    }

    public void setPollerSize(int n) {
        this.endpoint.setMaxConnections(n);
    }

    public int getPollerSize() {
        return this.endpoint.getMaxConnections();
    }

    @Override
    protected String getNamePrefix() {
        return "ajp-apr";
    }

    protected static class AjpConnectionHandler
    extends AbstractAjpProtocol.AbstractAjpConnectionHandler<Long, AjpAprProcessor>
    implements AprEndpoint.Handler {
        protected AjpAprProtocol proto;

        public AjpConnectionHandler(AjpAprProtocol ajpAprProtocol) {
            this.proto = ajpAprProtocol;
        }

        @Override
        protected AbstractProtocol<Long> getProtocol() {
            return this.proto;
        }

        @Override
        protected Log getLog() {
            return log;
        }

        @Override
        public void release(SocketWrapper<Long> socketWrapper, Processor<Long> processor, boolean bl, boolean bl2) {
            processor.recycle(bl);
            this.recycledProcessors.offer(processor);
            if (bl2) {
                ((AprEndpoint)this.proto.endpoint).getPoller().add(socketWrapper.getSocket(), this.proto.endpoint.getKeepAliveTimeout(), true, false);
            }
        }

        @Override
        protected AjpAprProcessor createProcessor() {
            AjpAprProcessor ajpAprProcessor = new AjpAprProcessor(this.proto.packetSize, (AprEndpoint)this.proto.endpoint);
            ajpAprProcessor.setAdapter(this.proto.adapter);
            ajpAprProcessor.setAjpFlush(this.proto.getAjpFlush());
            ajpAprProcessor.setTomcatAuthentication(this.proto.tomcatAuthentication);
            ajpAprProcessor.setTomcatAuthorization(this.proto.getTomcatAuthorization());
            ajpAprProcessor.setSecret(this.proto.getSecret());
            ajpAprProcessor.setKeepAliveTimeout(this.proto.getKeepAliveTimeout());
            ajpAprProcessor.setClientCertProvider(this.proto.getClientCertProvider());
            ajpAprProcessor.setMaxCookieCount(this.proto.getMaxCookieCount());
            ajpAprProcessor.setAllowedRequestAttributesPatternPattern(this.proto.getAllowedRequestAttributesPatternPattern());
            this.register(ajpAprProcessor);
            return ajpAprProcessor;
        }
    }
}

