/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.coyote.AbstractProcessor;
import org.apache.coyote.ActionCode;
import org.apache.coyote.AsyncContextCallback;
import org.apache.coyote.ErrorState;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.Constants;
import org.apache.coyote.http11.HeadersTooLargeException;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.coyote.http11.filters.ChunkedInputFilter;
import org.apache.coyote.http11.filters.ChunkedOutputFilter;
import org.apache.coyote.http11.filters.GzipOutputFilter;
import org.apache.coyote.http11.filters.IdentityInputFilter;
import org.apache.coyote.http11.filters.IdentityOutputFilter;
import org.apache.coyote.http11.filters.SavedRequestInputFilter;
import org.apache.coyote.http11.filters.VoidInputFilter;
import org.apache.coyote.http11.filters.VoidOutputFilter;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.apache.coyote.http11.upgrade.servlet31.HttpUpgradeHandler;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.AbstractChunk;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.ResponseUtil;
import org.apache.tomcat.util.http.parser.AcceptEncoding;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.http.parser.TokenList;
import org.apache.tomcat.util.log.UserDataHelper;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractHttp11Processor<S>
extends AbstractProcessor<S> {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.coyote.http11");
    private int pluggableFilterIndex = Integer.MAX_VALUE;
    protected boolean keepAlive = true;
    protected boolean openSocket = false;
    protected boolean keptAlive;
    protected boolean sendfileInProgress = false;
    protected boolean readComplete = true;
    protected boolean http11 = true;
    protected boolean http09 = false;
    protected boolean contentDelimitation = true;
    protected boolean expectation = false;
    protected boolean comet = false;
    protected Pattern restrictedUserAgents = null;
    protected int maxKeepAliveRequests = -1;
    protected int keepAliveTimeout = -1;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected String localName = null;
    protected int localPort = -1;
    protected int remotePort = -1;
    protected String localAddr = null;
    protected int connectionUploadTimeout = 300000;
    protected boolean disableUploadTimeout = false;
    protected int compressionLevel = 0;
    protected boolean noCompressionStrongETag = true;
    protected int compressionMinSize = 2048;
    protected int socketBuffer = -1;
    protected int maxSavePostSize = 4096;
    protected Pattern noCompressionUserAgents = null;
    protected String[] compressableMimeTypes = new String[]{"text/html", "text/xml", "text/plain"};
    protected String server = null;
    @Deprecated
    protected UpgradeInbound upgradeInbound = null;
    protected HttpUpgradeHandler httpUpgradeHandler = null;
    private boolean allowHostHeaderMismatch = true;
    protected HttpParser httpParser;

    public boolean getAllowHostHeaderMismatch() {
        return this.allowHostHeaderMismatch;
    }

    public void setAllowHostHeaderMismatch(boolean bl) {
        this.allowHostHeaderMismatch = bl;
    }

    public AbstractHttp11Processor(AbstractEndpoint<S> abstractEndpoint) {
        super(abstractEndpoint);
    }

    public void setCompression(String string) {
        if (string.equals("on")) {
            this.compressionLevel = 1;
        } else if (string.equals("force")) {
            this.compressionLevel = 2;
        } else if (string.equals("off")) {
            this.compressionLevel = 0;
        } else {
            try {
                this.compressionMinSize = Integer.parseInt(string);
                this.compressionLevel = 1;
            }
            catch (Exception exception) {
                this.compressionLevel = 0;
            }
        }
    }

    public void setCompressionMinSize(int n) {
        this.compressionMinSize = n;
    }

    public void setNoCompressionStrongETag(boolean bl) {
        this.noCompressionStrongETag = bl;
    }

    public void setNoCompressionUserAgents(String string) {
        this.noCompressionUserAgents = string == null || string.length() == 0 ? null : Pattern.compile(string);
    }

    @Deprecated
    public void addCompressableMimeType(String string) {
        this.addCompressibleMimeType(string);
    }

    @Deprecated
    public void setCompressableMimeTypes(String[] stringArray) {
        this.setCompressibleMimeTypes(stringArray);
    }

    @Deprecated
    public void setCompressableMimeTypes(String string) {
        this.setCompressibleMimeTypes(string);
    }

    public void addCompressibleMimeType(String string) {
        this.compressableMimeTypes = this.addStringArray(this.compressableMimeTypes, string);
    }

    public void setCompressibleMimeTypes(String[] stringArray) {
        this.compressableMimeTypes = stringArray;
    }

    public void setCompressibleMimeTypes(String string) {
        if (string != null) {
            this.compressableMimeTypes = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.addCompressibleMimeType(stringTokenizer.nextToken().trim());
            }
        }
    }

    public String getCompression() {
        switch (this.compressionLevel) {
            case 0: {
                return "off";
            }
            case 1: {
                return "on";
            }
            case 2: {
                return "force";
            }
        }
        return "off";
    }

    private String[] addStringArray(String[] stringArray, String string) {
        String[] stringArray2 = null;
        if (stringArray == null) {
            stringArray2 = new String[]{string};
        } else {
            stringArray2 = new String[stringArray.length + 1];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = stringArray[i];
            }
            stringArray2[stringArray.length] = string;
        }
        return stringArray2;
    }

    private boolean startsWithStringArray(String[] stringArray, String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.startsWith(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public void setRestrictedUserAgents(String string) {
        this.restrictedUserAgents = string == null || string.length() == 0 ? null : Pattern.compile(string);
    }

    public void setMaxKeepAliveRequests(int n) {
        this.maxKeepAliveRequests = n;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setKeepAliveTimeout(int n) {
        this.keepAliveTimeout = n;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setMaxSavePostSize(int n) {
        this.maxSavePostSize = n;
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setDisableUploadTimeout(boolean bl) {
        this.disableUploadTimeout = bl;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setSocketBuffer(int n) {
        this.socketBuffer = n;
    }

    public int getSocketBuffer() {
        return this.socketBuffer;
    }

    public void setConnectionUploadTimeout(int n) {
        this.connectionUploadTimeout = n;
    }

    public int getConnectionUploadTimeout() {
        return this.connectionUploadTimeout;
    }

    public void setServer(String string) {
        this.server = string == null || string.equals("") ? null : string;
    }

    public String getServer() {
        return this.server;
    }

    private boolean isCompressible() {
        Object object;
        MimeHeaders mimeHeaders = this.response.getMimeHeaders();
        MessageBytes messageBytes = mimeHeaders.getValue("Content-Encoding");
        if (messageBytes != null) {
            object = new HashSet();
            try {
                TokenList.parseTokenList(mimeHeaders.values("Content-Encoding"), (Collection<String>)object);
            }
            catch (IOException iOException) {
                this.getLog().warn((Object)sm.getString("http11Processor.contentEncodingParseFail"), (Throwable)iOException);
                return false;
            }
            if (object.contains("gzip") || object.contains("br")) {
                return false;
            }
        }
        if (this.noCompressionStrongETag && (object = mimeHeaders.getHeader("ETag")) != null && !((String)object).trim().startsWith("W/")) {
            return false;
        }
        if (this.compressionLevel == 2) {
            return true;
        }
        long l = this.response.getContentLengthLong();
        if ((l == -1L || l > (long)this.compressionMinSize) && this.compressableMimeTypes != null) {
            return this.startsWithStringArray(this.compressableMimeTypes, this.response.getContentType());
        }
        return false;
    }

    private boolean useCompression() {
        Object object;
        Object object2;
        Enumeration<String> enumeration = this.request.getMimeHeaders().values("accept-encoding");
        boolean bl = false;
        block2: while (!bl && enumeration.hasMoreElements()) {
            object2 = null;
            try {
                object2 = AcceptEncoding.parse(new StringReader(enumeration.nextElement()));
            }
            catch (IOException iOException) {
                return false;
            }
            object = object2.iterator();
            while (object.hasNext()) {
                AcceptEncoding acceptEncoding = (AcceptEncoding)object.next();
                if (!"gzip".equalsIgnoreCase(acceptEncoding.getEncoding())) continue;
                bl = true;
                continue block2;
            }
        }
        if (!bl) {
            return false;
        }
        if (this.compressionLevel == 2) {
            return true;
        }
        return this.noCompressionUserAgents == null || (object2 = this.request.getMimeHeaders().getValue("user-agent")) == null || !this.noCompressionUserAgents.matcher((CharSequence)(object = ((MessageBytes)object2).toString())).matches();
    }

    @Deprecated
    protected int findBytes(ByteChunk byteChunk, byte[] byArray) {
        byte by = byArray[0];
        byte[] byArray2 = byteChunk.getBuffer();
        int n = byteChunk.getStart();
        int n2 = byteChunk.getEnd();
        int n3 = byArray.length;
        for (int i = n; i <= n2 - n3; ++i) {
            if (Ascii.toLower(byArray2[i]) != by) continue;
            int n4 = i + 1;
            int n5 = 1;
            while (n5 < n3 && Ascii.toLower(byArray2[n4++]) == byArray[n5++]) {
                if (n5 != n3) continue;
                return i - n;
            }
        }
        return -1;
    }

    protected boolean statusDropsConnection(int n) {
        return n == 400 || n == 408 || n == 411 || n == 413 || n == 414 || n == 500 || n == 503 || n == 501;
    }

    protected abstract AbstractInputBuffer<S> getInputBuffer();

    protected abstract AbstractOutputBuffer<S> getOutputBuffer();

    protected void initializeFilters(int n, Set<String> set, int n2, int n3) {
        this.getInputBuffer().addFilter(new IdentityInputFilter(n3));
        this.getOutputBuffer().addFilter(new IdentityOutputFilter());
        this.getInputBuffer().addFilter(new ChunkedInputFilter(n, set, n2, n3));
        this.getOutputBuffer().addFilter(new ChunkedOutputFilter());
        this.getInputBuffer().addFilter(new VoidInputFilter());
        this.getOutputBuffer().addFilter(new VoidOutputFilter());
        this.getInputBuffer().addFilter(new BufferedInputFilter());
        this.getOutputBuffer().addFilter(new GzipOutputFilter());
        this.pluggableFilterIndex = this.getInputBuffer().getFilters().length;
    }

    private void addInputFilter(InputFilter[] inputFilterArray, String string) {
        if (!string.equals("identity")) {
            if (string.equals("chunked")) {
                this.getInputBuffer().addActiveFilter(inputFilterArray[1]);
                this.contentDelimitation = true;
            } else {
                for (int i = this.pluggableFilterIndex; i < inputFilterArray.length; ++i) {
                    if (!inputFilterArray[i].getEncodingName().toString().equals(string)) continue;
                    this.getInputBuffer().addActiveFilter(inputFilterArray[i]);
                    return;
                }
                this.response.setStatus(501);
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((Object)(sm.getString("http11processor.request.prepare") + " Unsupported transfer encoding [" + string + "]"));
                }
            }
        }
    }

    @Override
    public final void action(ActionCode actionCode, Object object) {
        switch (actionCode) {
            case CLOSE: {
                try {
                    this.getOutputBuffer().endRequest();
                }
                catch (IOException iOException) {
                    this.setErrorState(ErrorState.CLOSE_NOW, iOException);
                }
                break;
            }
            case COMMIT: {
                if (this.response.isCommitted()) {
                    return;
                }
                try {
                    this.prepareResponse();
                    this.getOutputBuffer().commit();
                }
                catch (IOException iOException) {
                    this.setErrorState(ErrorState.CLOSE_NOW, iOException);
                }
                break;
            }
            case ACK: {
                if (this.response.isCommitted() || !this.expectation) {
                    return;
                }
                this.getInputBuffer().setSwallowInput(true);
                try {
                    this.getOutputBuffer().sendAck();
                }
                catch (IOException iOException) {
                    this.setErrorState(ErrorState.CLOSE_NOW, iOException);
                }
                break;
            }
            case CLIENT_FLUSH: {
                try {
                    this.getOutputBuffer().flush();
                }
                catch (IOException iOException) {
                    this.setErrorState(ErrorState.CLOSE_NOW, iOException);
                    this.response.setErrorException(iOException);
                }
                break;
            }
            case IS_ERROR: {
                ((AtomicBoolean)object).set(this.getErrorState().isError());
                break;
            }
            case DISABLE_SWALLOW_INPUT: {
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                this.getInputBuffer().setSwallowInput(false);
                break;
            }
            case RESET: {
                this.getOutputBuffer().reset();
                break;
            }
            case CUSTOM: {
                break;
            }
            case REQ_SET_BODY_REPLAY: {
                ByteChunk byteChunk = (ByteChunk)object;
                SavedRequestInputFilter savedRequestInputFilter = new SavedRequestInputFilter(byteChunk);
                savedRequestInputFilter.setRequest(this.request);
                AbstractInputBuffer abstractInputBuffer = (AbstractInputBuffer)this.request.getInputBuffer();
                abstractInputBuffer.addActiveFilter(savedRequestInputFilter);
                break;
            }
            case ASYNC_START: {
                this.asyncStateMachine.asyncStart((AsyncContextCallback)object);
                this.getSocketWrapper().access();
                break;
            }
            case ASYNC_DISPATCHED: {
                this.asyncStateMachine.asyncDispatched();
                break;
            }
            case ASYNC_TIMEOUT: {
                AtomicBoolean atomicBoolean = (AtomicBoolean)object;
                atomicBoolean.set(this.asyncStateMachine.asyncTimeout());
                break;
            }
            case ASYNC_RUN: {
                this.asyncStateMachine.asyncRun((Runnable)object);
                break;
            }
            case ASYNC_ERROR: {
                this.asyncStateMachine.asyncError();
                break;
            }
            case ASYNC_IS_STARTED: {
                ((AtomicBoolean)object).set(this.asyncStateMachine.isAsyncStarted());
                break;
            }
            case ASYNC_IS_COMPLETING: {
                ((AtomicBoolean)object).set(this.asyncStateMachine.isCompleting());
                break;
            }
            case ASYNC_IS_DISPATCHING: {
                ((AtomicBoolean)object).set(this.asyncStateMachine.isAsyncDispatching());
                break;
            }
            case ASYNC_IS_ASYNC: {
                ((AtomicBoolean)object).set(this.asyncStateMachine.isAsync());
                break;
            }
            case ASYNC_IS_TIMINGOUT: {
                ((AtomicBoolean)object).set(this.asyncStateMachine.isAsyncTimingOut());
                break;
            }
            case ASYNC_IS_ERROR: {
                ((AtomicBoolean)object).set(this.asyncStateMachine.isAsyncError());
                break;
            }
            case UPGRADE_TOMCAT: {
                this.upgradeInbound = (UpgradeInbound)object;
                this.getOutputBuffer().finished = true;
                break;
            }
            case ASYNC_POST_PROCESS: {
                this.asyncStateMachine.asyncPostProcess();
                break;
            }
            case UPGRADE: {
                this.httpUpgradeHandler = (HttpUpgradeHandler)object;
                this.getOutputBuffer().finished = true;
                break;
            }
            case CLOSE_NOW: {
                this.getOutputBuffer().finished = true;
                if (object instanceof Throwable) {
                    this.setErrorState(ErrorState.CLOSE_NOW, (Throwable)object);
                    break;
                }
                this.setErrorState(ErrorState.CLOSE_NOW, null);
                break;
            }
            case END_REQUEST: {
                this.endRequest();
                break;
            }
            default: {
                this.actionInternal(actionCode, object);
            }
        }
    }

    protected abstract void actionInternal(ActionCode var1, Object var2);

    protected abstract boolean disableKeepAlive();

    protected abstract void setRequestLineReadTimeout() throws IOException;

    protected abstract boolean handleIncompleteRequestLineRead();

    protected abstract void setSocketTimeout(int var1) throws IOException;

    @Override
    public AbstractEndpoint.Handler.SocketState process(SocketWrapper<S> socketWrapper) throws IOException {
        RequestInfo requestInfo = this.request.getRequestProcessor();
        requestInfo.setStage(1);
        this.setSocketWrapper(socketWrapper);
        this.getInputBuffer().init(socketWrapper, this.endpoint);
        this.getOutputBuffer().init(socketWrapper, this.endpoint);
        this.keepAlive = true;
        this.comet = false;
        this.openSocket = false;
        this.sendfileInProgress = false;
        this.readComplete = true;
        this.keptAlive = this.endpoint.getUsePolling() ? false : socketWrapper.isKeptAlive();
        if (this.disableKeepAlive()) {
            socketWrapper.setKeepAliveLeft(0);
        }
        while (!(this.getErrorState().isError() || !this.keepAlive || this.comet || this.isAsync() || this.upgradeInbound != null || this.httpUpgradeHandler != null || this.endpoint.isPaused())) {
            try {
                this.setRequestLineReadTimeout();
                if (!this.getInputBuffer().parseRequestLine(this.keptAlive) && this.handleIncompleteRequestLineRead()) break;
                this.prepareRequestProtocol();
                if (this.endpoint.isPaused()) {
                    this.response.setStatus(503);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                } else {
                    this.keptAlive = true;
                    this.request.getMimeHeaders().setLimit(this.endpoint.getMaxHeaderCount());
                    this.request.getCookies().setLimit(this.getMaxCookieCount());
                    if (!this.http09 && !this.getInputBuffer().parseHeaders()) {
                        this.openSocket = true;
                        this.readComplete = false;
                        break;
                    }
                    if (!this.disableUploadTimeout) {
                        this.setSocketTimeout(this.connectionUploadTimeout);
                    }
                }
            }
            catch (IOException iOException) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((Object)sm.getString("http11processor.header.parse"), (Throwable)iOException);
                }
                this.setErrorState(ErrorState.CLOSE_NOW, iOException);
                break;
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable(throwable);
                UserDataHelper.Mode mode = this.userDataHelper.getNextMode();
                if (mode != null) {
                    String string = sm.getString("http11processor.header.parse");
                    switch (mode) {
                        case INFO_THEN_DEBUG: {
                            string = string + sm.getString("http11processor.fallToDebug");
                        }
                        case INFO: {
                            this.getLog().info((Object)string, throwable);
                            break;
                        }
                        case DEBUG: {
                            this.getLog().debug((Object)string, throwable);
                        }
                    }
                }
                this.response.setStatus(400);
                this.setErrorState(ErrorState.CLOSE_CLEAN, throwable);
                this.getAdapter().log(this.request, this.response, 0L);
            }
            if (!this.getErrorState().isError()) {
                requestInfo.setStage(2);
                try {
                    this.prepareRequest();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable(throwable);
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((Object)sm.getString("http11processor.request.prepare"), throwable);
                    }
                    this.response.setStatus(500);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, throwable);
                    this.getAdapter().log(this.request, this.response, 0L);
                }
            }
            if (this.maxKeepAliveRequests == 1) {
                this.keepAlive = false;
            } else if (this.maxKeepAliveRequests > 0 && socketWrapper.decrementKeepAlive() <= 0) {
                this.keepAlive = false;
            }
            if (!this.getErrorState().isError()) {
                try {
                    requestInfo.setStage(3);
                    this.adapter.service(this.request, this.response);
                    if (this.keepAlive && !this.getErrorState().isError() && (this.response.getErrorException() != null || !this.isAsync() && this.statusDropsConnection(this.response.getStatus()))) {
                        this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                    }
                    this.setCometTimeouts(socketWrapper);
                }
                catch (InterruptedIOException interruptedIOException) {
                    this.setErrorState(ErrorState.CLOSE_NOW, interruptedIOException);
                }
                catch (HeadersTooLargeException headersTooLargeException) {
                    this.getLog().error((Object)sm.getString("http11processor.request.process"), (Throwable)headersTooLargeException);
                    if (this.response.isCommitted()) {
                        this.setErrorState(ErrorState.CLOSE_NOW, headersTooLargeException);
                    } else {
                        this.response.reset();
                        this.response.setStatus(500);
                        this.setErrorState(ErrorState.CLOSE_CLEAN, headersTooLargeException);
                        this.response.setHeader("Connection", "close");
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable(throwable);
                    this.getLog().error((Object)sm.getString("http11processor.request.process"), throwable);
                    this.response.setStatus(500);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, throwable);
                    this.getAdapter().log(this.request, this.response, 0L);
                }
            }
            requestInfo.setStage(4);
            if (!this.isAsync() && !this.comet) {
                if (this.getErrorState().isError()) {
                    this.getInputBuffer().setSwallowInput(false);
                } else {
                    this.checkExpectationAndResponseStatus();
                }
                this.endRequest();
            }
            requestInfo.setStage(5);
            if (this.getErrorState().isError()) {
                this.response.setStatus(500);
            }
            this.request.updateCounters();
            if ((!this.isAsync() && !this.comet || this.getErrorState().isError()) && this.getErrorState().isIoAllowed()) {
                this.getInputBuffer().nextRequest();
                this.getOutputBuffer().nextRequest();
            }
            if (!this.disableUploadTimeout) {
                if (this.endpoint.getSoTimeout() > 0) {
                    this.setSocketTimeout(this.endpoint.getSoTimeout());
                } else {
                    this.setSocketTimeout(0);
                }
            }
            requestInfo.setStage(6);
            if (!this.breakKeepAliveLoop(socketWrapper)) continue;
        }
        requestInfo.setStage(7);
        if (this.getErrorState().isError() || this.endpoint.isPaused()) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (this.isAsync() || this.comet) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        if (this.isUpgrade()) {
            return AbstractEndpoint.Handler.SocketState.UPGRADING;
        }
        if (this.getUpgradeInbound() != null) {
            return AbstractEndpoint.Handler.SocketState.UPGRADING_TOMCAT;
        }
        if (this.sendfileInProgress) {
            return AbstractEndpoint.Handler.SocketState.SENDFILE;
        }
        if (this.openSocket) {
            if (this.readComplete) {
                return AbstractEndpoint.Handler.SocketState.OPEN;
            }
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    private void checkExpectationAndResponseStatus() {
        if (this.expectation && (this.response.getStatus() < 200 || this.response.getStatus() > 299)) {
            this.getInputBuffer().setSwallowInput(false);
            this.keepAlive = false;
        }
    }

    private void prepareRequestProtocol() {
        MessageBytes messageBytes = this.request.protocol();
        if (messageBytes.equals("HTTP/1.1")) {
            this.http09 = false;
            this.http11 = true;
            messageBytes.setString("HTTP/1.1");
        } else if (messageBytes.equals("HTTP/1.0")) {
            this.http09 = false;
            this.http11 = false;
            this.keepAlive = false;
            messageBytes.setString("HTTP/1.0");
        } else if (messageBytes.equals("")) {
            this.http09 = true;
            this.http11 = false;
            this.keepAlive = false;
        } else {
            this.http09 = false;
            this.http11 = false;
            this.response.setStatus(505);
            this.setErrorState(ErrorState.CLOSE_CLEAN, null);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)(sm.getString("http11processor.request.prepare") + " Unsupported HTTP version \"" + messageBytes + "\""));
            }
        }
    }

    protected void prepareRequest() throws IOException {
        int n;
        Object object;
        Cloneable cloneable;
        MessageBytes messageBytes;
        this.contentDelimitation = false;
        this.expectation = false;
        this.prepareRequestInternal();
        if (this.endpoint.isSSLEnabled()) {
            this.request.scheme().setString("https");
        }
        if ((messageBytes = this.request.method()).equals("GET")) {
            messageBytes.setString("GET");
        } else if (messageBytes.equals("POST")) {
            messageBytes.setString("POST");
        }
        MimeHeaders mimeHeaders = this.request.getMimeHeaders();
        MessageBytes messageBytes2 = mimeHeaders.getValue("Connection");
        if (messageBytes2 != null && !messageBytes2.isNull()) {
            cloneable = new HashSet();
            TokenList.parseTokenList(mimeHeaders.values("Connection"), (Collection<String>)((Object)cloneable));
            if (cloneable.contains("close")) {
                this.keepAlive = false;
            } else if (cloneable.contains("keep-alive")) {
                this.keepAlive = true;
            }
        }
        if (this.http11 && (cloneable = mimeHeaders.getValue("expect")) != null && !((MessageBytes)cloneable).isNull()) {
            if (((MessageBytes)cloneable).toString().trim().equalsIgnoreCase("100-continue")) {
                this.getInputBuffer().setSwallowInput(false);
                this.expectation = true;
            } else {
                this.response.setStatus(417);
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
            }
        }
        if (this.restrictedUserAgents != null && (this.http11 || this.keepAlive) && (cloneable = mimeHeaders.getValue("user-agent")) != null && !((MessageBytes)cloneable).isNull() && this.restrictedUserAgents.matcher((CharSequence)(object = ((MessageBytes)cloneable).toString())).matches()) {
            this.http11 = false;
            this.keepAlive = false;
        }
        cloneable = null;
        try {
            cloneable = mimeHeaders.getUniqueValue("host");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.badRequest("http11processor.request.multipleHosts");
        }
        if (this.http11 && cloneable == null) {
            this.badRequest("http11processor.request.noHostHeader");
        }
        object = this.request.requestURI().getByteChunk();
        byte[] byArray = ((ByteChunk)object).getBytes();
        if (((ByteChunk)object).startsWithIgnoreCase("http", 0)) {
            n = 4;
            if (((ByteChunk)object).startsWithIgnoreCase("s", n)) {
                ++n;
            }
            if (((ByteChunk)object).startsWith("://", n)) {
                int n2 = ((AbstractChunk)object).getStart();
                int n3 = ((ByteChunk)object).indexOf('/', n += 3);
                int n4 = ((ByteChunk)object).indexOf('@', n);
                if (n3 > -1 && n4 > n3) {
                    n4 = -1;
                }
                if (n3 == -1) {
                    n3 = ((AbstractChunk)object).getLength();
                    this.request.requestURI().setBytes(byArray, n2 + 6, 1);
                } else {
                    this.request.requestURI().setBytes(byArray, n2 + n3, ((AbstractChunk)object).getLength() - n3);
                }
                if (n4 != -1) {
                    while (n < n4) {
                        byte by = byArray[n2 + n];
                        if (!HttpParser.isUserInfo(by)) {
                            this.badRequest("http11processor.request.invalidUserInfo");
                            break;
                        }
                        ++n;
                    }
                    n = n4 + 1;
                }
                if (this.http11) {
                    if (cloneable != null && !((MessageBytes)cloneable).getByteChunk().equals(byArray, n2 + n, n3 - n)) {
                        if (this.allowHostHeaderMismatch) {
                            cloneable = mimeHeaders.setValue("host");
                            ((MessageBytes)cloneable).setBytes(byArray, n2 + n, n3 - n);
                        } else {
                            this.badRequest("http11processor.request.inconsistentHosts");
                        }
                    }
                } else {
                    try {
                        cloneable = mimeHeaders.setValue("host");
                        ((MessageBytes)cloneable).setBytes(byArray, n2 + n, n3 - n);
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            } else {
                this.badRequest("http11processor.request.invalidScheme");
            }
        }
        for (n = ((AbstractChunk)object).getStart(); n < ((AbstractChunk)object).getEnd(); ++n) {
            if (this.httpParser.isAbsolutePathRelaxed(byArray[n])) continue;
            this.badRequest("http11processor.request.invalidUri");
            break;
        }
        InputFilter[] inputFilterArray = this.getInputBuffer().getFilters();
        MessageBytes messageBytes3 = null;
        if (this.http11) {
            messageBytes3 = mimeHeaders.getValue("transfer-encoding");
        }
        if (messageBytes3 != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (TokenList.parseTokenList(mimeHeaders.values("transfer-encoding"), arrayList)) {
                for (String string : arrayList) {
                    this.addInputFilter(inputFilterArray, string);
                }
            } else {
                this.badRequest("http11processor.request.invalidTransferEncoding");
            }
        }
        long l = -1L;
        try {
            l = this.request.getContentLengthLong();
        }
        catch (NumberFormatException numberFormatException) {
            this.badRequest("http11processor.request.nonNumericContentLength");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.badRequest("http11processor.request.multipleContentLength");
        }
        if (l >= 0L) {
            if (this.contentDelimitation) {
                mimeHeaders.removeHeader("content-length");
                this.request.setContentLength(-1L);
            } else {
                this.getInputBuffer().addActiveFilter(inputFilterArray[0]);
                this.contentDelimitation = true;
            }
        }
        this.parseHost((MessageBytes)cloneable);
        if (!this.contentDelimitation) {
            this.getInputBuffer().addActiveFilter(inputFilterArray[2]);
            this.contentDelimitation = true;
        }
        if (this.endpoint.getUseSendfile()) {
            this.request.setAttribute("org.apache.tomcat.sendfile.support", Boolean.TRUE);
        }
        if (this.endpoint.getUseComet()) {
            this.request.setAttribute("org.apache.tomcat.comet.support", Boolean.TRUE);
        }
        if (this.endpoint.getUseCometTimeout()) {
            this.request.setAttribute("org.apache.tomcat.comet.timeout.support", Boolean.TRUE);
        }
        if (this.getErrorState().isError()) {
            this.adapter.log(this.request, this.response, 0L);
        }
    }

    private void badRequest(String string) {
        this.response.setStatus(400);
        this.setErrorState(ErrorState.CLOSE_CLEAN, null);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)sm.getString(string));
        }
    }

    protected abstract void prepareRequestInternal();

    private void prepareResponse() throws IOException {
        MessageBytes messageBytes;
        boolean bl = true;
        this.contentDelimitation = false;
        OutputFilter[] outputFilterArray = this.getOutputBuffer().getFilters();
        if (this.http09) {
            this.getOutputBuffer().addActiveFilter(outputFilterArray[0]);
            return;
        }
        int n = this.response.getStatus();
        if (n < 200 || n == 204 || n == 205 || n == 304) {
            this.getOutputBuffer().addActiveFilter(outputFilterArray[2]);
            bl = false;
            this.contentDelimitation = true;
            if (n == 205) {
                this.response.setContentLength(0L);
            } else {
                this.response.setContentLength(-1L);
            }
        }
        if ((messageBytes = this.request.method()).equals("HEAD")) {
            this.getOutputBuffer().addActiveFilter(outputFilterArray[2]);
            this.contentDelimitation = true;
        }
        boolean bl2 = false;
        if (this.getEndpoint().getUseSendfile()) {
            bl2 = this.prepareSendfile(outputFilterArray);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        if (bl && this.compressionLevel > 0 && !bl2) {
            bl3 = this.isCompressible();
            if (bl3) {
                bl4 = this.useCompression();
            }
            if (bl4) {
                this.response.setContentLength(-1L);
            }
        }
        MimeHeaders mimeHeaders = this.response.getMimeHeaders();
        if (bl || n == 204) {
            String string;
            String string2 = this.response.getContentType();
            if (string2 != null) {
                mimeHeaders.setValue("Content-Type").setString(string2);
            }
            if ((string = this.response.getContentLanguage()) != null) {
                mimeHeaders.setValue("Content-Language").setString(string);
            }
        }
        long l = this.response.getContentLengthLong();
        boolean bl5 = AbstractHttp11Processor.isConnectionToken(mimeHeaders, "close");
        if (l != -1L) {
            mimeHeaders.setValue("Content-Length").setLong(l);
            this.getOutputBuffer().addActiveFilter(outputFilterArray[0]);
            this.contentDelimitation = true;
        } else if (this.http11 && bl && !bl5) {
            this.getOutputBuffer().addActiveFilter(outputFilterArray[1]);
            this.contentDelimitation = true;
            mimeHeaders.addValue("Transfer-Encoding").setString("chunked");
        } else {
            this.getOutputBuffer().addActiveFilter(outputFilterArray[0]);
        }
        if (bl4) {
            this.getOutputBuffer().addActiveFilter(outputFilterArray[3]);
            mimeHeaders.setValue("Content-Encoding").setString("gzip");
        }
        if (bl3) {
            ResponseUtil.addVaryFieldName(mimeHeaders, "accept-encoding");
        }
        if (mimeHeaders.getValue("Date") == null) {
            mimeHeaders.setValue("Date").setString(FastHttpDateFormat.getCurrentDate());
        }
        if (bl && !this.contentDelimitation) {
            this.keepAlive = false;
        }
        this.checkExpectationAndResponseStatus();
        boolean bl6 = this.keepAlive = this.keepAlive && !this.statusDropsConnection(n);
        if (!this.keepAlive) {
            if (!bl5) {
                mimeHeaders.addValue("Connection").setString("close");
            }
        } else if (!this.http11 && !this.getErrorState().isError()) {
            mimeHeaders.addValue("Connection").setString("keep-alive");
        }
        this.getOutputBuffer().sendStatus();
        if (this.server != null) {
            mimeHeaders.setValue("Server").setString(this.server);
        } else if (mimeHeaders.getValue("Server") == null) {
            this.getOutputBuffer().write(Constants.SERVER_BYTES);
        }
        int n2 = mimeHeaders.size();
        for (int i = 0; i < n2; ++i) {
            this.getOutputBuffer().sendHeader(mimeHeaders.getName(i), mimeHeaders.getValue(i));
        }
        this.getOutputBuffer().endHeaders();
    }

    private static boolean isConnectionToken(MimeHeaders mimeHeaders, String string) throws IOException {
        MessageBytes messageBytes = mimeHeaders.getValue("Connection");
        if (messageBytes == null) {
            return false;
        }
        HashSet<String> hashSet = new HashSet<String>();
        TokenList.parseTokenList(mimeHeaders.values("Connection"), hashSet);
        return hashSet.contains(string);
    }

    protected abstract boolean prepareSendfile(OutputFilter[] var1);

    @Override
    protected void populatePort() {
        this.request.action(ActionCode.REQ_LOCALPORT_ATTRIBUTE, this.request);
        this.request.setServerPort(this.request.getLocalPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractEndpoint.Handler.SocketState asyncDispatch(SocketStatus socketStatus) {
        AbstractEndpoint.Handler.SocketState socketState;
        RequestInfo requestInfo = this.request.getRequestProcessor();
        try {
            requestInfo.setStage(3);
            if (!this.getAdapter().asyncDispatch(this.request, this.response, socketStatus)) {
                this.setErrorState(ErrorState.CLOSE_NOW, null);
            }
            this.resetTimeouts();
        }
        catch (InterruptedIOException interruptedIOException) {
            this.setErrorState(ErrorState.CLOSE_NOW, interruptedIOException);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable(throwable);
            this.setErrorState(ErrorState.CLOSE_NOW, throwable);
            this.getLog().error((Object)sm.getString("http11processor.request.process"), throwable);
        }
        finally {
            if (this.getErrorState().isError()) {
                this.response.setStatus(500);
                this.adapter.log(this.request, this.response, 0L);
            }
        }
        requestInfo.setStage(7);
        if (this.getErrorState().isError()) {
            socketState = AbstractEndpoint.Handler.SocketState.CLOSED;
        } else if (this.isAsync()) {
            socketState = AbstractEndpoint.Handler.SocketState.LONG;
        } else if (!this.keepAlive || this.endpoint.isPaused()) {
            socketState = AbstractEndpoint.Handler.SocketState.CLOSED;
        } else {
            this.endRequest();
            this.getInputBuffer().nextRequest();
            this.getOutputBuffer().nextRequest();
            socketState = AbstractEndpoint.Handler.SocketState.OPEN;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("Socket: [" + this.socketWrapper + "], Status in: [" + (Object)((Object)socketStatus) + "], State out: [" + (Object)((Object)socketState) + "]"));
        }
        return socketState;
    }

    @Override
    public boolean isComet() {
        return this.comet;
    }

    @Override
    public AbstractEndpoint.Handler.SocketState upgradeDispatch() throws IOException {
        throw new IOException(sm.getString("http11Processor.upgrade"));
    }

    @Override
    @Deprecated
    public UpgradeInbound getUpgradeInbound() {
        return this.upgradeInbound;
    }

    @Override
    public boolean isUpgrade() {
        return this.httpUpgradeHandler != null;
    }

    @Override
    public AbstractEndpoint.Handler.SocketState upgradeDispatch(SocketStatus socketStatus) throws IOException {
        throw new IOException(sm.getString("ajpprocessor.httpupgrade.notsupported"));
    }

    @Override
    public HttpUpgradeHandler getHttpUpgradeHandler() {
        return this.httpUpgradeHandler;
    }

    protected abstract void resetTimeouts();

    protected abstract void setCometTimeouts(SocketWrapper<S> var1);

    public void endRequest() {
        if (this.getErrorState().isIoAllowed()) {
            try {
                this.getInputBuffer().endRequest();
            }
            catch (IOException iOException) {
                this.setErrorState(ErrorState.CLOSE_NOW, iOException);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable(throwable);
                this.response.setStatus(500);
                this.setErrorState(ErrorState.CLOSE_NOW, throwable);
                this.getLog().error((Object)sm.getString("http11processor.request.finish"), throwable);
            }
        }
        if (this.getErrorState().isIoAllowed()) {
            try {
                this.getOutputBuffer().endRequest();
            }
            catch (IOException iOException) {
                this.setErrorState(ErrorState.CLOSE_NOW, iOException);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable(throwable);
                this.setErrorState(ErrorState.CLOSE_NOW, throwable);
                this.getLog().error((Object)sm.getString("http11processor.response.finish"), throwable);
            }
        }
    }

    protected abstract boolean breakKeepAliveLoop(SocketWrapper<S> var1);

    @Override
    public final void recycle(boolean bl) {
        this.getAdapter().checkRecycled(this.request, this.response);
        if (this.getInputBuffer() != null) {
            this.getInputBuffer().recycle();
        }
        if (this.getOutputBuffer() != null) {
            this.getOutputBuffer().recycle();
        }
        if (this.asyncStateMachine != null) {
            this.asyncStateMachine.recycle();
        }
        this.upgradeInbound = null;
        this.httpUpgradeHandler = null;
        this.remoteAddr = null;
        this.remoteHost = null;
        this.localAddr = null;
        this.localName = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.comet = false;
        this.resetErrorState();
        this.recycleInternal();
    }

    protected abstract void recycleInternal();
}

