/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Set;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ErrorState;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.AbstractHttp11Processor;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.InternalAprInputBuffer;
import org.apache.coyote.http11.InternalAprOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Address;
import org.apache.tomcat.jni.SSLSocket;
import org.apache.tomcat.jni.Sockaddr;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SendfileKeepAliveState;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11AprProcessor
extends AbstractHttp11Processor<Long> {
    private static final Log log = LogFactory.getLog(Http11AprProcessor.class);
    protected InternalAprInputBuffer inputBuffer = null;
    protected InternalAprOutputBuffer outputBuffer = null;
    protected AprEndpoint.SendfileData sendfileData = null;
    protected String clientCertProvider = null;

    @Override
    protected Log getLog() {
        return log;
    }

    public Http11AprProcessor(int n, boolean bl, AprEndpoint aprEndpoint, int n2, Set<String> set, int n3, int n4, String string, String string2) {
        super(aprEndpoint);
        this.httpParser = new HttpParser(string, string2);
        this.inputBuffer = new InternalAprInputBuffer(this.request, n, bl, this.httpParser);
        this.request.setInputBuffer(this.inputBuffer);
        this.outputBuffer = new InternalAprOutputBuffer(this.response, n);
        this.response.setOutputBuffer(this.outputBuffer);
        this.initializeFilters(n2, set, n3, n4);
    }

    public String getClientCertProvider() {
        return this.clientCertProvider;
    }

    public void setClientCertProvider(String string) {
        this.clientCertProvider = string;
    }

    @Override
    public AbstractEndpoint.Handler.SocketState event(SocketStatus socketStatus) throws IOException {
        RequestInfo requestInfo = this.request.getRequestProcessor();
        try {
            requestInfo.setStage(3);
            if (!this.getAdapter().event(this.request, this.response, socketStatus)) {
                this.setErrorState(ErrorState.CLOSE_NOW, null);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            this.setErrorState(ErrorState.CLOSE_NOW, interruptedIOException);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable(throwable);
            this.response.setStatus(500);
            this.setErrorState(ErrorState.CLOSE_NOW, throwable);
            this.getAdapter().log(this.request, this.response, 0L);
            log.error((Object)sm.getString("http11processor.request.process"), throwable);
        }
        requestInfo.setStage(7);
        if (this.getErrorState().isError() || socketStatus == SocketStatus.STOP) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (!this.comet) {
            this.inputBuffer.nextRequest();
            this.outputBuffer.nextRequest();
            return AbstractEndpoint.Handler.SocketState.OPEN;
        }
        return AbstractEndpoint.Handler.SocketState.LONG;
    }

    @Override
    protected boolean disableKeepAlive() {
        return false;
    }

    @Override
    protected void setRequestLineReadTimeout() throws IOException {
    }

    @Override
    protected boolean handleIncompleteRequestLineRead() {
        this.openSocket = true;
        return true;
    }

    @Override
    protected void setSocketTimeout(int n) {
        Socket.timeoutSet((Long)this.socketWrapper.getSocket(), n * 1000);
    }

    @Override
    protected void setCometTimeouts(SocketWrapper<Long> socketWrapper) {
    }

    @Override
    protected boolean breakKeepAliveLoop(SocketWrapper<Long> socketWrapper) {
        this.openSocket = this.keepAlive;
        if (this.sendfileData != null && !this.getErrorState().isError()) {
            this.sendfileData.socket = socketWrapper.getSocket();
            this.sendfileData.keepAliveState = this.keepAlive ? (this.getInputBuffer().available() == 0 ? SendfileKeepAliveState.OPEN : SendfileKeepAliveState.PIPELINED) : SendfileKeepAliveState.NONE;
            switch (((AprEndpoint)this.endpoint).getSendfile().add(this.sendfileData)) {
                case DONE: {
                    return false;
                }
                case PENDING: {
                    this.sendfileInProgress = true;
                    return true;
                }
                case ERROR: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("http11processor.sendfile.error"));
                    }
                    this.setErrorState(ErrorState.CLOSE_NOW, null);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected void resetTimeouts() {
    }

    @Override
    public void recycleInternal() {
        this.socketWrapper = null;
        this.sendfileData = null;
    }

    @Override
    public void setSslSupport(SSLSupport sSLSupport) {
    }

    @Override
    public void actionInternal(ActionCode actionCode, Object object) {
        long l = (Long)this.socketWrapper.getSocket();
        switch (actionCode) {
            case REQ_HOST_ADDR_ATTRIBUTE: {
                if (this.remoteAddr == null && l != 0L) {
                    try {
                        long l2 = Address.get(1, l);
                        this.remoteAddr = Address.getip(l2);
                    }
                    catch (Exception exception) {
                        log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)exception);
                    }
                }
                this.request.remoteAddr().setString(this.remoteAddr);
                break;
            }
            case REQ_LOCAL_NAME_ATTRIBUTE: {
                if (this.localName == null && l != 0L) {
                    try {
                        long l3 = Address.get(0, l);
                        this.localName = Address.getnameinfo(l3, 0);
                    }
                    catch (Exception exception) {
                        log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)exception);
                    }
                }
                this.request.localName().setString(this.localName);
                break;
            }
            case REQ_HOST_ATTRIBUTE: {
                if (this.remoteHost == null && l != 0L) {
                    try {
                        long l4 = Address.get(1, l);
                        this.remoteHost = Address.getnameinfo(l4, 0);
                        if (this.remoteHost == null) {
                            this.remoteHost = Address.getip(l4);
                        }
                    }
                    catch (Exception exception) {
                        log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)exception);
                    }
                }
                this.request.remoteHost().setString(this.remoteHost);
                break;
            }
            case REQ_LOCAL_ADDR_ATTRIBUTE: {
                if (this.localAddr == null && l != 0L) {
                    try {
                        long l5 = Address.get(0, l);
                        this.localAddr = Address.getip(l5);
                    }
                    catch (Exception exception) {
                        log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)exception);
                    }
                }
                this.request.localAddr().setString(this.localAddr);
                break;
            }
            case REQ_REMOTEPORT_ATTRIBUTE: {
                if (this.remotePort == -1 && l != 0L) {
                    try {
                        long l6 = Address.get(1, l);
                        Sockaddr sockaddr = Address.getInfo(l6);
                        this.remotePort = sockaddr.port;
                    }
                    catch (Exception exception) {
                        log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)exception);
                    }
                }
                this.request.setRemotePort(this.remotePort);
                break;
            }
            case REQ_LOCALPORT_ATTRIBUTE: {
                if (this.localPort == -1 && l != 0L) {
                    try {
                        long l7 = Address.get(0, l);
                        Sockaddr sockaddr = Address.getInfo(l7);
                        this.localPort = sockaddr.port;
                    }
                    catch (Exception exception) {
                        log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)exception);
                    }
                }
                this.request.setLocalPort(this.localPort);
                break;
            }
            case REQ_SSL_ATTRIBUTE: {
                if (!this.endpoint.isSSLEnabled() || l == 0L) break;
                try {
                    Object object2 = SSLSocket.getInfoS(l, 2);
                    if (object2 != null) {
                        this.request.setAttribute("javax.servlet.request.cipher_suite", object2);
                    }
                    int n = SSLSocket.getInfoI(l, 1024);
                    byte[] byArray = SSLSocket.getInfoB(l, 263);
                    X509Certificate[] x509CertificateArray = null;
                    if (byArray != null) {
                        if (n < 0) {
                            n = 0;
                        }
                        x509CertificateArray = new X509Certificate[n + 1];
                        CertificateFactory certificateFactory = this.clientCertProvider == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", this.clientCertProvider);
                        x509CertificateArray[0] = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                        for (int i = 0; i < n; ++i) {
                            byte[] byArray2 = SSLSocket.getInfoB(l, 1024 + i);
                            x509CertificateArray[i + 1] = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray2));
                        }
                    }
                    if (x509CertificateArray != null) {
                        this.request.setAttribute("javax.servlet.request.X509Certificate", x509CertificateArray);
                    }
                    object2 = SSLSocket.getInfoI(l, 3);
                    this.request.setAttribute("javax.servlet.request.key_size", object2);
                    object2 = SSLSocket.getInfoS(l, 1);
                    if (object2 != null) {
                        this.request.setAttribute("javax.servlet.request.ssl_session_id", object2);
                    }
                    if ((object2 = SSLSocket.getInfoS(l, 7)) == null) break;
                    this.request.setAttribute("org.apache.tomcat.util.net.secure_protocol_version", object2);
                }
                catch (Exception exception) {
                    log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)exception);
                }
                break;
            }
            case REQ_SSL_CERTIFICATE: {
                if (!this.endpoint.isSSLEnabled() || l == 0L) break;
                InputFilter[] inputFilterArray = this.inputBuffer.getFilters();
                ((BufferedInputFilter)inputFilterArray[3]).setLimit(this.maxSavePostSize);
                this.inputBuffer.addActiveFilter(inputFilterArray[3]);
                try {
                    SSLSocket.setVerify(l, 2, ((AprEndpoint)this.endpoint).getSSLVerifyDepth());
                    if (SSLSocket.renegotiate(l) != 0) break;
                    int n = SSLSocket.getInfoI(l, 1024);
                    byte[] byArray = SSLSocket.getInfoB(l, 263);
                    X509Certificate[] x509CertificateArray = null;
                    if (byArray != null && n > -1) {
                        x509CertificateArray = new X509Certificate[n + 1];
                        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                        x509CertificateArray[0] = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                        for (int i = 0; i < n; ++i) {
                            byte[] byArray3 = SSLSocket.getInfoB(l, 1024 + i);
                            x509CertificateArray[i + 1] = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray3));
                        }
                    }
                    if (x509CertificateArray == null) break;
                    this.request.setAttribute("javax.servlet.request.X509Certificate", x509CertificateArray);
                }
                catch (Exception exception) {
                    log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)exception);
                }
                break;
            }
            case AVAILABLE: {
                this.request.setAvailable(this.inputBuffer.available());
                break;
            }
            case COMET_BEGIN: {
                this.comet = true;
                break;
            }
            case COMET_END: {
                this.comet = false;
                break;
            }
            case COMET_CLOSE: {
                ((AprEndpoint)this.endpoint).processSocketAsync(this.socketWrapper, SocketStatus.OPEN_READ);
                break;
            }
            case COMET_SETTIMEOUT: {
                break;
            }
            case ASYNC_COMPLETE: {
                if (!this.asyncStateMachine.asyncComplete()) break;
                ((AprEndpoint)this.endpoint).processSocketAsync(this.socketWrapper, SocketStatus.OPEN_READ);
                break;
            }
            case ASYNC_SETTIMEOUT: {
                if (object == null) {
                    return;
                }
                long l8 = (Long)object;
                this.socketWrapper.setTimeout(l8);
                break;
            }
            case ASYNC_DISPATCH: {
                if (!this.asyncStateMachine.asyncDispatch()) break;
                ((AprEndpoint)this.endpoint).processSocketAsync(this.socketWrapper, SocketStatus.OPEN_READ);
            }
        }
    }

    @Override
    protected void prepareRequestInternal() {
        this.sendfileData = null;
    }

    @Override
    protected boolean prepareSendfile(OutputFilter[] outputFilterArray) {
        String string = (String)this.request.getAttribute("org.apache.tomcat.sendfile.filename");
        if (string != null) {
            this.outputBuffer.addActiveFilter(outputFilterArray[2]);
            this.contentDelimitation = true;
            this.sendfileData = new AprEndpoint.SendfileData();
            this.sendfileData.fileName = string;
            this.sendfileData.start = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.start");
            this.sendfileData.end = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.end");
            return true;
        }
        return false;
    }

    @Override
    protected AbstractInputBuffer<Long> getInputBuffer() {
        return this.inputBuffer;
    }

    @Override
    protected AbstractOutputBuffer<Long> getOutputBuffer() {
        return this.outputBuffer;
    }
}

