/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.OutputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;

public class ChunkedOutputFilter
implements OutputFilter {
    protected static final ByteChunk END_CHUNK = new ByteChunk();
    protected OutputBuffer buffer;
    protected byte[] chunkLength = new byte[10];
    protected ByteChunk chunkHeader = new ByteChunk();

    public ChunkedOutputFilter() {
        this.chunkLength = new byte[10];
        this.chunkLength[8] = 13;
        this.chunkLength[9] = 10;
    }

    @Override
    public int doWrite(ByteChunk byteChunk, Response response) throws IOException {
        int n = byteChunk.getLength();
        if (n <= 0) {
            return 0;
        }
        int n2 = 8;
        for (int i = n; i > 0; i /= 16) {
            int n3 = i % 16;
            this.chunkLength[--n2] = HexUtils.getHex(n3);
        }
        this.chunkHeader.setBytes(this.chunkLength, n2, 10 - n2);
        this.buffer.doWrite(this.chunkHeader, response);
        this.buffer.doWrite(byteChunk, response);
        this.chunkHeader.setBytes(this.chunkLength, 8, 2);
        this.buffer.doWrite(this.chunkHeader, response);
        return n;
    }

    @Override
    public long getBytesWritten() {
        return this.buffer.getBytesWritten();
    }

    @Override
    public void setResponse(Response response) {
    }

    @Override
    public void setBuffer(OutputBuffer outputBuffer) {
        this.buffer = outputBuffer;
    }

    @Override
    public long end() throws IOException {
        this.buffer.doWrite(END_CHUNK, null);
        return 0L;
    }

    @Override
    public void recycle() {
    }

    static {
        byte[] byArray = new byte[]{48, 13, 10, 13, 10};
        END_CHUNK.setBytes(byArray, 0, byArray.length);
    }
}

