/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;

public final class C2BConverter {
    CharsetEncoder encoder = null;
    ByteBuffer bb = null;
    CharBuffer cb = null;
    CharBuffer leftovers = null;

    public C2BConverter(String string) throws IOException {
        this.encoder = B2CConverter.getCharset(string).newEncoder();
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE).onMalformedInput(CodingErrorAction.REPLACE);
        char[] cArray = new char[4];
        this.leftovers = CharBuffer.wrap(cArray);
    }

    public void recycle() {
        this.encoder.reset();
        this.leftovers.position(0);
    }

    public boolean isUndeflow() {
        return this.leftovers.position() > 0;
    }

    public void convert(CharChunk charChunk, ByteChunk byteChunk) throws IOException {
        if (this.bb == null || this.bb.array() != byteChunk.getBuffer()) {
            this.bb = ByteBuffer.wrap(byteChunk.getBuffer(), byteChunk.getEnd(), byteChunk.getBuffer().length - byteChunk.getEnd());
        } else {
            this.bb.limit(byteChunk.getBuffer().length);
            this.bb.position(byteChunk.getEnd());
        }
        if (this.cb == null || this.cb.array() != charChunk.getBuffer()) {
            this.cb = CharBuffer.wrap(charChunk.getBuffer(), charChunk.getStart(), charChunk.getLength());
        } else {
            this.cb.limit(charChunk.getEnd());
            this.cb.position(charChunk.getStart());
        }
        CoderResult coderResult = null;
        if (this.leftovers.position() > 0) {
            int n = this.bb.position();
            do {
                this.leftovers.put((char)charChunk.substract());
                this.leftovers.flip();
                coderResult = this.encoder.encode(this.leftovers, this.bb, false);
                this.leftovers.position(this.leftovers.limit());
                this.leftovers.limit(this.leftovers.array().length);
            } while (coderResult.isUnderflow() && this.bb.position() == n);
            if (coderResult.isError() || coderResult.isMalformed()) {
                coderResult.throwException();
            }
            this.cb.position(charChunk.getStart());
            this.leftovers.position(0);
        }
        if ((coderResult = this.encoder.encode(this.cb, this.bb, false)).isError() || coderResult.isMalformed()) {
            coderResult.throwException();
        } else if (coderResult.isOverflow()) {
            byteChunk.setEnd(this.bb.position());
            charChunk.setOffset(this.cb.position());
        } else if (coderResult.isUnderflow()) {
            byteChunk.setEnd(this.bb.position());
            charChunk.setOffset(this.cb.position());
            if (charChunk.getLength() > 0) {
                this.leftovers.limit(this.leftovers.array().length);
                this.leftovers.position(charChunk.getLength());
                charChunk.substract(this.leftovers.array(), 0, charChunk.getLength());
            }
        }
    }
}

