/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.digester;

import org.apache.tomcat.util.digester.ArrayStack;
import org.apache.tomcat.util.digester.ObjectCreationFactory;
import org.apache.tomcat.util.digester.Rule;
import org.xml.sax.Attributes;

public class FactoryCreateRule
extends Rule {
    private boolean ignoreCreateExceptions;
    private ArrayStack<Boolean> exceptionIgnoredStack;
    protected String attributeName = null;
    protected String className = null;
    protected ObjectCreationFactory creationFactory = null;

    public FactoryCreateRule(String string) {
        this(string, false);
    }

    public FactoryCreateRule(Class<?> clazz) {
        this(clazz, false);
    }

    public FactoryCreateRule(String string, String string2) {
        this(string, string2, false);
    }

    public FactoryCreateRule(Class<?> clazz, String string) {
        this(clazz, string, false);
    }

    public FactoryCreateRule(ObjectCreationFactory objectCreationFactory) {
        this(objectCreationFactory, false);
    }

    public FactoryCreateRule(String string, boolean bl) {
        this(string, null, bl);
    }

    public FactoryCreateRule(Class<?> clazz, boolean bl) {
        this(clazz, null, bl);
    }

    public FactoryCreateRule(String string, String string2, boolean bl) {
        this.className = string;
        this.attributeName = string2;
        this.ignoreCreateExceptions = bl;
    }

    public FactoryCreateRule(Class<?> clazz, String string, boolean bl) {
        this(clazz.getName(), string, bl);
    }

    public FactoryCreateRule(ObjectCreationFactory objectCreationFactory, boolean bl) {
        this.creationFactory = objectCreationFactory;
        this.ignoreCreateExceptions = bl;
    }

    @Override
    public void begin(String string, String string2, Attributes attributes) throws Exception {
        if (this.ignoreCreateExceptions) {
            if (this.exceptionIgnoredStack == null) {
                this.exceptionIgnoredStack = new ArrayStack();
            }
            try {
                Object object = this.getFactory(attributes).createObject(attributes);
                if (this.digester.log.isDebugEnabled()) {
                    this.digester.log.debug((Object)("[FactoryCreateRule]{" + this.digester.match + "} New " + object.getClass().getName()));
                }
                this.digester.push(object);
                this.exceptionIgnoredStack.push(Boolean.FALSE);
            }
            catch (Exception exception) {
                if (this.digester.log.isInfoEnabled()) {
                    this.digester.log.info((Object)("[FactoryCreateRule] Create exception ignored: " + (exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage())));
                    if (this.digester.log.isDebugEnabled()) {
                        this.digester.log.debug((Object)"[FactoryCreateRule] Ignored exception:", (Throwable)exception);
                    }
                }
                this.exceptionIgnoredStack.push(Boolean.TRUE);
            }
        } else {
            Object object = this.getFactory(attributes).createObject(attributes);
            if (this.digester.log.isDebugEnabled()) {
                this.digester.log.debug((Object)("[FactoryCreateRule]{" + this.digester.match + "} New " + object.getClass().getName()));
            }
            this.digester.push(object);
        }
    }

    @Override
    public void end(String string, String string2) throws Exception {
        if (this.ignoreCreateExceptions && this.exceptionIgnoredStack != null && !this.exceptionIgnoredStack.empty() && this.exceptionIgnoredStack.pop().booleanValue()) {
            if (this.digester.log.isTraceEnabled()) {
                this.digester.log.trace((Object)"[FactoryCreateRule] No creation so no push so no pop");
            }
            return;
        }
        Object object = this.digester.pop();
        if (this.digester.log.isDebugEnabled()) {
            this.digester.log.debug((Object)("[FactoryCreateRule]{" + this.digester.match + "} Pop " + object.getClass().getName()));
        }
    }

    @Override
    public void finish() throws Exception {
        if (this.attributeName != null) {
            this.creationFactory = null;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("FactoryCreateRule[");
        stringBuilder.append("className=");
        stringBuilder.append(this.className);
        stringBuilder.append(", attributeName=");
        stringBuilder.append(this.attributeName);
        if (this.creationFactory != null) {
            stringBuilder.append(", creationFactory=");
            stringBuilder.append(this.creationFactory);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    protected ObjectCreationFactory getFactory(Attributes attributes) throws Exception {
        if (this.creationFactory == null) {
            Object object;
            String string = this.className;
            if (this.attributeName != null && (object = attributes.getValue(this.attributeName)) != null) {
                string = object;
            }
            if (this.digester.log.isDebugEnabled()) {
                this.digester.log.debug((Object)("[FactoryCreateRule]{" + this.digester.match + "} New factory " + string));
            }
            object = this.digester.getClassLoader().loadClass(string);
            this.creationFactory = (ObjectCreationFactory)((Class)object).newInstance();
            this.creationFactory.setDigester(this.digester);
        }
        return this.creationFactory;
    }
}

