/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class SocketProperties {
    protected int keyCache = 500;
    protected int processorCache = 500;
    protected int eventCache = 500;
    protected boolean directBuffer = false;
    protected Integer rxBufSize = null;
    protected Integer txBufSize = null;
    protected int appReadBufSize = 8192;
    protected int appWriteBufSize = 8192;
    protected int bufferPool = 500;
    protected int bufferPoolSize = 0x6400000;
    protected Boolean tcpNoDelay = Boolean.TRUE;
    protected Boolean soKeepAlive = null;
    protected Boolean ooBInline = null;
    protected Boolean soReuseAddress = null;
    protected Boolean soLingerOn = null;
    protected Integer soLingerTime = null;
    protected Integer soTimeout = 20000;
    protected Integer performanceConnectionTime = null;
    protected Integer performanceLatency = null;
    protected Integer performanceBandwidth = null;
    protected long timeoutInterval = 1000L;
    protected int unlockTimeout = 250;

    public void setProperties(Socket socket) throws SocketException {
        if (this.rxBufSize != null) {
            socket.setReceiveBufferSize(this.rxBufSize);
        }
        if (this.txBufSize != null) {
            socket.setSendBufferSize(this.txBufSize);
        }
        if (this.ooBInline != null) {
            socket.setOOBInline(this.ooBInline);
        }
        if (this.soKeepAlive != null) {
            socket.setKeepAlive(this.soKeepAlive);
        }
        if (this.performanceConnectionTime != null && this.performanceLatency != null && this.performanceBandwidth != null) {
            socket.setPerformancePreferences(this.performanceConnectionTime, this.performanceLatency, this.performanceBandwidth);
        }
        if (this.soReuseAddress != null) {
            socket.setReuseAddress(this.soReuseAddress);
        }
        if (this.soLingerOn != null && this.soLingerTime != null) {
            socket.setSoLinger(this.soLingerOn, this.soLingerTime);
        }
        if (this.soTimeout != null && this.soTimeout >= 0) {
            socket.setSoTimeout(this.soTimeout);
        }
        if (this.tcpNoDelay != null) {
            try {
                socket.setTcpNoDelay(this.tcpNoDelay);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    public void setProperties(ServerSocket serverSocket) throws SocketException {
        if (this.rxBufSize != null) {
            serverSocket.setReceiveBufferSize(this.rxBufSize);
        }
        if (this.performanceConnectionTime != null && this.performanceLatency != null && this.performanceBandwidth != null) {
            serverSocket.setPerformancePreferences(this.performanceConnectionTime, this.performanceLatency, this.performanceBandwidth);
        }
        if (this.soReuseAddress != null) {
            serverSocket.setReuseAddress(this.soReuseAddress);
        }
        if (this.soTimeout != null && this.soTimeout >= 0) {
            serverSocket.setSoTimeout(this.soTimeout);
        }
    }

    public boolean getDirectBuffer() {
        return this.directBuffer;
    }

    public boolean getOoBInline() {
        return this.ooBInline;
    }

    public int getPerformanceBandwidth() {
        return this.performanceBandwidth;
    }

    public int getPerformanceConnectionTime() {
        return this.performanceConnectionTime;
    }

    public int getPerformanceLatency() {
        return this.performanceLatency;
    }

    public int getRxBufSize() {
        return this.rxBufSize;
    }

    public boolean getSoKeepAlive() {
        return this.soKeepAlive;
    }

    public boolean getSoLingerOn() {
        return this.soLingerOn;
    }

    public int getSoLingerTime() {
        return this.soLingerTime;
    }

    public boolean getSoReuseAddress() {
        return this.soReuseAddress;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getTxBufSize() {
        return this.txBufSize;
    }

    public int getBufferPool() {
        return this.bufferPool;
    }

    public int getBufferPoolSize() {
        return this.bufferPoolSize;
    }

    public int getEventCache() {
        return this.eventCache;
    }

    public int getKeyCache() {
        return this.keyCache;
    }

    public int getAppReadBufSize() {
        return this.appReadBufSize;
    }

    public int getAppWriteBufSize() {
        return this.appWriteBufSize;
    }

    public int getProcessorCache() {
        return this.processorCache;
    }

    public long getTimeoutInterval() {
        return this.timeoutInterval;
    }

    public int getDirectBufferPool() {
        return this.bufferPool;
    }

    public void setPerformanceConnectionTime(int n) {
        this.performanceConnectionTime = n;
    }

    public void setTxBufSize(int n) {
        this.txBufSize = n;
    }

    public void setTcpNoDelay(boolean bl) {
        this.tcpNoDelay = bl;
    }

    public void setSoTimeout(int n) {
        this.soTimeout = n;
    }

    public void setSoReuseAddress(boolean bl) {
        this.soReuseAddress = bl;
    }

    public void setSoLingerTime(int n) {
        this.soLingerTime = n;
    }

    public void setSoKeepAlive(boolean bl) {
        this.soKeepAlive = bl;
    }

    public void setRxBufSize(int n) {
        this.rxBufSize = n;
    }

    public void setPerformanceLatency(int n) {
        this.performanceLatency = n;
    }

    public void setPerformanceBandwidth(int n) {
        this.performanceBandwidth = n;
    }

    public void setOoBInline(boolean bl) {
        this.ooBInline = bl;
    }

    public void setDirectBuffer(boolean bl) {
        this.directBuffer = bl;
    }

    public void setSoLingerOn(boolean bl) {
        this.soLingerOn = bl;
    }

    public void setBufferPool(int n) {
        this.bufferPool = n;
    }

    public void setBufferPoolSize(int n) {
        this.bufferPoolSize = n;
    }

    public void setEventCache(int n) {
        this.eventCache = n;
    }

    public void setKeyCache(int n) {
        this.keyCache = n;
    }

    public void setAppReadBufSize(int n) {
        this.appReadBufSize = n;
    }

    public void setAppWriteBufSize(int n) {
        this.appWriteBufSize = n;
    }

    public void setProcessorCache(int n) {
        this.processorCache = n;
    }

    public void setTimeoutInterval(long l) {
        this.timeoutInterval = l;
    }

    public void setDirectBufferPool(int n) {
        this.bufferPool = n;
    }

    public int getUnlockTimeout() {
        return this.unlockTimeout;
    }

    public void setUnlockTimeout(int n) {
        this.unlockTimeout = n;
    }
}

