/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SocketWrapper<E> {
    protected volatile E socket;
    protected volatile long lastAccess = System.currentTimeMillis();
    protected volatile long timeout = -1L;
    protected boolean error = false;
    protected long lastRegistered = 0L;
    protected volatile int keepAliveLeft = 100;
    private boolean comet = false;
    protected boolean async = false;
    protected boolean keptAlive = false;
    private boolean upgraded = false;
    private boolean secure = false;
    private volatile boolean blockingStatus = true;
    private final Lock blockingStatusReadLock;
    private final ReentrantReadWriteLock.WriteLock blockingStatusWriteLock;
    private final Object writeThreadLock = new Object();

    public SocketWrapper(E e) {
        this.socket = e;
        ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
        this.blockingStatusReadLock = reentrantReadWriteLock.readLock();
        this.blockingStatusWriteLock = reentrantReadWriteLock.writeLock();
    }

    public E getSocket() {
        return this.socket;
    }

    public boolean isComet() {
        return this.comet;
    }

    public void setComet(boolean bl) {
        this.comet = bl;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean bl) {
        this.async = bl;
    }

    public boolean isUpgraded() {
        return this.upgraded;
    }

    public void setUpgraded(boolean bl) {
        this.upgraded = bl;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public void access() {
        if (!this.isAsync()) {
            this.access(System.currentTimeMillis());
        }
    }

    public void access(long l) {
        this.lastAccess = l;
    }

    public void setTimeout(long l) {
        this.timeout = l > 0L ? l : -1L;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean getError() {
        return this.error;
    }

    public void setError(boolean bl) {
        this.error = bl;
    }

    public void setKeepAliveLeft(int n) {
        this.keepAliveLeft = n;
    }

    public int decrementKeepAlive() {
        return --this.keepAliveLeft;
    }

    public boolean isKeptAlive() {
        return this.keptAlive;
    }

    public void setKeptAlive(boolean bl) {
        this.keptAlive = bl;
    }

    public boolean getBlockingStatus() {
        return this.blockingStatus;
    }

    public void setBlockingStatus(boolean bl) {
        this.blockingStatus = bl;
    }

    public Lock getBlockingStatusReadLock() {
        return this.blockingStatusReadLock;
    }

    public ReentrantReadWriteLock.WriteLock getBlockingStatusWriteLock() {
        return this.blockingStatusWriteLock;
    }

    public Object getWriteThreadLock() {
        return this.writeThreadLock;
    }

    public void reset(E e, long l) {
        this.async = false;
        this.blockingStatus = true;
        this.comet = false;
        this.error = false;
        this.keepAliveLeft = 100;
        this.lastAccess = System.currentTimeMillis();
        this.socket = e;
        this.timeout = l;
        this.upgraded = false;
    }

    public String toString() {
        return super.toString() + ":" + String.valueOf(this.socket);
    }
}

