/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.Dictionary;
import com.inet.jortho.LanguageChangeEvent;
import com.inet.jortho.LanguageChangeListener;
import com.inet.jortho.RedZigZagPainter;
import com.inet.jortho.SpellChecker;
import com.inet.jortho.SpellCheckerOptions;
import com.inet.jortho.Tokenizer;
import java.util.Locale;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

class AutoSpellChecker
implements DocumentListener,
LanguageChangeListener {
    private static final RedZigZagPainter painter = new RedZigZagPainter();
    private final JTextComponent jText;
    private final SpellCheckerOptions options;
    private Dictionary dictionary;
    private Locale locale;

    public AutoSpellChecker(JTextComponent jTextComponent, SpellCheckerOptions spellCheckerOptions) {
        this.jText = jTextComponent;
        this.options = spellCheckerOptions == null ? SpellChecker.getOptions() : spellCheckerOptions;
        this.jText.getDocument().addDocumentListener(this);
        SpellChecker.addLanguageChangeLister(this);
        this.dictionary = SpellChecker.getCurrentDictionary();
        this.locale = SpellChecker.getCurrentLocale();
        this.checkAll();
    }

    static void disable(JTextComponent jTextComponent) {
        AbstractDocument abstractDocument = (AbstractDocument)jTextComponent.getDocument();
        for (DocumentListener documentListener : abstractDocument.getDocumentListeners()) {
            if (!(documentListener instanceof AutoSpellChecker)) continue;
            AutoSpellChecker autoSpellChecker = (AutoSpellChecker)documentListener;
            abstractDocument.removeDocumentListener(autoSpellChecker);
            AutoSpellChecker.removeHighlights(jTextComponent);
        }
    }

    private static void removeHighlights(JTextComponent jTextComponent) {
        Highlighter highlighter = jTextComponent.getHighlighter();
        for (Highlighter.Highlight highlight : highlighter.getHighlights()) {
            if (highlight.getPainter() != painter) continue;
            highlighter.removeHighlight(highlight);
        }
    }

    static void refresh(JTextComponent jTextComponent) {
        AbstractDocument abstractDocument = (AbstractDocument)jTextComponent.getDocument();
        for (DocumentListener documentListener : abstractDocument.getDocumentListeners()) {
            if (!(documentListener instanceof AutoSpellChecker)) continue;
            AutoSpellChecker autoSpellChecker = (AutoSpellChecker)documentListener;
            autoSpellChecker.checkAll();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkElements(documentEvent.getOffset(), documentEvent.getLength());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkElements(documentEvent.getOffset(), 0);
    }

    private void checkElements(int n, int n2) {
        int n3 = n + n2;
        Document document = this.jText.getDocument();
        do {
            Element element;
            try {
                element = ((AbstractDocument)document).getParagraphElement(n);
            }
            catch (Exception exception) {
                return;
            }
            this.checkElement(element);
            int n4 = element.getEndOffset();
            int n5 = n = n4 > n ? n4 : n + 1;
        } while (n <= n3 && n < document.getLength());
    }

    private void checkElement(Element element) {
        try {
            String string;
            Object object;
            int n = element.getStartOffset();
            int n2 = element.getEndOffset();
            Highlighter highlighter = this.jText.getHighlighter();
            Highlighter.Highlight[] highlightArray = highlighter.getHighlights();
            int n3 = highlightArray.length;
            while (--n3 >= 0) {
                object = highlightArray[n3];
                int n4 = object.getStartOffset();
                int n5 = object.getEndOffset();
                if ((n > n4 || n4 > n2) && (n > n5 || n5 > n2) || object.getPainter() != painter) continue;
                highlighter.removeHighlight(object);
            }
            n3 = ((AbstractDocument)this.jText.getDocument()).getLength();
            if (n >= (n2 = Math.min(n2, n3))) {
                return;
            }
            object = this.dictionary;
            Locale locale = this.locale;
            if (object == null || locale == null) {
                return;
            }
            Tokenizer tokenizer = new Tokenizer(this.jText, (Dictionary)object, locale, n, n2, this.options);
            while ((string = tokenizer.nextInvalidWord()) != null) {
                int n6 = tokenizer.getWordOffset();
                highlighter.addHighlight(n6, n6 + string.length(), painter);
            }
        }
        catch (BadLocationException badLocationException) {
            SpellChecker.getMessageHandler().handleException(badLocationException);
        }
    }

    private void checkAll() {
        if (this.jText == null) {
            return;
        }
        if (this.dictionary == null) {
            AutoSpellChecker.removeHighlights(this.jText);
            return;
        }
        if (this.jText.getDocument().getLength() == 0) {
            return;
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                Document document = AutoSpellChecker.this.jText.getDocument();
                int n = 0;
                while (n < document.getLength()) {
                    try {
                        final Element element = ((AbstractDocument)document).getParagraphElement(n);
                        n = element.getEndOffset();
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                AutoSpellChecker.this.checkElement(element);
                            }
                        });
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
            }
        }, "JOrtho checkall");
        thread.setPriority(4);
        thread.setDaemon(true);
        thread.start();
    }

    public void languageChanged(LanguageChangeEvent languageChangeEvent) {
        this.dictionary = SpellChecker.getCurrentDictionary();
        this.locale = SpellChecker.getCurrentLocale();
        this.checkAll();
    }
}

