/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.jpeg.drew;

import tim.prune.jpeg.JpegData;
import tim.prune.jpeg.drew.ByteArrayReader;
import tim.prune.jpeg.drew.ExifException;
import tim.prune.jpeg.drew.Rational;

public class ExifTiffHandler {
    private JpegData _jpegData = null;
    private long _thumbnailOffset = -1L;
    private long _thumbnailLength = -1L;
    private static final int DIR_EXIF_SUB_IFD_OFFSET = 34665;
    private static final int DIR_GPS_INFO_OFFSET = 34853;
    private static final int TAG_GPS_LATITUDE_REF = 1;
    private static final int TAG_GPS_LATITUDE = 2;
    private static final int TAG_GPS_LONGITUDE_REF = 3;
    private static final int TAG_GPS_LONGITUDE = 4;
    private static final int TAG_GPS_ALTITUDE = 6;
    private static final int TAG_GPS_BEARING = 17;
    private static final int TAG_ORIENTATION = 274;
    private static final int TAG_THUMBNAIL_OFFSET = 513;
    private static final int TAG_THUMBNAIL_LENGTH = 514;
    private static final int TAG_SUB_ORITIME = 36867;
    private static final int TAG_SUB_DIGITIME = 36868;

    public ExifTiffHandler(JpegData jpegData) {
        this._jpegData = jpegData;
        this._thumbnailLength = -1L;
        this._thumbnailOffset = -1L;
    }

    public boolean isTagIfdPointer(int n) {
        if (n == 34665) {
            return true;
        }
        return n == 34853;
    }

    public void completed(ByteArrayReader byteArrayReader, int n) {
        if (this._thumbnailOffset >= 0L && this._thumbnailLength > 0L) {
            try {
                byte[] byArray = byteArrayReader.getBytes(n + (int)this._thumbnailOffset, (int)this._thumbnailLength);
                if (byArray != null) {
                    byte[] byArray2 = new byte[byArray.length];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                    this._jpegData.setThumbnailImage(byArray2);
                }
            }
            catch (ExifException exifException) {
                // empty catch block
            }
        }
    }

    public void setRationalArray(int n, Rational[] rationalArray) {
        switch (n) {
            case 2: {
                this._jpegData.setLatitude(new double[]{rationalArray[0].doubleValue(), rationalArray[1].doubleValue(), rationalArray[2].convertToPositiveValue()});
                break;
            }
            case 4: {
                this._jpegData.setLongitude(new double[]{rationalArray[0].doubleValue(), rationalArray[1].doubleValue(), rationalArray[2].convertToPositiveValue()});
            }
        }
    }

    public void setRational(int n, Rational rational) {
        switch (n) {
            case 6: {
                this._jpegData.setAltitude(rational.intValue());
                return;
            }
            case 17: {
                this._jpegData.setBearing(rational.doubleValue());
                return;
            }
        }
        if (rational.getDenominator() == 1L) {
            this.setIntegerValue(n, rational.intValue());
        }
    }

    public void setString(int n, String string) {
        switch (n) {
            case 36867: {
                this._jpegData.setOriginalTimestamp(string);
                break;
            }
            case 36868: {
                this._jpegData.setDigitizedTimestamp(string);
                break;
            }
            case 1: {
                this._jpegData.setLatitudeRef(string);
                break;
            }
            case 3: {
                this._jpegData.setLongitudeRef(string);
            }
        }
    }

    public void setIntegerValue(int n, int n2) {
        switch (n) {
            case 274: {
                this._jpegData.setOrientationCode(n2);
                break;
            }
            case 513: {
                this._thumbnailOffset = n2;
                break;
            }
            case 514: {
                this._thumbnailLength = n2;
                break;
            }
            case 17: {
                this._jpegData.setBearing(n2);
            }
        }
    }

    public boolean isInterestingTag(int n, int n2) {
        switch (n) {
            case 34853: {
                return true;
            }
            case 34665: {
                return n2 == 36867 || n2 == 36868;
            }
            case 0: {
                return n2 == 513 || n2 == 514 || n2 == 274;
            }
        }
        return false;
    }
}

