/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.tls.TlsProtocol;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class TlsInputStream
extends InputStream {
    private byte[] buf = new byte[1];
    private TlsProtocol handler = null;

    TlsInputStream(TlsProtocol tlsProtocol) {
        this.handler = tlsProtocol;
    }

    @Override
    public int available() throws IOException {
        return this.handler.applicationDataAvailable();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.handler.readApplicationData(byArray, n, n2);
    }

    @Override
    public int read() throws IOException {
        if (this.read(this.buf) < 0) {
            return -1;
        }
        return this.buf[0] & 0xFF;
    }

    @Override
    public void close() throws IOException {
        this.handler.close();
    }
}

