/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class HandshakeMessageOutput
extends ByteArrayOutputStream {
    static void send(TlsProtocol tlsProtocol, short s, byte[] byArray) throws IOException {
        HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(s, byArray.length);
        handshakeMessageOutput.write(byArray);
        handshakeMessageOutput.send(tlsProtocol);
    }

    HandshakeMessageOutput(short s) throws IOException {
        this(s, 60);
    }

    HandshakeMessageOutput(short s, int n) throws IOException {
        super(n + 4);
        TlsUtils.checkUint8(s);
        TlsUtils.writeUint8(s, (OutputStream)this);
        this.count += 3;
    }

    void send(TlsProtocol tlsProtocol) throws IOException {
        int n = this.count - 4;
        TlsUtils.checkUint24(n);
        TlsUtils.writeUint24(n, this.buf, 1);
        tlsProtocol.writeHandshakeMessage(this.buf, 0, this.count);
        this.buf = null;
    }
}

