/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.io.Reader;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobInputStream;

public class ClobDataID
implements ClobData {
    long id;
    long length = -1L;

    public ClobDataID(long l) {
        this.id = l;
    }

    @Override
    public char[] getChars(SessionInterface sessionInterface, long l, int n) {
        ResultLob resultLob = ResultLob.newLobGetCharsRequest(this.id, l, n);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return ((ResultLob)result).getCharArray();
    }

    @Override
    public long length(SessionInterface sessionInterface) {
        if (this.length > -1L) {
            return this.length;
        }
        ResultLob resultLob = ResultLob.newLobGetLengthRequest(this.id);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        this.length = ((ResultLob)result).getBlockLength();
        return this.length;
    }

    @Override
    public String getSubString(SessionInterface sessionInterface, long l, int n) {
        long l2 = this.length(sessionInterface);
        if (l >= l2) {
            return "";
        }
        if (l + (long)n >= l2) {
            n = (int)(l2 - l);
        }
        char[] cArray = this.getChars(sessionInterface, l, n);
        return new String(cArray);
    }

    @Override
    public ClobData duplicate(SessionInterface sessionInterface) {
        ResultLob resultLob = ResultLob.newLobDuplicateRequest(this.id);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        long l = ((ResultLob)result).getLobID();
        return new ClobDataID(l);
    }

    @Override
    public ClobData getClob(SessionInterface sessionInterface, long l, long l2) {
        ResultLob resultLob = ResultLob.newLobGetRequest(this.id, l, l2);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        long l3 = ((ResultLob)result).getLobID();
        return new ClobDataID(l3);
    }

    @Override
    public void truncate(SessionInterface sessionInterface, long l) {
        if (l >= this.length(sessionInterface)) {
            return;
        }
        ResultLob resultLob = ResultLob.newLobTruncateRequest(this.id, l);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        this.length = ((ResultLob)result).getBlockLength();
    }

    @Override
    public Reader getCharacterStream(SessionInterface sessionInterface) {
        long l = this.length(sessionInterface);
        return new ClobInputStream(sessionInterface, this, 0L, l);
    }

    @Override
    public void setCharacterStream(SessionInterface sessionInterface, long l, Reader reader) {
    }

    @Override
    public void setString(SessionInterface sessionInterface, long l, String string) {
        ResultLob resultLob = ResultLob.newLobSetCharsRequest(this.id, l, string.toCharArray());
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        this.length = ((ResultLob)result).getBlockLength();
    }

    @Override
    public void setClob(SessionInterface sessionInterface, long l, ClobData clobData, long l2, long l3) {
    }

    @Override
    public void setChars(SessionInterface sessionInterface, long l, char[] object, int n, int n2) {
        Result result;
        Object object2;
        if (n != 0 || n2 != ((char[])object).length) {
            if (!ClobDataID.isInLimits(((char[])object).length, n, n2)) {
                throw Error.error(3401);
            }
            if (n != 0 || n2 != ((char[])object).length) {
                object2 = new char[n2];
                System.arraycopy(object, n, object2, 0, n2);
                object = object2;
            }
        }
        if ((result = sessionInterface.execute((Result)(object2 = ResultLob.newLobSetCharsRequest(this.id, l, object)))).isError()) {
            throw result.getException();
        }
        this.length = ((ResultLob)result).getBlockLength();
    }

    @Override
    public long position(SessionInterface sessionInterface, String string, long l) {
        ResultLob resultLob = ResultLob.newLobGetCharPatternPositionRequest(this.id, string.toCharArray(), l);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return ((ResultLob)result).getOffset();
    }

    @Override
    public long position(SessionInterface sessionInterface, ClobData clobData, long l) {
        ResultLob resultLob = ResultLob.newLobGetCharPatternPositionRequest(this.id, clobData.getId(), l);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return ((ResultLob)result).getOffset();
    }

    @Override
    public long nonSpaceLength(SessionInterface sessionInterface) {
        ResultLob resultLob = ResultLob.newLobGetTruncateLength(this.id);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return ((ResultLob)result).getBlockLength();
    }

    @Override
    public Reader getCharacterStream(SessionInterface sessionInterface, long l, long l2) {
        return new ClobInputStream(sessionInterface, this, l, l2);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long l) {
        this.id = l;
    }

    static boolean isInLimits(long l, long l2, long l3) {
        return l2 >= 0L && l3 >= 0L && l2 + l3 <= l;
    }

    @Override
    public void setSession(SessionInterface sessionInterface) {
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof ClobDataID) {
            return this.id == ((ClobDataID)object).id;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.id;
    }
}

