/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ComponentStyle;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.nwdiag.LinkedElement;
import net.sourceforge.plantuml.nwdiag.Network;
import net.sourceforge.plantuml.skin.ActorStyle;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class Square {
    private USymbol shape = USymbol.RECTANGLE;
    private final String name;
    private String description;
    private final Network mainNetwork;
    private final ISkinSimple spriteContainer;
    private boolean hasItsOwnColumn = true;

    public String toString() {
        return this.name;
    }

    public Square(String name, Network network, ISkinSimple spriteContainer) {
        this.description = name;
        this.mainNetwork = network;
        this.name = name;
        this.spriteContainer = spriteContainer;
    }

    private TextBlock toTextBlock(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        s = s.replace(", ", "\\n");
        return Display.getWithNewlines(s).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.spriteContainer);
    }

    private FontConfiguration getFontConfiguration() {
        UFont font = UFont.serif(11);
        return new FontConfiguration(font, HColorUtils.BLACK, HColorUtils.BLACK, false);
    }

    public LinkedElement asTextBlock(Map<Network, String> conns, List<Network> networks) {
        LinkedHashMap<Network, TextBlock> conns2 = new LinkedHashMap<Network, TextBlock>();
        for (Map.Entry<Network, String> ent : conns.entrySet()) {
            conns2.put(ent.getKey(), this.toTextBlock(ent.getValue()));
        }
        SymbolContext symbolContext = new SymbolContext(ColorParam.activityBackground.getDefaultValue(), ColorParam.activityBorder.getDefaultValue()).withShadow(3.0);
        TextBlock desc = this.toTextBlock(this.description);
        TextBlock box = this.shape.asSmall(TextBlockUtils.empty(0.0, 0.0), desc, TextBlockUtils.empty(0.0, 0.0), symbolContext, HorizontalAlignment.CENTER);
        return new LinkedElement(this, box, conns2, networks);
    }

    public String getDescription() {
        return this.description;
    }

    public final Network getMainNetwork() {
        return this.mainNetwork;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public final void setShape(String shapeName) {
        USymbol shapeFromString = USymbol.fromString(shapeName, ActorStyle.STICKMAN, ComponentStyle.RECTANGLE, PackageStyle.RECTANGLE);
        if (shapeFromString != null) {
            this.shape = shapeFromString;
        }
    }

    public void doNotHaveItsOwnColumn() {
        this.hasItsOwnColumn = false;
    }

    public final boolean hasItsOwnColumn() {
        return this.hasItsOwnColumn;
    }
}

