/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.project.Arrows;
import net.sourceforge.plantuml.project.ToTaskDraw;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskAttribute;
import net.sourceforge.plantuml.project.core.TaskInstant;
import net.sourceforge.plantuml.project.draw.TaskDraw;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class GanttArrow
implements UDrawable {
    private final TimeScale timeScale;
    private final Direction atStart;
    private final TaskInstant source;
    private final Direction atEnd;
    private final TaskInstant dest;
    private final HColor color;
    private final LinkType style;
    private final ToTaskDraw toTaskDraw;

    public GanttArrow(TimeScale timeScale, TaskInstant source, TaskInstant dest, HColor color, LinkType style, ToTaskDraw toTaskDraw) {
        this.toTaskDraw = toTaskDraw;
        this.style = style;
        this.color = color;
        this.timeScale = timeScale;
        this.source = source;
        this.dest = dest;
        if (source.getAttribute() == TaskAttribute.END && dest.getAttribute() == TaskAttribute.START) {
            this.atStart = source.sameRowAs(dest) ? Direction.LEFT : Direction.DOWN;
            this.atEnd = Direction.RIGHT;
        } else if (source.getAttribute() == TaskAttribute.END && dest.getAttribute() == TaskAttribute.END) {
            this.atStart = Direction.RIGHT;
            this.atEnd = Direction.LEFT;
        } else if (source.getAttribute() == TaskAttribute.START && dest.getAttribute() == TaskAttribute.START) {
            this.atStart = Direction.LEFT;
            this.atEnd = Direction.RIGHT;
        } else if (source.getAttribute() == TaskAttribute.START && dest.getAttribute() == TaskAttribute.END) {
            this.atStart = source.sameRowAs(dest) ? Direction.RIGHT : Direction.DOWN;
            this.atEnd = Direction.LEFT;
        } else {
            throw new IllegalArgumentException();
        }
    }

    private TaskDraw getSource() {
        return this.toTaskDraw.getTaskDraw((Task)this.source.getMoment());
    }

    private TaskDraw getDestination() {
        return this.toTaskDraw.getTaskDraw((Task)this.dest.getMoment());
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = ug.apply(this.color.bg()).apply(this.color).apply(this.style.getStroke3(new UStroke(1.5)));
        double x1 = this.getX(this.source.withDelta(0), this.atStart);
        double y1 = this.getSource().getY(this.atStart);
        double x2 = this.getX(this.dest, this.atEnd.getInv());
        double y2 = this.getDestination().getY(this.atEnd);
        if (this.atStart == Direction.DOWN && y2 < y1) {
            y1 = this.getSource().getY(this.atStart.getInv());
        }
        if (this.atStart == Direction.DOWN && this.atEnd == Direction.RIGHT) {
            if (x2 > x1) {
                if (x2 - x1 < 8.0) {
                    x1 = x2 - 8.0;
                }
                this.drawLine(ug, x1, y1, x1, y2, x2, y2);
            } else {
                x1 = this.getX(this.source.withDelta(0), Direction.RIGHT);
                y1 = this.getSource().getY(Direction.RIGHT);
                this.drawLine(ug, x1, y1, x1 + 6.0, y1, x1 + 6.0, y1 + 8.0, x2 - 8.0, y1 + 8.0, x2 - 8.0, y2, x2, y2);
            }
        } else if (this.atStart == Direction.RIGHT && this.atEnd == Direction.LEFT) {
            double xmax = Math.max(x1, x2) + 8.0;
            this.drawLine(ug, x1, y1, xmax, y1, xmax, y2, x2, y2);
        } else if (this.atStart == Direction.LEFT && this.atEnd == Direction.RIGHT) {
            double xmin = Math.min(x1, x2) - 8.0;
            this.drawLine(ug, x1, y1, xmin, y1, xmin, y2, x2, y2);
        } else if (this.atStart == Direction.DOWN && this.atEnd == Direction.LEFT) {
            this.drawLine(ug, x1, y1, x1, y2, x2, y2);
        } else {
            throw new IllegalArgumentException();
        }
        ug = ug.apply(new UStroke(1.5));
        ug.apply(new UTranslate(x2, y2)).draw(Arrows.asTo(this.atEnd));
    }

    private void drawLine(UGraphic ug, double ... coord) {
        for (int i = 0; i < coord.length - 2; i += 2) {
            double x1 = coord[i];
            double y1 = coord[i + 1];
            double x2 = coord[i + 2];
            double y2 = coord[i + 3];
            ug.apply(new UTranslate(x1, y1)).draw(new ULine(x2 - x1, y2 - y1));
        }
    }

    private double getX(TaskInstant when, Direction direction) {
        double x1 = this.timeScale.getStartingPosition(when.getInstantTheorical());
        double x2 = this.timeScale.getEndingPosition(when.getInstantTheorical());
        if (direction == Direction.LEFT) {
            return x1;
        }
        if (direction == Direction.RIGHT) {
            return x2;
        }
        return (x1 + x2) / 2.0;
    }
}

