/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.git;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.user.UserNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitRepositoryManager
implements UserNameProvider {
    private static final Logger logger = LoggerFactory.getLogger(GitRepositoryManager.class);
    private static final String USER_SECTION = "user";
    private static final String USER_NAME = "name";
    @Nonnull
    private final OWLModelManager modelManager;
    @Nullable
    private final Repository repository;

    private GitRepositoryManager(@Nonnull OWLModelManager modelManager, @Nullable Repository repository) {
        this.modelManager = (OWLModelManager)Preconditions.checkNotNull((Object)modelManager);
        this.repository = repository;
    }

    @Nonnull
    public static GitRepositoryManager get(@Nonnull OWLModelManager modelManager) {
        Optional<Path> repoDir = GitRepositoryManager.getRepositoryDirectory((OWLModelManager)Preconditions.checkNotNull((Object)modelManager));
        if (repoDir.isPresent()) {
            logger.info("[GitRepo] Git repository detected: {}", (Object)repoDir.get());
            try {
                Repository repo = ((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(repoDir.get().toFile())).build();
                return new GitRepositoryManager(modelManager, repo);
            }
            catch (IOException e) {
                logger.warn("[GitRepo] An error occurred whilst build the Git repository: {}", (Object)e.getMessage(), (Object)e);
                return new GitRepositoryManager(modelManager, null);
            }
        }
        return new GitRepositoryManager(modelManager, null);
    }

    public boolean isGitRepositoryPresent() {
        return this.repository != null;
    }

    @Nonnull
    public Optional<Repository> getRepository() {
        return Optional.ofNullable(this.repository);
    }

    @Nonnull
    public Optional<String> getBranchName() {
        if (this.repository == null) {
            return Optional.empty();
        }
        try {
            String branchName = this.repository.getBranch();
            return Optional.of(branchName);
        }
        catch (IOException e) {
            logger.warn("[GitRepo] An error occurred whilst getting the current branch name: {}", (Object)e.getMessage(), (Object)e);
            return Optional.empty();
        }
    }

    @Override
    @Nonnull
    public Optional<String> getUserName() {
        return this.getRepository().map(repo -> repo.getConfig().getString(USER_SECTION, null, USER_NAME));
    }

    public boolean isAnyOntologyDocumentModified() {
        if (this.repository == null) {
            return false;
        }
        Stream<Path> ontologyDocumentPathsStream = this.getModifiedOntologyDocumentPaths();
        return ontologyDocumentPathsStream.findFirst().isPresent();
    }

    private Stream<Path> getModifiedOntologyDocumentPaths() {
        try {
            if (this.repository == null) {
                return Stream.empty();
            }
            Git git = new Git(this.repository);
            Status status = git.status().call();
            Path gitDirectory = this.repository.getDirectory().toPath();
            Path parentDirectory = gitDirectory.getParent();
            Stream paths = Stream.concat(status.getModified().stream(), status.getChanged().stream());
            Set<Path> ontologyDocumentPaths = this.getFileBasedOntologyDocumentPaths();
            return paths.map(parentDirectory::resolve).filter(ontologyDocumentPaths::contains);
        }
        catch (GitAPIException e) {
            logger.warn("[GitRepo] An error occurred whilst getting repository information: ", (Object)e.getMessage(), (Object)e);
            return Stream.empty();
        }
    }

    private Set<Path> getFileBasedOntologyDocumentPaths() {
        return this.modelManager.getOntologies().stream().map(this.modelManager::getOntologyPhysicalURI).filter(u -> u.getScheme().equals("file")).map(Paths::get).collect(Collectors.toSet());
    }

    public void dispose() {
        this.getRepository().ifPresent(Repository::close);
    }

    private static Optional<Path> getRepositoryDirectory(@Nonnull OWLModelManager modelManager) {
        URI ontologyDocumentURI = modelManager.getOntologyPhysicalURI(modelManager.getActiveOntology());
        if (!"file".equals(ontologyDocumentURI.getScheme())) {
            return Optional.empty();
        }
        Path ontologyDocumentPath = Paths.get(ontologyDocumentURI);
        for (Path parentPath = ontologyDocumentPath.getParent(); parentPath != null; parentPath = parentPath.getParent()) {
            Path gitDirectoryPath = parentPath.resolve(".git");
            if (!Files.isDirectory(gitDirectoryPath, new LinkOption[0])) continue;
            return Optional.of(gitDirectoryPath);
        }
        return Optional.empty();
    }
}

