/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.exceptions;

import io.micronaut.context.Qualifier;
import io.micronaut.context.exceptions.BeanContextException;
import org.jetbrains.annotations.NotNull;

public class NoSuchBeanException
extends BeanContextException {
    public NoSuchBeanException(Class beanType) {
        super("No bean of type [" + beanType.getName() + "] exists." + NoSuchBeanException.additionalMessage());
    }

    public <T> NoSuchBeanException(Class<T> beanType, Qualifier<T> qualifier) {
        super("No bean of type [" + beanType.getName() + "] exists" + (qualifier != null ? " for the given qualifier: " + qualifier : "") + "." + NoSuchBeanException.additionalMessage());
    }

    protected NoSuchBeanException(String message) {
        super(message);
    }

    @NotNull
    private static String additionalMessage() {
        return " Make sure the bean is not disabled by bean requirements (enable trace logging for 'io.micronaut.context.condition' to check) and if the bean is enabled then ensure the class is declared a bean and annotation processing is enabled (for Java and Kotlin the 'micronaut-inject-java' dependency should be configured as an annotation processor).";
    }
}

