/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.aether;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.bridge.MavenRepositorySystem;
import org.apache.maven.eventspy.internal.EventSpyDispatcher;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.internal.aether.LoggingRepositoryListener;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.eclipse.aether.util.repository.SimpleResolutionErrorPolicy;
import org.eclipse.sisu.Nullable;

@Named
public class DefaultRepositorySystemSessionFactory {
    @Inject
    private Logger logger;
    @Inject
    private ArtifactHandlerManager artifactHandlerManager;
    @Inject
    private RepositorySystem repoSystem;
    @Inject
    @Nullable
    @Named(value="simple")
    private LocalRepositoryManagerFactory simpleLocalRepoMgrFactory;
    @Inject
    @Nullable
    @Named(value="ide")
    private WorkspaceReader workspaceRepository;
    @Inject
    private SettingsDecrypter settingsDecrypter;
    @Inject
    private EventSpyDispatcher eventSpyDispatcher;
    @Inject
    MavenRepositorySystem mavenRepositorySystem;

    public DefaultRepositorySystemSession newRepositorySession(MavenExecutionRequest request) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setCache(request.getRepositoryCache());
        LinkedHashMap<Object, Object> configProps = new LinkedHashMap<Object, Object>();
        configProps.put("aether.connector.userAgent", this.getUserAgent());
        configProps.put("aether.interactive", request.isInteractiveMode());
        configProps.putAll(request.getSystemProperties());
        configProps.putAll(request.getUserProperties());
        session.setOffline(request.isOffline());
        session.setChecksumPolicy(request.getGlobalChecksumPolicy());
        if (request.isNoSnapshotUpdates()) {
            session.setUpdatePolicy("never");
        } else if (request.isUpdateSnapshots()) {
            session.setUpdatePolicy("always");
        } else {
            session.setUpdatePolicy(null);
        }
        int errorPolicy = 0;
        errorPolicy |= request.isCacheNotFound() ? 1 : 0;
        session.setResolutionErrorPolicy(new SimpleResolutionErrorPolicy(errorPolicy |= request.isCacheTransferError() ? 2 : 0, errorPolicy | 1));
        session.setArtifactTypeRegistry(RepositoryUtils.newArtifactTypeRegistry(this.artifactHandlerManager));
        LocalRepository localRepo = new LocalRepository(request.getLocalRepository().getBasedir());
        if (request.isUseLegacyLocalRepository()) {
            try {
                session.setLocalRepositoryManager(this.simpleLocalRepoMgrFactory.newInstance(session, localRepo));
                this.logger.info("Disabling enhanced local repository: using legacy is strongly discouraged to ensure build reproducibility.");
            }
            catch (NoLocalRepositoryManagerException e2) {
                this.logger.error("Failed to configure legacy local repository: falling back to default");
                session.setLocalRepositoryManager(this.repoSystem.newLocalRepositoryManager(session, localRepo));
            }
        } else {
            session.setLocalRepositoryManager(this.repoSystem.newLocalRepositoryManager(session, localRepo));
        }
        if (request.getWorkspaceReader() != null) {
            session.setWorkspaceReader(request.getWorkspaceReader());
        } else {
            session.setWorkspaceReader(this.workspaceRepository);
        }
        DefaultSettingsDecryptionRequest decrypt = new DefaultSettingsDecryptionRequest();
        decrypt.setProxies((List)request.getProxies());
        decrypt.setServers((List)request.getServers());
        SettingsDecryptionResult decrypted = this.settingsDecrypter.decrypt(decrypt);
        if (this.logger.isDebugEnabled()) {
            for (SettingsProblem settingsProblem : decrypted.getProblems()) {
                this.logger.debug(settingsProblem.getMessage(), settingsProblem.getException());
            }
        }
        DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
        for (Mirror mirror : request.getMirrors()) {
            mirrorSelector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        session.setMirrorSelector(mirrorSelector);
        DefaultProxySelector defaultProxySelector = new DefaultProxySelector();
        for (org.apache.maven.settings.Proxy proxy2 : decrypted.getProxies()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(proxy2.getUsername()).addPassword(proxy2.getPassword());
            defaultProxySelector.add(new Proxy(proxy2.getProtocol(), proxy2.getHost(), proxy2.getPort(), authBuilder.build()), proxy2.getNonProxyHosts());
        }
        session.setProxySelector(defaultProxySelector);
        DefaultAuthenticationSelector defaultAuthenticationSelector = new DefaultAuthenticationSelector();
        for (Server server2 : decrypted.getServers()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(server2.getUsername()).addPassword(server2.getPassword());
            authBuilder.addPrivateKey(server2.getPrivateKey(), server2.getPassphrase());
            defaultAuthenticationSelector.add(server2.getId(), authBuilder.build());
            if (server2.getConfiguration() != null) {
                Xpp3Dom dom = (Xpp3Dom)server2.getConfiguration();
                for (int i = dom.getChildCount() - 1; i >= 0; --i) {
                    Xpp3Dom child = dom.getChild(i);
                    if (!"wagonProvider".equals(child.getName())) continue;
                    dom.removeChild(i);
                }
                XmlPlexusConfiguration config = new XmlPlexusConfiguration(dom);
                configProps.put("aether.connector.wagon.config." + server2.getId(), config);
            }
            configProps.put("aether.connector.perms.fileMode." + server2.getId(), server2.getFilePermissions());
            configProps.put("aether.connector.perms.dirMode." + server2.getId(), server2.getDirectoryPermissions());
        }
        session.setAuthenticationSelector(defaultAuthenticationSelector);
        session.setTransferListener(request.getTransferListener());
        session.setRepositoryListener(this.eventSpyDispatcher.chainListener(new LoggingRepositoryListener(this.logger)));
        session.setUserProperties(request.getUserProperties());
        session.setSystemProperties(request.getSystemProperties());
        session.setConfigProperties(configProps);
        this.mavenRepositorySystem.injectMirror(request.getRemoteRepositories(), request.getMirrors());
        this.mavenRepositorySystem.injectProxy(session, request.getRemoteRepositories());
        this.mavenRepositorySystem.injectAuthentication(session, request.getRemoteRepositories());
        this.mavenRepositorySystem.injectMirror(request.getPluginArtifactRepositories(), request.getMirrors());
        this.mavenRepositorySystem.injectProxy(session, request.getPluginArtifactRepositories());
        this.mavenRepositorySystem.injectAuthentication(session, request.getPluginArtifactRepositories());
        return session;
    }

    private String getUserAgent() {
        return "Apache-Maven/" + this.getMavenVersion() + " (Java " + System.getProperty("java.version") + "; " + System.getProperty("os.name") + " " + System.getProperty("os.version") + ")";
    }

    private String getMavenVersion() {
        Properties props = new Properties();
        try (InputStream is2 = this.getClass().getResourceAsStream("/META-INF/maven/org.apache.maven/maven-core/pom.properties");){
            if (is2 != null) {
                props.load(is2);
            }
        }
        catch (IOException e2) {
            this.logger.debug("Failed to read Maven version", e2);
        }
        return props.getProperty("version", "unknown-version");
    }
}

