/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyModule;
import org.jruby.ir.IRClassBody;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.TwoOperandResultBaseInstr;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class DefineClassInstr
extends TwoOperandResultBaseInstr
implements FixedArityInstr {
    private final IRClassBody body;

    public DefineClassInstr(Variable result2, IRClassBody body, Operand container, Operand superClass) {
        super(Operation.DEF_CLASS, result2, container, superClass == null ? UndefinedValue.UNDEFINED : superClass);
        assert (result2 != null) : "DefineClassInstr result is null";
        this.body = body;
    }

    public IRClassBody getNewIRClassBody() {
        return this.body;
    }

    public Operand getContainer() {
        return this.getOperand1();
    }

    public Operand getSuperClass() {
        return this.getOperand2();
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new DefineClassInstr(ii.getRenamedVariable(this.result), this.body, this.getContainer().cloneForInlining(ii), this.getSuperClass().cloneForInlining(ii));
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"name: " + this.body.getId()};
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getNewIRClassBody());
        e.encode(this.getContainer());
        e.encode(this.getSuperClass());
    }

    public static DefineClassInstr decode(IRReaderDecoder d) {
        return new DefineClassInstr(d.decodeVariable(), (IRClassBody)d.decodeScope(), d.decodeOperand(), d.decodeOperand());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        Object container = this.getContainer().retrieve(context, self2, currScope, currDynScope, temp);
        Object superClass = this.getSuperClass().retrieve(context, self2, currScope, currDynScope, temp);
        RubyModule clazz = IRRuntimeHelpers.newRubyClassFromIR(context.runtime, this.body, superClass, container);
        return this.INTERPRET_CLASS(context, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_CLASS(ThreadContext context, RubyModule clazz) {
        boolean hasExplicitCallProtocol;
        InterpreterContext ic = this.body.getInterpreterContext();
        String id2 = this.body.getId();
        if (ic == null) {
            System.out.println("IC REMOVED FOR: " + this);
            System.out.println("BODY: " + this.body);
        }
        if (!(hasExplicitCallProtocol = ic.hasExplicitCallProtocol())) {
            this.pre(ic, context, clazz, null, clazz);
        }
        try {
            ThreadContext.pushBacktrace(context, id2, ic.getFileName(), context.getLine());
            IRubyObject iRubyObject = ic.getEngine().interpret(context, null, clazz, ic, clazz.getMethodLocation(), id2, Block.NULL_BLOCK);
            return iRubyObject;
        }
        finally {
            this.body.cleanupAfterExecution();
            if (!hasExplicitCallProtocol) {
                this.post(ic, context);
            }
            ThreadContext.popBacktrace(context);
        }
    }

    private void post(InterpreterContext ic, ThreadContext context) {
        context.popFrame();
        if (ic.popDynScope()) {
            context.popScope();
        }
    }

    private void pre(InterpreterContext ic, ThreadContext context, IRubyObject self2, String name2, RubyModule implClass) {
        context.preMethodFrameOnly(implClass, name2, self2);
        if (ic.pushNewDynScope()) {
            context.pushScope(DynamicScope.newDynamicScope(ic.getStaticScope()));
        }
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.DefineClassInstr(this);
    }
}

