/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.python.core.BaseSet;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyException;
import org.python.core.PyFrozenSet;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PySet$PyExposer;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.util.Generic;

@ExposedType(name="set", base=PyObject.class, doc="set() -> new empty set object\nset(iterable) -> new set object\n\nBuild an unordered collection of unique elements.")
public class PySet
extends BaseSet {
    public static final PyType TYPE;

    public PySet() {
        this(TYPE);
    }

    public PySet(PyType type) {
        super(type, Generic.concurrentSet());
        TYPE.object___setattr__("__hash__", Py.None);
    }

    public PySet(PyObject data) {
        super(TYPE, PySet._update(Generic.concurrentSet(), data));
        TYPE.object___setattr__("__hash__", Py.None);
    }

    public PySet(PyObject[] data) {
        super(TYPE, PySet._update(Generic.concurrentSet(), data));
        TYPE.object___setattr__("__hash__", Py.None);
    }

    public PySet(Set backing_set, PyObject data) {
        super(TYPE, PySet._update((Set<PyObject>)backing_set, data));
        TYPE.object___setattr__("__hash__", Py.None);
    }

    public PySet(PyType type, Set backing_set, PyObject data) {
        super(type, PySet._update((Set<PyObject>)backing_set, data));
        TYPE.object___setattr__("__hash__", Py.None);
    }

    @ExposedNew
    final void set___init__(PyObject[] args, String[] kwds) {
        if (args.length > 1 || kwds.length != 0) {
            throw PyBuiltinCallable.DefaultInfo.unexpectedCall(args.length, false, "Set", 0, 1);
        }
        if (args.length == 0) {
            return;
        }
        this._set.clear();
        this._update(args[0]);
    }

    final PyObject set___cmp__(PyObject o) {
        return new PyInteger(this.baseset___cmp__(o));
    }

    final PyObject set___ne__(PyObject o) {
        return this.baseset___ne__(o);
    }

    final PyObject set___eq__(PyObject o) {
        return this.baseset___eq__(o);
    }

    final PyObject set___or__(PyObject o) {
        return this.baseset___or__(o);
    }

    final PyObject set___xor__(PyObject o) {
        return this.baseset___xor__(o);
    }

    final PyObject set___sub__(PyObject o) {
        return this.baseset___sub__(o);
    }

    final PyObject set___and__(PyObject o) {
        return this.baseset___and__(o);
    }

    final PyObject set___lt__(PyObject o) {
        return this.baseset___lt__(o);
    }

    final PyObject set___gt__(PyObject o) {
        return this.baseset___gt__(o);
    }

    final PyObject set___ge__(PyObject o) {
        return this.baseset___ge__(o);
    }

    final PyObject set___le__(PyObject o) {
        return this.baseset___le__(o);
    }

    final PyObject set___iter__() {
        return this.baseset___iter__();
    }

    final boolean set___contains__(PyObject item) {
        return this.baseset___contains__(item);
    }

    final PyObject set_copy() {
        return this.baseset_copy();
    }

    final PyObject set_union(PyObject[] args, String[] kws) {
        if (kws.length > 0) {
            throw Py.TypeError("union() takes no keyword arguments");
        }
        return this.baseset_union(args);
    }

    final PyObject set_difference(PyObject[] args, String[] kws) {
        if (kws.length > 0) {
            throw Py.TypeError("difference() takes no keyword arguments");
        }
        return this.baseset_difference(args);
    }

    final PyObject set_symmetric_difference(PyObject set) {
        return this.baseset_symmetric_difference(set);
    }

    final PyObject set_intersection(PyObject[] args, String[] kws) {
        if (kws.length > 0) {
            throw Py.TypeError("intersection() takes no keyword arguments");
        }
        return this.baseset_intersection(args);
    }

    final PyObject set_issubset(PyObject set) {
        return this.baseset_issubset(set);
    }

    final PyObject set_issuperset(PyObject set) {
        return this.baseset_issuperset(set);
    }

    final PyObject set_isdisjoint(PyObject set) {
        return this.baseset_isdisjoint(set);
    }

    final int set___len__() {
        return this.baseset___len__();
    }

    final PyObject set___reduce__() {
        return this.baseset___reduce__();
    }

    @Override
    public PyObject __ior__(PyObject other) {
        return this.set___ior__(other);
    }

    final PyObject set___ior__(PyObject other) {
        if (!(other instanceof BaseSet)) {
            return null;
        }
        this._set.addAll(((BaseSet)other)._set);
        return this;
    }

    @Override
    public PyObject __ixor__(PyObject other) {
        return this.set___ixor__(other);
    }

    final PyObject set___ixor__(PyObject other) {
        if (!(other instanceof BaseSet)) {
            return null;
        }
        this.set_symmetric_difference_update(other);
        return this;
    }

    @Override
    public PyObject __iand__(PyObject other) {
        return this.set___iand__(other);
    }

    final PyObject set___iand__(PyObject other) {
        if (!(other instanceof BaseSet)) {
            return null;
        }
        this._set = ((BaseSet)this.__and__((PyObject)other))._set;
        return this;
    }

    @Override
    public PyObject __isub__(PyObject other) {
        return this.set___isub__(other);
    }

    final PyObject set___isub__(PyObject other) {
        if (!(other instanceof BaseSet)) {
            return null;
        }
        this._set.removeAll(((BaseSet)other)._set);
        return this;
    }

    @Override
    public int hashCode() {
        return this.set___hash__();
    }

    final int set___hash__() {
        throw Py.TypeError("set objects are unhashable");
    }

    final void set_add(PyObject o) {
        this._set.add(o);
    }

    final void set_remove(PyObject o) {
        boolean b = false;
        try {
            b = this._set.remove(o);
        }
        catch (PyException e) {
            PyFrozenSet frozen = this.asFrozen(e, o);
            b = this._set.remove(frozen);
        }
        if (!b) {
            throw new PyException(Py.KeyError, o);
        }
    }

    final void set_discard(PyObject o) {
        try {
            this._set.remove(o);
        }
        catch (PyException e) {
            PyFrozenSet frozen = this.asFrozen(e, o);
            this._set.remove(frozen);
        }
    }

    final synchronized PyObject set_pop() {
        Iterator iterator = this._set.iterator();
        try {
            Object first = iterator.next();
            this._set.remove(first);
            return (PyObject)first;
        }
        catch (NoSuchElementException e) {
            throw new PyException(Py.KeyError, "pop from an empty set");
        }
    }

    final void set_clear() {
        this._set.clear();
    }

    final void set_update(PyObject[] args, String[] kws) {
        if (kws.length > 0) {
            throw Py.TypeError("update() takes no keyword arguments");
        }
        for (PyObject item : args) {
            this._update(item);
        }
    }

    final void set_intersection_update(PyObject[] args, String[] kws) {
        if (kws.length > 0) {
            throw Py.TypeError("intersection_update() takes no keyword arguments");
        }
        for (PyObject other : args) {
            if (other instanceof BaseSet) {
                this.set___iand__(other);
                continue;
            }
            BaseSet set = (BaseSet)this.baseset_intersection(other);
            this._set = set._set;
        }
    }

    final void set_symmetric_difference_update(PyObject other) {
        if (this == other) {
            this.set_clear();
            return;
        }
        BaseSet bs = other instanceof BaseSet ? (BaseSet)other : new PySet(other);
        for (PyObject o : bs._set) {
            if (this._set.contains(o)) {
                this._set.remove(o);
                continue;
            }
            this._set.add(o);
        }
    }

    final void set_difference_update(PyObject[] args, String[] kws) {
        if (kws.length > 0) {
            throw Py.TypeError("difference_update() takes no keyword arguments");
        }
        if (args.length == 0) {
            return;
        }
        for (PyObject other : args) {
            if (other instanceof BaseSet) {
                this.set___isub__(other);
            }
            for (PyObject o : other.asIterable()) {
                if (!this.__contains__(o)) continue;
                this._set.remove(o);
            }
        }
    }

    final String set_toString() {
        return this.baseset_toString();
    }

    static {
        PyType.addBuilder(PySet.class, new PySet$PyExposer());
        TYPE = PyType.fromClass(PySet.class);
    }
}

