/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.builder;

import com.intellij.openapi.project.Project;
import com.intellij.psi.util.CachedValueProvider;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.KotlinModificationTrackerService;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.asJava.builder.ClassFilterForScript;
import org.jetbrains.kotlin.asJava.builder.LightClassBuilderKt;
import org.jetbrains.kotlin.asJava.builder.LightClassBuilderResult;
import org.jetbrains.kotlin.asJava.builder.LightClassConstructionContext;
import org.jetbrains.kotlin.asJava.builder.LightClassDataHolder;
import org.jetbrains.kotlin.asJava.builder.LightClassDataProviderForScript;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0007H\u0016J\b\u0010\b\u001a\u00020\u0002H\u0002J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/asJava/builder/LightClassDataProviderForScript;", "Lcom/intellij/psi/util/CachedValueProvider;", "Lorg/jetbrains/kotlin/asJava/builder/LightClassDataHolder$ForScript;", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "(Lorg/jetbrains/kotlin/psi/KtScript;)V", "compute", "Lcom/intellij/psi/util/CachedValueProvider$Result;", "computeLightClassData", "toString", "", "light-classes"})
public final class LightClassDataProviderForScript
implements CachedValueProvider<LightClassDataHolder.ForScript> {
    @NotNull
    private final KtScript script;

    public LightClassDataProviderForScript(@NotNull KtScript script) {
        Intrinsics.checkNotNullParameter(script, "script");
        this.script = script;
    }

    private final LightClassDataHolder.ForScript computeLightClassData() {
        Project project = this.script.getProject();
        Intrinsics.checkNotNullExpressionValue(project, "script.project");
        return LightClassGenerationSupport.Companion.getInstance(project).createDataHolderForScript(this.script, (Function1<? super LightClassConstructionContext, LightClassBuilderResult>)new Function1<LightClassConstructionContext, LightClassBuilderResult>(this){
            final /* synthetic */ LightClassDataProviderForScript this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final LightClassBuilderResult invoke(@NotNull LightClassConstructionContext constructionContext) {
                Intrinsics.checkNotNullParameter(constructionContext, "constructionContext");
                FqName fqName2 = LightClassDataProviderForScript.access$getScript$p(this.this$0).getFqName().parent();
                Intrinsics.checkNotNullExpressionValue(fqName2, "script.fqName.parent()");
                return LightClassBuilderKt.buildLightClass(fqName2, (Collection<? extends KtFile>)CollectionsKt.listOf(LightClassDataProviderForScript.access$getScript$p(this.this$0).getContainingKtFile()), new ClassFilterForScript(LightClassDataProviderForScript.access$getScript$p(this.this$0)), constructionContext, computeLightClassData.1.INSTANCE);
            }
        });
    }

    @Override
    @Nullable
    public CachedValueProvider.Result<LightClassDataHolder.ForScript> compute() {
        LightClassDataHolder.ForScript forScript = this.computeLightClassData();
        Object[] objectArray = new Object[1];
        Project project = this.script.getProject();
        Intrinsics.checkNotNullExpressionValue(project, "script.project");
        objectArray[0] = KotlinModificationTrackerService.Companion.getInstance(project).getOutOfBlockModificationTracker();
        return CachedValueProvider.Result.create(forScript, objectArray);
    }

    @NotNull
    public String toString() {
        return this.getClass().getName() + " for " + this.script.getFqName();
    }

    public static final /* synthetic */ KtScript access$getScript$p(LightClassDataProviderForScript $this) {
        return $this.script;
    }
}

