/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.starter;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mediathek.config.Config;
import mediathek.controller.starter.Start;
import mediathek.gui.messages.DownloadProgressChangedEvent;
import mediathek.tool.MVFilmSize;
import mediathek.tool.MessageBus;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class RuntimeExec {
    public static final String TRENNER_PROG_ARRAY = "<>";
    private static final LoadingCache<String, Pattern> CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build(new PatternCacheLoader());
    private static final String PATTERN_FFMPEG = "(?<=  Duration: )[^,]*";
    private static final String PATTERN_TIME = "(?<=time=)[^ ]*";
    private static final String PATTERN_SIZE = "(?<=size=)[^k]*";
    private static final Logger logger = LogManager.getLogger();
    private static final AtomicInteger processNr = new AtomicInteger(0);
    private final String strProgCall;
    private Process process;
    private Start start;
    private double totalSecs;
    private long oldSize;
    private long oldSecs;
    private MVFilmSize mVFilmSize;
    private String[] arrProgCallArray;
    private String strProgCallArray = "";

    public RuntimeExec(MVFilmSize mVFilmSize, Start start, String strProgCall, String strProgCallArray) {
        this.mVFilmSize = mVFilmSize;
        this.start = start;
        this.strProgCall = strProgCall;
        this.arrProgCallArray = strProgCallArray.split(TRENNER_PROG_ARRAY);
        this.strProgCallArray = strProgCallArray;
        if (this.arrProgCallArray.length <= 1) {
            this.arrProgCallArray = null;
        }
    }

    public RuntimeExec(String p) {
        this.strProgCall = p;
    }

    public Process exec(boolean log) {
        try {
            if (this.arrProgCallArray != null) {
                if (log) {
                    logger.info("=====================");
                    logger.info("Starte Array: ");
                    logger.info(" -> " + this.strProgCallArray);
                    logger.info("=====================");
                }
                this.process = Runtime.getRuntime().exec(this.arrProgCallArray);
            } else {
                if (log) {
                    logger.info("=====================");
                    logger.info("Starte nicht als Array:");
                    logger.info(" -> " + this.strProgCall);
                    logger.info("=====================");
                }
                this.process = Runtime.getRuntime().exec(this.strProgCall);
            }
            Thread clearIn = new Thread(new ClearInOut(IoType.INPUT, this.process));
            Thread clearOut = new Thread(new ClearInOut(IoType.ERROR, this.process));
            clearIn.setName("ClearIn: " + clearIn.getId());
            clearOut.setName("ClearOut: " + clearOut.getId());
            clearIn.start();
            clearOut.start();
        }
        catch (Exception ex) {
            logger.error("Fehler beim Starten", (Throwable)ex);
        }
        return this.process;
    }

    private class ClearInOut
    implements Runnable {
        private final IoType art;
        private final Process process;
        private int percent;
        private int percent_start = -1;

        public ClearInOut(IoType art, Process process) {
            this.art = art;
            this.process = process;
        }

        @Override
        public void run() {
            String titel;
            InputStream in;
            if (this.art == IoType.INPUT) {
                in = this.process.getInputStream();
                titel = "INPUTSTREAM";
            } else {
                in = this.process.getErrorStream();
                titel = String.format("ERRORSTREAM [%d]", processNr.incrementAndGet());
            }
            try (InputStream inputStream2 = in;
                 InputStreamReader isr = new InputStreamReader(in);
                 BufferedReader buff = new BufferedReader(isr);){
                String inStr;
                while ((inStr = buff.readLine()) != null) {
                    this.GetPercentageFromErrorStream(inStr);
                    if (!Config.isEnhancedLoggingEnabled()) continue;
                    logger.trace("  >> {}}: {}}", (Object)titel, (Object)inStr);
                }
            }
            catch (IOException ex) {
                logger.error("ClearInOut.run() error occured", (Throwable)ex);
            }
        }

        private void GetPercentageFromErrorStream(String input) {
            try {
                String s2;
                String[] hms;
                Matcher matcher = CACHE.get(RuntimeExec.PATTERN_FFMPEG).matcher(input);
                if (matcher.find()) {
                    String dauer = matcher.group().trim();
                    hms = dauer.split(":");
                    RuntimeExec.this.totalSecs = (double)(Integer.parseInt(hms[0]) * 3600 + Integer.parseInt(hms[1]) * 60) + Double.parseDouble(hms[2]);
                }
                if ((matcher = CACHE.get(RuntimeExec.PATTERN_SIZE).matcher(input)).find() && !(s2 = matcher.group().trim()).isEmpty()) {
                    try {
                        long aktSize = Integer.parseInt(StringUtils.replace(s2, "kB", ""));
                        RuntimeExec.this.mVFilmSize.setAktSize(aktSize * 1000L);
                        long akt = RuntimeExec.this.start.startZeit.diffInSekunden();
                        if (RuntimeExec.this.oldSecs < akt - 5L) {
                            RuntimeExec.this.start.bandbreite = (aktSize - RuntimeExec.this.oldSize) * 1000L / (akt - RuntimeExec.this.oldSecs);
                            RuntimeExec.this.oldSecs = akt;
                            RuntimeExec.this.oldSize = aktSize;
                        }
                    }
                    catch (NumberFormatException aktSize) {
                        // empty catch block
                    }
                }
                matcher = CACHE.get(RuntimeExec.PATTERN_TIME).matcher(input);
                if (RuntimeExec.this.totalSecs > 0.0 && matcher.find()) {
                    String zeit = matcher.group();
                    if (zeit.contains(":")) {
                        hms = zeit.split(":");
                        double aktSecs = (double)(Integer.parseInt(hms[0]) * 3600 + Integer.parseInt(hms[1]) * 60) + Double.parseDouble(hms[2]);
                        double d = aktSecs / RuntimeExec.this.totalSecs * 100.0;
                        this.meldenDouble(d);
                    } else {
                        double aktSecs = Double.parseDouble(zeit);
                        double d = aktSecs / RuntimeExec.this.totalSecs * 100.0;
                        this.meldenDouble(d);
                    }
                }
            }
            catch (Exception ex) {
                MessageBus.getMessageBus().publishAsync(new DownloadProgressChangedEvent());
                logger.error("GetPercentageFromErrorStream(): {}", (Object)input);
            }
        }

        private void meldenDouble(double d) {
            int pNeu;
            RuntimeExec.this.start.percent = pNeu = (int)(d *= 10.0);
            if (pNeu != this.percent) {
                this.percent = pNeu;
                if (this.percent_start == -1) {
                    this.percent_start = this.percent;
                }
                if (this.percent > this.percent_start + 5) {
                    long diffZeit = RuntimeExec.this.start.startZeit.diffInSekunden();
                    int diffProzent = this.percent - this.percent_start;
                    int restProzent = 1000 - this.percent;
                    RuntimeExec.this.start.restSekunden = diffZeit * (long)restProzent / (long)diffProzent;
                }
                MessageBus.getMessageBus().publishAsync(new DownloadProgressChangedEvent());
            }
        }
    }

    private static enum IoType {
        INPUT,
        ERROR;

    }

    static class PatternCacheLoader
    extends CacheLoader<String, Pattern> {
        PatternCacheLoader() {
        }

        @Override
        public Pattern load(@NotNull String pattern) throws IllegalArgumentException {
            logger.trace("COMPILING RuntimeExec PATTERN: " + pattern);
            return Pattern.compile(pattern);
        }
    }
}

