/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.bandwidth;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.TileBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.paint.Stop;
import javafx.util.Duration;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.daten.DatenDownload;
import mediathek.daten.ListeDownloads;
import mediathek.gui.messages.BandwidthMonitorStateChangedEvent;
import mediathek.javafx.tool.JavaFxUtils;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MessageBus;
import net.engio.mbassy.listener.Handler;

public class BandwidthMonitorController {
    private static final int DEFAULT_WIDTH = 300;
    private static final int DEFAULT_HEIGHT = 150;
    private final ListeDownloads listeDownloads = Daten.getInstance().getListeDownloads();
    private JDialog hudDialog;
    private Timeline updateMemoryTimer;
    private Tile bandwidthTile;
    private JFXPanel fxPanel;

    public BandwidthMonitorController(JFrame parent) {
        this.createDialog(parent);
        JavaFxUtils.invokeInFxThreadAndWait(() -> {
            this.fxPanel.setScene(new Scene(this.createTile()));
            this.createUpdateTimer();
        });
        if (!GuiFunktionen.setSize(MVConfig.Configs.SYSTEM_GROESSE_INFODIALOG, this.hudDialog, null)) {
            this.hudDialog.setSize(300, 150);
            this.calculateHudPosition();
        }
        MessageBus.getMessageBus().subscribe(this);
        this.setVisibility();
    }

    public void close() {
        JavaFxUtils.invokeInFxThreadAndWait(() -> {
            if (this.updateMemoryTimer != null) {
                this.updateMemoryTimer.stop();
            }
        });
        this.hudDialog.dispose();
    }

    @Handler
    private void handleBandwidthMonitorStateChangedEvent(BandwidthMonitorStateChangedEvent e) {
        SwingUtilities.invokeLater(this::setVisibility);
    }

    private void createDialog(JFrame parent) {
        this.hudDialog = new JDialog(parent);
        this.hudDialog.setTitle("Bandbreite");
        this.hudDialog.setResizable(true);
        this.hudDialog.setType(Window.Type.UTILITY);
        this.hudDialog.setDefaultCloseOperation(1);
        this.hudDialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                Platform.runLater(() -> BandwidthMonitorController.this.updateMemoryTimer.play());
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                Platform.runLater(() -> BandwidthMonitorController.this.updateMemoryTimer.stop());
                BandwidthMonitorController.this.updateListeners();
            }
        });
        this.hudDialog.setLayout(new BorderLayout(0, 0));
        this.fxPanel = new JFXPanel();
        this.hudDialog.getContentPane().add((Component)this.fxPanel, "Center");
    }

    private void calculateHudPosition() {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode dm = gd.getDisplayMode();
        this.hudDialog.setLocation(dm.getWidth() - 300, 0);
    }

    private double calculateBandwidthUsage() {
        double bandwidth = 0.0;
        List<DatenDownload> activeDownloadList = this.listeDownloads.getListOfStartsNotFinished(-1);
        for (DatenDownload download : activeDownloadList) {
            if (download.start == null || download.start.status != 2) continue;
            bandwidth += (double)download.start.bandbreite;
        }
        activeDownloadList.clear();
        bandwidth = bandwidth * 8.0 / 1000.0 / 1000.0;
        if (bandwidth < 0.0) {
            bandwidth = 0.0;
        }
        return bandwidth;
    }

    private void createUpdateTimer() {
        this.updateMemoryTimer = new Timeline(new KeyFrame(Duration.seconds(1.0), event -> this.bandwidthTile.setValue(this.calculateBandwidthUsage()), new KeyValue[0]));
        this.updateMemoryTimer.setCycleCount(-1);
    }

    private Tile createTile() {
        this.bandwidthTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.SPARK_LINE)).prefSize(400.0, 400.0)).unit("MBit/s")).minValue(0.0)).maxValue(2048.0)).decimals(0)).tickLabelDecimals(0)).time(ZonedDateTime.now(ZoneId.of("Europe/Berlin")))).gradientStops(new Stop(0.0, Color.web("#1CAF4D")), new Stop(0.0075, Color.web("#1CAF4D")), new Stop(0.00751, Color.web("#91CA40")), new Stop(0.01166, Color.web("#91CA40")), new Stop(0.01167, Color.web("#F8C610")), new Stop(0.01666, Color.web("#F8C610")), new Stop(0.01667, Color.web("#F29222")), new Stop(0.025, Color.web("#F29222")), new Stop(0.02501, Color.web("#EC1D24")), new Stop(1.0, Color.web("#EC1D24")))).strokeWithGradient(true)).averagingPeriod(96)).averageVisible(true)).averagingEnabled(true)).smoothing(true)).build();
        this.bandwidthTile.setValue(0.0);
        return this.bandwidthTile;
    }

    private void updateListeners() {
        ApplicationConfiguration.getConfiguration().setProperty("application.ui.bandwidth_monitor.visible", false);
        MessageBus.getMessageBus().publishAsync(new BandwidthMonitorStateChangedEvent());
    }

    public void setVisibility() {
        boolean vis = ApplicationConfiguration.getConfiguration().getBoolean("application.ui.bandwidth_monitor.visible", false);
        this.hudDialog.setVisible(vis);
    }

    public void writeConfig() {
        GuiFunktionen.getSize(MVConfig.Configs.SYSTEM_GROESSE_INFODIALOG, this.hudDialog);
    }
}

