/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import mediathek.tool.InputStreamProgressMonitor;

public class ProgressMonitorInputStream
extends FilterInputStream {
    private final InputStreamProgressMonitor monitor;
    private final long size;
    private long bytesRead;

    public ProgressMonitorInputStream(InputStream in, long maxSize, InputStreamProgressMonitor mon) throws IOException {
        super(in);
        this.monitor = mon;
        this.size = maxSize;
        if (this.size == 0L) {
            throw new IOException("Size must be greater than zero!");
        }
    }

    @Override
    public int read() throws IOException {
        int read = super.read();
        if (read != -1) {
            ++this.bytesRead;
            if (this.monitor != null) {
                this.monitor.progress(this.bytesRead, this.size);
            }
        }
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = super.read(b);
        if (read != -1) {
            this.bytesRead += (long)read;
            if (this.monitor != null) {
                this.monitor.progress(this.bytesRead, this.size);
            }
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        if (read != -1) {
            this.bytesRead += (long)read;
            if (this.monitor != null) {
                this.monitor.progress(this.bytesRead, this.size);
            }
        }
        return read;
    }
}

