/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;

public final class SingleInstance {
    private FileChannel channel;
    private FileLock lock;

    public boolean isAppAlreadyActive() {
        try {
            File file = new File(System.getProperty("java.io.tmpdir"), "MediathekView.lock");
            this.channel = new RandomAccessFile(file, "rw").getChannel();
            this.lock = this.channel.tryLock();
            if (this.lock == null) {
                this.closeLock();
                return true;
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                this.closeLock();
                try {
                    Files.deleteIfExists(file.toPath());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }));
            return false;
        }
        catch (Exception e) {
            this.closeLock();
            return true;
        }
    }

    private void closeLock() {
        try {
            this.lock.release();
            this.channel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

