/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import org.h2.util.DateTimeUtils;
import org.h2.util.JSR310;
import org.h2.util.JSR310Utils;

public abstract class TimeZoneProvider {
    public static final TimeZoneProvider UTC = new Simple(0);
    public static TimeZoneProvider[] CACHE;
    private static final int CACHE_SIZE = 32;

    public static TimeZoneProvider ofOffset(int n) {
        if (n == 0) {
            return UTC;
        }
        return new Simple(n);
    }

    public static TimeZoneProvider ofId(String string) throws IllegalArgumentException {
        TimeZoneProvider timeZoneProvider;
        int n;
        int n2;
        int n3;
        block18: {
            char c;
            block20: {
                block19: {
                    n3 = string.length();
                    if (n3 == 1 && string.charAt(0) == 'Z') {
                        return UTC;
                    }
                    n2 = 0;
                    if (string.startsWith("GMT") || string.startsWith("UTC")) {
                        if (n3 == 3) {
                            return UTC;
                        }
                        n2 += 3;
                    }
                    if (n3 - n2 < 2) break block18;
                    n = 0;
                    c = string.charAt(n2);
                    if (c != '+') break block19;
                    c = string.charAt(++n2);
                    break block20;
                }
                if (c != '-') break block18;
                n = 1;
                c = string.charAt(++n2);
            }
            if (c >= '0' && c <= '9') {
                int n4 = c - 48;
                if (++n2 < n3 && (c = string.charAt(n2)) >= '0' && c <= '9') {
                    n4 = n4 * 10 + c - 48;
                    ++n2;
                }
                if (n2 == n3) {
                    int n5 = n4 * 3600;
                    return TimeZoneProvider.ofOffset(n != 0 ? -n5 : n5);
                }
                if (string.charAt(n2) == ':' && ++n2 < n3 && (c = string.charAt(n2)) >= '0' && c <= '9') {
                    int n6 = c - 48;
                    if (++n2 < n3 && (c = string.charAt(n2)) >= '0' && c <= '9') {
                        n6 = n6 * 10 + c - 48;
                        ++n2;
                    }
                    if (n2 == n3) {
                        int n7 = (n4 * 60 + n6) * 60;
                        return TimeZoneProvider.ofOffset(n != 0 ? -n7 : n7);
                    }
                    if (string.charAt(n2) == ':' && ++n2 < n3 && (c = string.charAt(n2)) >= '0' && c <= '9') {
                        int n8 = c - 48;
                        if (++n2 < n3 && (c = string.charAt(n2)) >= '0' && c <= '9') {
                            n8 = n8 * 10 + c - 48;
                            ++n2;
                        }
                        if (n2 == n3) {
                            int n9 = (n4 * 60 + n6) * 60 + n8;
                            return TimeZoneProvider.ofOffset(n != 0 ? -n9 : n9);
                        }
                    }
                }
            }
            if (n2 > 0) {
                throw new IllegalArgumentException(string);
            }
        }
        n = string.hashCode() & 0x1F;
        TimeZoneProvider[] timeZoneProviderArray = CACHE;
        if (timeZoneProviderArray != null && (timeZoneProvider = timeZoneProviderArray[n]) != null && timeZoneProvider.getId().equals(string)) {
            return timeZoneProvider;
        }
        TimeZoneProvider timeZoneProvider2 = TimeZoneProvider.ofId(string, n2, n3);
        if (timeZoneProviderArray == null) {
            CACHE = timeZoneProviderArray = new TimeZoneProvider[32];
        }
        timeZoneProviderArray[n] = timeZoneProvider2;
        return timeZoneProvider2;
    }

    private static TimeZoneProvider ofId(String string, int n, int n2) {
        if (JSR310.PRESENT) {
            return JSR310Utils.getTimeZoneProvider(string);
        }
        TimeZone timeZone = TimeZone.getTimeZone(string);
        if (!timeZone.getID().startsWith(string)) {
            throw new IllegalArgumentException(string + " (" + timeZone.getID() + "?)");
        }
        return new WithTimeZone7(TimeZone.getTimeZone(string));
    }

    public static TimeZoneProvider getDefault() {
        if (JSR310.PRESENT) {
            return JSR310Utils.getDefaultTimeZoneProvider();
        }
        return new WithTimeZone7(TimeZone.getDefault());
    }

    public abstract int getTimeZoneOffsetUTC(long var1);

    public abstract int getTimeZoneOffsetLocal(long var1, long var3);

    public abstract long getEpochSecondsFromLocal(long var1, long var3);

    public abstract String getId();

    public abstract String getShortId(long var1);

    public boolean hasFixedOffset() {
        return false;
    }

    private static final class WithTimeZone7
    extends WithTimeZone {
        private static final long EPOCH_SECONDS_HIGH = 9214629984000000L;
        private static final long EPOCH_SECONDS_LOW = -37868342400L;
        private final AtomicReference<GregorianCalendar> cachedCalendar = new AtomicReference();
        private final TimeZone timeZone;

        WithTimeZone7(TimeZone timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public int getTimeZoneOffsetUTC(long l) {
            return this.timeZone.getOffset(WithTimeZone7.epochSecondsForCalendar(l) * 1000L) / 1000;
        }

        @Override
        int getTimeZoneOffsetLocal(int n, int n2, int n3, int n4, int n5, int n6) {
            n = WithTimeZone7.yearForCalendar(n);
            GregorianCalendar gregorianCalendar = this.cachedCalendar.getAndSet(null);
            if (gregorianCalendar == null) {
                gregorianCalendar = this.createCalendar();
            }
            gregorianCalendar.clear();
            gregorianCalendar.set(0, 1);
            gregorianCalendar.set(1, n);
            gregorianCalendar.set(2, n2 - 1);
            gregorianCalendar.set(5, n3);
            gregorianCalendar.set(11, n4);
            gregorianCalendar.set(12, n5);
            gregorianCalendar.set(13, n6);
            gregorianCalendar.set(14, 0);
            int n7 = gregorianCalendar.get(15) + gregorianCalendar.get(16);
            this.cachedCalendar.compareAndSet(null, gregorianCalendar);
            return n7 / 1000;
        }

        @Override
        long getEpochSecondsFromLocal(int n, int n2, int n3, int n4, int n5, int n6) {
            int n7 = WithTimeZone7.yearForCalendar(n);
            GregorianCalendar gregorianCalendar = this.cachedCalendar.getAndSet(null);
            if (gregorianCalendar == null) {
                gregorianCalendar = this.createCalendar();
            }
            gregorianCalendar.clear();
            gregorianCalendar.set(0, 1);
            gregorianCalendar.set(1, n7);
            gregorianCalendar.set(2, n2 - 1);
            gregorianCalendar.set(5, n3);
            gregorianCalendar.set(11, n4);
            gregorianCalendar.set(12, n5);
            gregorianCalendar.set(13, n6);
            gregorianCalendar.set(14, 0);
            long l = gregorianCalendar.getTimeInMillis();
            this.cachedCalendar.compareAndSet(null, gregorianCalendar);
            return l / 1000L + (long)(n - n7) * 31556952L;
        }

        private GregorianCalendar createCalendar() {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.timeZone);
            gregorianCalendar.setGregorianChange(DateTimeUtils.PROLEPTIC_GREGORIAN_CHANGE);
            return gregorianCalendar;
        }

        @Override
        public String getId() {
            return this.timeZone.getID();
        }

        @Override
        public String getShortId(long l) {
            return this.timeZone.getDisplayName(this.timeZone.inDaylightTime(new Date(WithTimeZone7.epochSecondsForCalendar(l) * 1000L)), 0);
        }

        private static int yearForCalendar(int n) {
            if (n > 292000000) {
                n = n % 400 + 292000000;
            } else if (n <= 0) {
                n = n % 400 + 400;
            }
            return n;
        }

        private static long epochSecondsForCalendar(long l) {
            if (l > 9214629984000000L) {
                l = l % 12622780800L + 9214629984000000L;
            } else if (l < -37868342400L) {
                l = l % 12622780800L + -37868342400L;
            }
            return l;
        }

        public String toString() {
            return "TimeZoneProvider " + this.timeZone.getID();
        }
    }

    static abstract class WithTimeZone
    extends TimeZoneProvider {
        static final long SECONDS_PER_PERIOD = 12622780800L;
        static final long SECONDS_PER_YEAR = 31556952L;

        WithTimeZone() {
        }

        @Override
        public final int getTimeZoneOffsetLocal(long l, long l2) {
            int n = (int)(l2 / 1000000000L);
            int n2 = n / 60;
            n -= n2 * 60;
            int n3 = n2 / 60;
            int n4 = DateTimeUtils.yearFromDateValue(l);
            int n5 = DateTimeUtils.monthFromDateValue(l);
            int n6 = DateTimeUtils.dayFromDateValue(l);
            return this.getTimeZoneOffsetLocal(n4, n5, n6, n3, n2 -= n3 * 60, n);
        }

        abstract int getTimeZoneOffsetLocal(int var1, int var2, int var3, int var4, int var5, int var6);

        @Override
        public final long getEpochSecondsFromLocal(long l, long l2) {
            int n = DateTimeUtils.yearFromDateValue(l);
            int n2 = DateTimeUtils.monthFromDateValue(l);
            int n3 = DateTimeUtils.dayFromDateValue(l);
            int n4 = (int)(l2 / 1000000000L);
            int n5 = n4 / 60;
            n4 -= n5 * 60;
            int n6 = n5 / 60;
            return this.getEpochSecondsFromLocal(n, n2, n3, n6, n5 -= n6 * 60, n4);
        }

        abstract long getEpochSecondsFromLocal(int var1, int var2, int var3, int var4, int var5, int var6);
    }

    private static final class Simple
    extends TimeZoneProvider {
        private final int offset;
        private volatile String id;

        Simple(int n) {
            this.offset = n;
        }

        @Override
        public int getTimeZoneOffsetUTC(long l) {
            return this.offset;
        }

        @Override
        public int getTimeZoneOffsetLocal(long l, long l2) {
            return this.offset;
        }

        @Override
        public long getEpochSecondsFromLocal(long l, long l2) {
            return DateTimeUtils.getEpochSeconds(l, l2, this.offset);
        }

        @Override
        public String getId() {
            String string = this.id;
            if (string == null) {
                this.id = DateTimeUtils.timeZoneNameFromOffsetSeconds(this.offset);
            }
            return string;
        }

        @Override
        public String getShortId(long l) {
            return this.getId();
        }

        @Override
        public boolean hasFixedOffset() {
            return true;
        }

        public String toString() {
            return "TimeZoneProvider " + this.getId();
        }
    }
}

