/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.CornerParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.SvgCharSizeHack;
import net.sourceforge.plantuml.anim.Animation;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.svg.LengthAdjust;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class ImageParameter {
    private final ColorMapper colorMapper;
    private final boolean useHandwritten;
    private final Animation animation;
    private final double dpiFactor;
    private final String metadata;
    private final String warningOrError;
    private final ClockwiseTopRightBottomLeft margins;
    private final HColor backcolor;
    private final boolean svgDimensionStyle;
    private final SvgCharSizeHack svgCharSizeHack;
    private final LengthAdjust lengthAdjust;
    private final UStroke borderStroke;
    private final HColor borderColor;
    private final double borderCorner;

    public ImageParameter(ColorMapper colorMapper, boolean useHandwritten, Animation animation, double dpiFactor, String metadata, String warningOrError, ClockwiseTopRightBottomLeft margins, HColor backcolor) {
        this.colorMapper = colorMapper;
        this.useHandwritten = useHandwritten;
        this.animation = animation;
        this.dpiFactor = dpiFactor;
        this.metadata = metadata;
        this.warningOrError = warningOrError;
        this.margins = margins;
        this.backcolor = backcolor;
        this.svgDimensionStyle = true;
        this.borderColor = null;
        this.borderCorner = 0.0;
        this.borderStroke = null;
        this.svgCharSizeHack = SvgCharSizeHack.NO_HACK;
        this.lengthAdjust = LengthAdjust.defaultValue();
    }

    public ImageParameter(ISkinParam skinParam, Animation animation, double dpiFactor, String metadata, String warningOrError, ClockwiseTopRightBottomLeft margins, HColor backcolor) {
        this.colorMapper = skinParam.getColorMapper();
        this.useHandwritten = skinParam.handwritten();
        this.animation = animation;
        this.dpiFactor = dpiFactor;
        this.metadata = metadata;
        this.warningOrError = warningOrError;
        this.margins = margins;
        this.backcolor = backcolor;
        this.svgDimensionStyle = skinParam.svgDimensionStyle();
        Rose rose = new Rose();
        this.borderColor = rose.getHtmlColor(skinParam, ColorParam.diagramBorder);
        this.borderCorner = skinParam.getRoundCorner(CornerParam.diagramBorder, null);
        UStroke thickness = skinParam.getThickness(LineParam.diagramBorder, null);
        this.borderStroke = thickness == null && this.borderColor != null ? new UStroke() : thickness;
        this.svgCharSizeHack = skinParam;
        this.lengthAdjust = skinParam.getlengthAdjust();
    }

    public final ColorMapper getColorMapper() {
        return this.colorMapper;
    }

    public final boolean isUseHandwritten() {
        return this.useHandwritten;
    }

    public final Animation getAnimation() {
        return this.animation;
    }

    public final double getDpiFactor() {
        return this.dpiFactor;
    }

    public final String getMetadata() {
        return this.metadata;
    }

    public final String getWarningOrError() {
        return this.warningOrError;
    }

    public final ClockwiseTopRightBottomLeft getMargins() {
        return this.margins;
    }

    public final HColor getBackcolor() {
        return this.backcolor;
    }

    public final boolean isSvgDimensionStyle() {
        return this.svgDimensionStyle;
    }

    public final UStroke getBorderStroke() {
        return this.borderStroke;
    }

    public final HColor getBorderColor() {
        return this.borderColor;
    }

    public final double getBorderCorner() {
        return this.borderCorner;
    }

    public final SvgCharSizeHack getSvgCharSizeHack() {
        return this.svgCharSizeHack;
    }

    public final LengthAdjust getlengthAdjust() {
        return this.lengthAdjust;
    }
}

