/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.protege.editor.owl.ui.editor.OWLObjectPropertySetEditor;
import org.protege.editor.owl.ui.selector.OWLObjectPropertySelectorPanel;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;

public class OWLObjectPropertyTabbedSetEditor
extends AbstractOWLObjectEditor<Set<OWLObjectPropertyExpression>>
implements VerifiedInputEditor {
    public static final String DESCRIPTION_EDITOR_TITLE = "Property Expression Editor";
    public static final String HIERARCHY_EDITOR_TITLE = "Property Hierarchy";
    private JTabbedPane tabbedPane;
    private OWLObjectPropertySetEditor descriptionEditor;
    private OWLObjectPropertySelectorPanel propertySelectorPanel;
    private Set<InputVerificationStatusChangedListener> listeners = new HashSet<InputVerificationStatusChangedListener>();
    private InputVerificationStatusChangedListener inputListener = newState -> this.handleVerifyEditorContents();

    public OWLObjectPropertyTabbedSetEditor(OWLEditorKit owlEditorKit) {
        this.tabbedPane = new JTabbedPane();
        this.propertySelectorPanel = new OWLObjectPropertySelectorPanel(owlEditorKit);
        this.propertySelectorPanel.addStatusChangedListener(this.inputListener);
        this.descriptionEditor = new OWLObjectPropertySetEditor(owlEditorKit);
        this.descriptionEditor.addStatusChangedListener(this.inputListener);
        this.tabbedPane.addTab(HIERARCHY_EDITOR_TITLE, this.propertySelectorPanel);
        this.tabbedPane.addTab(DESCRIPTION_EDITOR_TITLE, this.descriptionEditor.getEditorComponent());
    }

    @Override
    @Nullable
    public Set<OWLObjectPropertyExpression> getEditedObject() {
        if (this.tabbedPane.getSelectedComponent() == this.propertySelectorPanel) {
            return this.propertySelectorPanel.getSelectedObjects();
        }
        return this.descriptionEditor.getEditedObject();
    }

    @Override
    public boolean setEditedObject(Set<OWLObjectPropertyExpression> properties) {
        if (properties == null) {
            properties = Collections.emptySet();
        }
        if (this.canConvertToObjectPropertyList(properties)) {
            this.propertySelectorPanel.setSelection(this.convertToObjectPropertyList(properties));
        }
        this.descriptionEditor.setEditedObject(properties);
        return true;
    }

    private boolean canConvertToObjectPropertyList(Set<OWLObjectPropertyExpression> properties) {
        for (OWLObjectPropertyExpression property : properties) {
            if (!property.isAnonymous()) continue;
            return false;
        }
        return true;
    }

    private Set<OWLObjectProperty> convertToObjectPropertyList(Set<OWLObjectPropertyExpression> properties) {
        return properties;
    }

    @Override
    @Nonnull
    public String getEditorTypeName() {
        return "Set of Object Properties";
    }

    @Override
    public boolean canEdit(Object object) {
        return this.checkSet(object, OWLObjectProperty.class);
    }

    @Override
    @Nonnull
    public JComponent getEditorComponent() {
        return this.tabbedPane;
    }

    private void handleVerifyEditorContents() {
        if (this.tabbedPane.getSelectedComponent() == this.propertySelectorPanel) {
            for (InputVerificationStatusChangedListener l : this.listeners) {
                l.verifiedStatusChanged(true);
            }
        }
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener l) {
        this.listeners.add(l);
        this.descriptionEditor.addStatusChangedListener(l);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener l) {
        this.listeners.remove(l);
        this.descriptionEditor.removeStatusChangedListener(l);
    }

    @Override
    public void dispose() {
        this.propertySelectorPanel.dispose();
        this.descriptionEditor.dispose();
    }
}

