/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.forkjoin;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import scala.concurrent.forkjoin.ForkJoinPool;
import scala.concurrent.forkjoin.ForkJoinPool$WorkQueue;
import scala.concurrent.forkjoin.ForkJoinTask$ExceptionNode;
import scala.concurrent.forkjoin.ForkJoinWorkerThread;
import sun.misc.Unsafe;

public abstract class ForkJoinTask
implements Serializable,
Future {
    volatile int status;
    private static final ForkJoinTask$ExceptionNode[] exceptionTable;
    private static final ReentrantLock exceptionTableLock;
    private static final ReferenceQueue exceptionTableRefQueue;
    private static final Unsafe U;
    private static final long STATUS;

    private int setCompletion(int n) {
        int n2;
        do {
            if ((n2 = this.status) >= 0) continue;
            return n2;
        } while (!U.compareAndSwapInt(this, STATUS, n2, n2 | n));
        if (n2 >>> 16 != 0) {
            ForkJoinTask forkJoinTask = this;
            synchronized (forkJoinTask) {
                this.notifyAll();
            }
        }
        return n;
    }

    final int doExec() {
        int n = this.status;
        if (n >= 0) {
            try {
                this.exec();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                return this.recordExceptionalCompletion(throwable2);
            }
            n = this.setCompletion(-268435456);
        }
        return n;
    }

    final boolean trySetSignal() {
        int n = this.status;
        return n >= 0 && U.compareAndSwapInt(this, STATUS, n, n | 0x10000);
    }

    private int externalAwaitDone() {
        int n;
        ForkJoinPool.externalHelpJoin(this);
        boolean bl = false;
        while ((n = this.status) >= 0) {
            if (!U.compareAndSwapInt(this, STATUS, n, n | 0x10000)) continue;
            ForkJoinTask forkJoinTask = this;
            synchronized (forkJoinTask) {
                if (this.status >= 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                    }
                } else {
                    this.notifyAll();
                }
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        return n;
    }

    private int externalInterruptibleAwaitDone() {
        int n;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        ForkJoinPool.externalHelpJoin(this);
        while ((n = this.status) >= 0) {
            if (!U.compareAndSwapInt(this, STATUS, n, n | 0x10000)) continue;
            ForkJoinTask forkJoinTask = this;
            synchronized (forkJoinTask) {
                if (this.status >= 0) {
                    this.wait();
                } else {
                    this.notifyAll();
                }
            }
        }
        return n;
    }

    private int doJoin() {
        int n = this.status;
        if (n < 0) {
            return n;
        }
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
            ForkJoinPool$WorkQueue forkJoinPool$WorkQueue = forkJoinWorkerThread.workQueue;
            if (forkJoinPool$WorkQueue.tryUnpush(this) && (n = this.doExec()) < 0) {
                return n;
            }
            return forkJoinWorkerThread.pool.awaitJoin(forkJoinPool$WorkQueue, this);
        }
        return this.externalAwaitDone();
    }

    private int recordExceptionalCompletion(Throwable throwable) {
        int n = this.status;
        if (n >= 0) {
            int n2 = System.identityHashCode(this);
            ReentrantLock reentrantLock = exceptionTableLock;
            reentrantLock.lock();
            try {
                ForkJoinTask.expungeStaleExceptions();
                ForkJoinTask$ExceptionNode[] forkJoinTask$ExceptionNodeArray = exceptionTable;
                int n3 = n2 & forkJoinTask$ExceptionNodeArray.length - 1;
                ForkJoinTask$ExceptionNode forkJoinTask$ExceptionNode = forkJoinTask$ExceptionNodeArray[n3];
                while (true) {
                    if (forkJoinTask$ExceptionNode == null) {
                        forkJoinTask$ExceptionNodeArray[n3] = new ForkJoinTask$ExceptionNode(this, throwable, forkJoinTask$ExceptionNodeArray[n3]);
                    } else if (forkJoinTask$ExceptionNode.get() != this) {
                        forkJoinTask$ExceptionNode = forkJoinTask$ExceptionNode.next;
                        continue;
                    }
                    break;
                }
            }
            finally {
                reentrantLock.unlock();
            }
            n = this.setCompletion(Integer.MIN_VALUE);
        }
        return n;
    }

    static final void cancelIgnoringExceptions(ForkJoinTask forkJoinTask) {
        if (forkJoinTask != null && forkJoinTask.status >= 0) {
            try {
                forkJoinTask.cancel(false);
                return;
            }
            catch (Throwable throwable) {}
        }
    }

    private Throwable getThrowableException() {
        ForkJoinTask$ExceptionNode forkJoinTask$ExceptionNode;
        Object object;
        if ((this.status & 0xF0000000) != Integer.MIN_VALUE) {
            return null;
        }
        int n = System.identityHashCode(this);
        ReentrantLock reentrantLock = exceptionTableLock;
        reentrantLock.lock();
        try {
            ForkJoinTask.expungeStaleExceptions();
            object = exceptionTable;
            forkJoinTask$ExceptionNode = exceptionTable[n & ((ForkJoinTask$ExceptionNode[])object).length - 1];
            while (forkJoinTask$ExceptionNode != null && forkJoinTask$ExceptionNode.get() != this) {
                forkJoinTask$ExceptionNode = forkJoinTask$ExceptionNode.next;
            }
        }
        finally {
            reentrantLock.unlock();
        }
        if (forkJoinTask$ExceptionNode == null || (object = forkJoinTask$ExceptionNode.ex) == null) {
            return null;
        }
        return object;
    }

    private static void expungeStaleExceptions() {
        Reference reference;
        block0: while ((reference = exceptionTableRefQueue.poll()) != null) {
            if (!(reference instanceof ForkJoinTask$ExceptionNode)) continue;
            ForkJoinTask forkJoinTask = (ForkJoinTask)((ForkJoinTask$ExceptionNode)reference).get();
            ForkJoinTask$ExceptionNode[] forkJoinTask$ExceptionNodeArray = exceptionTable;
            int n = System.identityHashCode(forkJoinTask) & forkJoinTask$ExceptionNodeArray.length - 1;
            ForkJoinTask$ExceptionNode forkJoinTask$ExceptionNode = forkJoinTask$ExceptionNodeArray[n];
            ForkJoinTask$ExceptionNode forkJoinTask$ExceptionNode2 = null;
            while (forkJoinTask$ExceptionNode != null) {
                ForkJoinTask$ExceptionNode forkJoinTask$ExceptionNode3 = forkJoinTask$ExceptionNode.next;
                if (forkJoinTask$ExceptionNode == reference) {
                    if (forkJoinTask$ExceptionNode2 == null) {
                        forkJoinTask$ExceptionNodeArray[n] = forkJoinTask$ExceptionNode3;
                        continue block0;
                    }
                    forkJoinTask$ExceptionNode2.next = forkJoinTask$ExceptionNode3;
                    continue block0;
                }
                forkJoinTask$ExceptionNode2 = forkJoinTask$ExceptionNode;
                forkJoinTask$ExceptionNode = forkJoinTask$ExceptionNode3;
            }
        }
    }

    static final void helpExpungeStaleExceptions() {
        ReentrantLock reentrantLock = exceptionTableLock;
        if (reentrantLock.tryLock()) {
            try {
                ForkJoinTask.expungeStaleExceptions();
                return;
            }
            finally {
                reentrantLock.unlock();
            }
        }
    }

    static void rethrow(Throwable throwable) {
        if (throwable != null) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            Throwable throwable2 = throwable;
            if (throwable2 != null) {
                throw throwable2;
            }
        }
    }

    public final ForkJoinTask fork() {
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            ((ForkJoinWorkerThread)thread).workQueue.push(this);
        } else {
            ForkJoinPool.common.externalPush(this);
        }
        return this;
    }

    public final Object invoke() {
        int n;
        ForkJoinTask forkJoinTask = this;
        int n2 = forkJoinTask.doExec();
        if (n2 < 0) {
            n = n2;
        } else {
            Thread thread = Thread.currentThread();
            if (thread instanceof ForkJoinWorkerThread) {
                ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
                n = forkJoinWorkerThread.pool.awaitJoin(forkJoinWorkerThread.workQueue, forkJoinTask);
            } else {
                n = forkJoinTask.externalAwaitDone();
            }
        }
        int n3 = n & 0xF0000000;
        if (n3 != -268435456) {
            n2 = n3;
            forkJoinTask = this;
            if (n2 == -1073741824) {
                throw new CancellationException();
            }
            if (n2 == Integer.MIN_VALUE) {
                ForkJoinTask.rethrow(forkJoinTask.getThrowableException());
            }
        }
        return this.getRawResult();
    }

    @Override
    public boolean cancel(boolean bl) {
        return (this.setCompletion(-1073741824) & 0xF0000000) == -1073741824;
    }

    @Override
    public final boolean isDone() {
        return this.status < 0;
    }

    @Override
    public final boolean isCancelled() {
        return (this.status & 0xF0000000) == -1073741824;
    }

    public final Object get() {
        Throwable throwable;
        int n = (Thread.currentThread() instanceof ForkJoinWorkerThread ? this.doJoin() : this.externalInterruptibleAwaitDone()) & 0xF0000000;
        if (n == -1073741824) {
            throw new CancellationException();
        }
        if (n == Integer.MIN_VALUE && (throwable = this.getThrowableException()) != null) {
            throw new ExecutionException(throwable);
        }
        return this.getRawResult();
    }

    public final Object get(long l, TimeUnit timeUnit) {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long l2 = timeUnit.toNanos(l);
        int n = this.status;
        if (n >= 0 && l2 > 0L) {
            long l3 = System.nanoTime() + l2;
            ForkJoinPool forkJoinPool = null;
            ForkJoinPool$WorkQueue forkJoinPool$WorkQueue = null;
            Thread thread = Thread.currentThread();
            if (thread instanceof ForkJoinWorkerThread) {
                ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
                forkJoinPool = forkJoinWorkerThread.pool;
                forkJoinPool$WorkQueue = forkJoinWorkerThread.workQueue;
                forkJoinPool.helpJoinOnce(forkJoinPool$WorkQueue, this);
            } else {
                ForkJoinPool.externalHelpJoin(this);
            }
            boolean bl = false;
            boolean bl2 = false;
            try {
                while ((n = this.status) >= 0) {
                    if (forkJoinPool$WorkQueue != null && forkJoinPool$WorkQueue.qlock < 0) {
                        ForkJoinTask.cancelIgnoringExceptions(this);
                        continue;
                    }
                    if (!bl) {
                        if (forkJoinPool != null && !forkJoinPool.tryCompensate()) continue;
                        bl = true;
                        continue;
                    }
                    long l4 = TimeUnit.NANOSECONDS.toMillis(l2);
                    if (l4 > 0L && U.compareAndSwapInt(this, STATUS, n, n | 0x10000)) {
                        ForkJoinTask forkJoinTask = this;
                        synchronized (forkJoinTask) {
                            if (this.status >= 0) {
                                try {
                                    this.wait(l4);
                                }
                                catch (InterruptedException interruptedException) {
                                    if (forkJoinPool == null) {
                                        bl2 = true;
                                    }
                                }
                            } else {
                                this.notifyAll();
                            }
                        }
                    }
                    if ((n = this.status) >= 0 && !bl2 && (l2 = l3 - System.nanoTime()) > 0L) continue;
                    break;
                }
            }
            finally {
                if (forkJoinPool != null && bl) {
                    forkJoinPool.incrementActiveCount();
                }
            }
            if (bl2) {
                throw new InterruptedException();
            }
        }
        if ((n &= 0xF0000000) != -268435456) {
            if (n == -1073741824) {
                throw new CancellationException();
            }
            if (n != Integer.MIN_VALUE) {
                throw new TimeoutException();
            }
            Throwable throwable = this.getThrowableException();
            if (throwable != null) {
                throw new ExecutionException(throwable);
            }
        }
        return this.getRawResult();
    }

    public final void quietlyJoin() {
        this.doJoin();
    }

    public abstract Object getRawResult();

    protected abstract boolean exec();

    static /* synthetic */ ReferenceQueue access$000() {
        return exceptionTableRefQueue;
    }

    static {
        exceptionTableLock = new ReentrantLock();
        exceptionTableRefQueue = new ReferenceQueue();
        exceptionTable = new ForkJoinTask$ExceptionNode[32];
        try {
            U = scala.concurrent.util.Unsafe.instance;
            Class<ForkJoinTask> clazz = ForkJoinTask.class;
            STATUS = U.objectFieldOffset(clazz.getDeclaredField("status"));
            return;
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

