/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.awt.Font;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.sf.sdedit.util.Utilities;

public final class ObjectFactory {
    private static final Map<Class<?>, Constructor<?>> stringConstructorMap = new HashMap();

    private ObjectFactory() {
    }

    public static <T> T castFromString(Class<T> cls, String string) {
        return cls.cast(ObjectFactory.createFromString(cls, string));
    }

    public static Object[] createArrayFromString(Class<?> cls, String string, String entrySeparator, String rangeSeparator) {
        String[] strings;
        ArrayList<Object> objects = new ArrayList<Object>();
        for (String _string : strings = string.split(entrySeparator)) {
            String[] _strings = _string.split(rangeSeparator);
            if (_strings.length == 1) {
                objects.add(ObjectFactory.createFromString(cls, _strings[0]));
                continue;
            }
            if (_strings.length == 2) {
                BigDecimal from = (BigDecimal)ObjectFactory.createFromString(BigDecimal.class, _strings[0]);
                BigDecimal to = (BigDecimal)ObjectFactory.createFromString(BigDecimal.class, _strings[1]);
                while (from.compareTo(to) <= 0) {
                    objects.add(ObjectFactory.createFromString(cls, from.toString()));
                    from = from.add(BigDecimal.ONE);
                }
                continue;
            }
            throw new IllegalArgumentException("illegal range in string: " + _string);
        }
        return objects.toArray(new Object[objects.size()]);
    }

    public static Object[] createArrayFromString(Class<?> cls, String string) {
        return ObjectFactory.createArrayFromString(cls, string, "\\+", "\\-");
    }

    public static Object createFromString(Class<?> cls, String string) {
        if (cls == String.class) {
            return string == null ? "" : string;
        }
        if (cls == Integer.TYPE && string.length() == 1) {
            return string.charAt(0) - 48;
        }
        if (cls == Font.class) {
            return Font.decode(string);
        }
        if (cls.isEnum()) {
            return Utilities.invoke("valueOf", cls, string);
        }
        Class<?> nonPrimitive = Utilities.getWrapperClass(cls);
        if (nonPrimitive != null) {
            cls = nonPrimitive;
        }
        if (cls == Integer.class && string != null && string.indexOf(46) >= 0) {
            return Math.round(Float.parseFloat(string));
        }
        if (cls == Long.class && string != null && string.indexOf(46) >= 0) {
            return Math.round(Double.parseDouble(string));
        }
        if ("".equals(string) && Number.class.isAssignableFrom(cls)) {
            return null;
        }
        try {
            if (string == null) {
                return cls.newInstance();
            }
            Constructor<?> constructor = stringConstructorMap.get(cls);
            if (constructor == null) {
                try {
                    constructor = cls.getConstructor(String.class);
                }
                catch (NoSuchMethodException e) {
                    constructor = cls.getConstructor(Integer.TYPE);
                }
                stringConstructorMap.put(cls, constructor);
            }
            if (constructor.getParameterTypes()[0] == Integer.TYPE) {
                return constructor.newInstance(Integer.parseInt(string));
            }
            return constructor.newInstance(string);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(cls.getName() + " has no constructor with a single string or integer as a parameter");
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(cls.getName() + " has no constructor with an empty parameter list");
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(cls.getName() + " has a constructor with a single string or integer as a parameter, but it cannot be invoked with the argument \"" + string + "\", which led to an exception/error of type " + e.getClass().getSimpleName() + " with the message: " + e.getMessage());
        }
    }

    public static void main(String[] argv) {
        Object[] array = ObjectFactory.createArrayFromString(Double.class, "1+2+3+4+10-20");
        System.out.println(Arrays.asList(array));
    }
}

