/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.gdi.GDIObject;

public abstract class AbstractPen
implements EMFConstants,
GDIObject {
    private static final Logger logger = Logger.getLogger("org.freehep.graphicsio.emf");

    protected int getJoin(int penStyle) {
        switch (penStyle & 0xF000) {
            case 0: {
                return 1;
            }
            case 4096: {
                return 2;
            }
            case 8192: {
                return 0;
            }
        }
        logger.warning("got unsupported pen style " + penStyle);
        return 1;
    }

    protected int getCap(int penStyle) {
        switch (penStyle & 0xF00) {
            case 0: {
                return 1;
            }
            case 256: {
                return 2;
            }
            case 512: {
                return 0;
            }
        }
        logger.warning("got unsupported pen style " + penStyle);
        return 1;
    }

    protected float[] getDash(int penStyle, int[] style) {
        switch (penStyle & 0xFF) {
            case 0: {
                return null;
            }
            case 1: {
                return new float[]{5.0f, 5.0f};
            }
            case 2: {
                return new float[]{1.0f, 2.0f};
            }
            case 3: {
                return new float[]{5.0f, 2.0f, 1.0f, 2.0f};
            }
            case 4: {
                return new float[]{5.0f, 2.0f, 1.0f, 2.0f, 1.0f, 2.0f};
            }
            case 6: {
                return null;
            }
            case 5: {
                return null;
            }
            case 7: {
                if (style != null && style.length > 0) {
                    float[] result = new float[style.length];
                    for (int i = 0; i < style.length; ++i) {
                        result[i] = style[i];
                    }
                    return result;
                }
                return null;
            }
        }
        logger.warning("got unsupported pen style " + penStyle);
        return null;
    }

    private boolean isInsideFrameStroke(int penStyle) {
        return (penStyle & 0xFF) == 6;
    }

    protected Stroke createStroke(EMFRenderer renderer, int penStyle, int[] style, float width) {
        if (this.isInsideFrameStroke(penStyle)) {
            return new InsideFrameStroke(width, this.getCap(penStyle), this.getJoin(penStyle), renderer.getMeterLimit(), this.getDash(penStyle, style), 0.0f);
        }
        return new BasicStroke(width, this.getCap(penStyle), this.getJoin(penStyle), renderer.getMeterLimit(), this.getDash(penStyle, style), 0.0f);
    }

    private class InsideFrameStroke
    implements Stroke {
        private BasicStroke stroke;

        public InsideFrameStroke(float width, int cap, int join, float miterlimit, float[] dash, float dash_phase) {
            this.stroke = new BasicStroke(width, cap, join, miterlimit, dash, dash_phase);
        }

        @Override
        public Shape createStrokedShape(Shape shape) {
            if (shape == null) {
                return null;
            }
            Rectangle2D oldBounds = shape.getBounds2D();
            float witdh = this.stroke.getLineWidth();
            AffineTransform at = new AffineTransform();
            if (oldBounds.getWidth() > 0.0) {
                at.scale((oldBounds.getWidth() - (double)witdh) / oldBounds.getWidth(), 1.0);
            }
            if (oldBounds.getHeight() > 0.0) {
                at.scale(1.0, (oldBounds.getHeight() - (double)witdh) / oldBounds.getHeight());
            }
            shape = at.createTransformedShape(shape);
            Rectangle2D newBounds = shape.getBounds2D();
            AffineTransform moveBackTransform = AffineTransform.getTranslateInstance(oldBounds.getX() - newBounds.getX() + (double)(witdh / 2.0f), oldBounds.getY() - newBounds.getY() + (double)(witdh / 2.0f));
            shape = moveBackTransform.createTransformedShape(shape);
            return this.stroke.createStrokedShape(shape);
        }
    }
}

