/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.zaproxy.zap.extension.alert.AlertNode;
import org.zaproxy.zap.view.table.HistoryReferencesTable;

@Deprecated
public abstract class PopupMenuHistoryReference
extends ExtensionPopupMenuItem {
    private static final long serialVersionUID = 1L;
    private JTree treeInvoker = null;
    private HistoryReferencesTable hrefsTableInvoker = null;
    private HistoryReferencesTable hrefTableInvoker = null;
    private Invoker lastInvoker = null;
    private boolean multiSelect = false;
    private static final Logger log = LogManager.getLogger(PopupMenuHistoryReference.class);

    public PopupMenuHistoryReference(String label) {
        this(label, false);
    }

    public PopupMenuHistoryReference(String label, boolean multiSelect) {
        super(label);
        this.setText(label);
        this.multiSelect = multiSelect;
        this.initialize();
    }

    protected Invoker getLastInvoker() {
        return this.lastInvoker;
    }

    protected void initialize() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                log.debug("actionPerformed " + PopupMenuHistoryReference.this.lastInvoker.name() + " " + e.getActionCommand());
                try {
                    if (PopupMenuHistoryReference.this.multiSelect) {
                        PopupMenuHistoryReference.this.performActions(PopupMenuHistoryReference.this.getSelectedHistoryReferences());
                    } else {
                        HistoryReference ref = PopupMenuHistoryReference.this.getSelectedHistoryReference();
                        if (ref != null) {
                            try {
                                PopupMenuHistoryReference.this.performAction(ref);
                            }
                            catch (Exception e1) {
                                log.error(e1.getMessage(), (Throwable)e1);
                            }
                        } else {
                            log.error("PopupMenuHistoryReference invoker " + (Object)((Object)PopupMenuHistoryReference.this.lastInvoker) + " failed to get history ref");
                        }
                    }
                }
                catch (Exception e2) {
                    log.error(e2.getMessage(), (Throwable)e2);
                }
            }
        });
    }

    private HistoryReference getSelectedHistoryReference() {
        HistoryReference ref = null;
        try {
            switch (this.lastInvoker) {
                case sites: {
                    SiteNode sNode = (SiteNode)this.treeInvoker.getLastSelectedPathComponent();
                    ref = sNode.getHistoryReference();
                    break;
                }
                case ascan: 
                case history: 
                case bruteforce: 
                case search: 
                case fuzz: {
                    ref = this.hrefsTableInvoker.getSelectedHistoryReference();
                    break;
                }
                case alerts: {
                    AlertNode aNode = (AlertNode)this.treeInvoker.getLastSelectedPathComponent();
                    if (aNode.getUserObject() == null) break;
                    Alert alert = aNode.getUserObject();
                    ref = alert.getHistoryRef();
                    break;
                }
                case hreftable: {
                    ref = this.hrefTableInvoker.getSelectedHistoryReference();
                }
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        return ref;
    }

    private List<HistoryReference> getSelectedHistoryReferences() {
        List<HistoryReference> refs = new ArrayList<HistoryReference>();
        TreePath[] treePaths = null;
        try {
            switch (this.lastInvoker) {
                case sites: {
                    treePaths = this.treeInvoker.getSelectionPaths();
                    if (treePaths == null) break;
                    for (TreePath path : treePaths) {
                        SiteNode node = (SiteNode)path.getLastPathComponent();
                        refs.add(node.getHistoryReference());
                    }
                    break;
                }
                case ascan: 
                case history: 
                case bruteforce: 
                case search: 
                case fuzz: {
                    refs = this.hrefsTableInvoker.getSelectedHistoryReferences();
                    break;
                }
                case alerts: {
                    AlertNode aNode = (AlertNode)this.treeInvoker.getLastSelectedPathComponent();
                    if (aNode.getUserObject() == null) break;
                    Alert alert = aNode.getUserObject();
                    refs.add(alert.getHistoryRef());
                    break;
                }
                case hreftable: {
                    refs = this.hrefTableInvoker.getSelectedHistoryReferences();
                }
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        return refs;
    }

    @Override
    public boolean isEnableForComponent(Component invoker) {
        boolean display = false;
        if (invoker.getName() == null) {
            return false;
        }
        if (invoker.getName().equals("History Table")) {
            this.lastInvoker = Invoker.history;
            this.hrefsTableInvoker = (HistoryReferencesTable)((Object)invoker);
            this.setEnabled(this.isEnabledForHistoryReferences(this.getSelectedHistoryReferences()));
            display = true;
        } else if (invoker instanceof JTree && invoker.getName().equals("treeSite")) {
            this.lastInvoker = Invoker.sites;
            this.treeInvoker = (JTree)invoker;
            this.setEnabled(this.isEnabledForHistoryReferences(this.getSelectedHistoryReferences()));
            display = true;
        } else if (invoker.getName().equals("treeAlert")) {
            this.lastInvoker = Invoker.alerts;
            this.treeInvoker = (JTree)invoker;
            JTree tree = (JTree)invoker;
            if (tree.getLastSelectedPathComponent() != null) {
                if (tree.getSelectionCount() > 1) {
                    this.setEnabled(false);
                } else {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                    if (!node.isRoot() && node.getUserObject() != null) {
                        this.setEnabled(this.isEnabledForHistoryReference(this.getSelectedHistoryReferences().get(0)));
                    } else {
                        this.setEnabled(false);
                    }
                }
            }
            display = true;
        } else if (invoker.getName().equals("SearchHttpMessageContainer")) {
            this.lastInvoker = Invoker.search;
            this.hrefsTableInvoker = (HistoryReferencesTable)((Object)invoker);
            this.setEnabled(this.isEnabledForHistoryReferences(this.getSelectedHistoryReferences()));
            display = true;
        } else if (invoker.getName().equals("ActiveScanMessageContainer")) {
            this.lastInvoker = Invoker.ascan;
            this.hrefsTableInvoker = (HistoryReferencesTable)((Object)invoker);
            this.setEnabled(this.isEnabledForHistoryReferences(this.getSelectedHistoryReferences()));
            display = true;
        } else if (invoker.getName().equals("HttpFuzzerResultsContentPanel")) {
            this.lastInvoker = Invoker.fuzz;
            this.hrefsTableInvoker = (HistoryReferencesTable)((Object)invoker);
            this.setEnabled(this.isEnabledForHistoryReferences(this.getSelectedHistoryReferences()));
            display = true;
        } else if (invoker.getName().equals("ForcedBrowseMessageContainer")) {
            this.lastInvoker = Invoker.bruteforce;
            this.hrefsTableInvoker = (HistoryReferencesTable)((Object)invoker);
            this.setEnabled(this.isEnabledForHistoryReferences(this.getSelectedHistoryReferences()));
            display = true;
        } else if (invoker instanceof HistoryReferencesTable) {
            this.lastInvoker = Invoker.hreftable;
            this.hrefTableInvoker = (HistoryReferencesTable)((Object)invoker);
            this.setEnabled(this.isEnabledForHistoryReferences(this.getSelectedHistoryReferences()));
            display = true;
        }
        if (display) {
            if (this.isEnabled() && !this.isSafe() && Control.getSingleton().getMode().equals((Object)Control.Mode.protect)) {
                boolean inScope = true;
                Session session = Model.getSingleton().getSession();
                for (HistoryReference href : this.getSelectedHistoryReferences()) {
                    if (session.isInScope(href)) continue;
                    inScope = false;
                    break;
                }
                if (!inScope) {
                    this.setEnabled(false);
                }
            }
            return this.isEnableForInvoker(this.lastInvoker);
        }
        return false;
    }

    public boolean isEnabledForHistoryReferences(List<HistoryReference> hrefs) {
        if (hrefs.size() == 0) {
            return false;
        }
        if (hrefs.size() > 1 && !this.multiSelect) {
            return false;
        }
        for (HistoryReference href : hrefs) {
            if (this.isEnabledForHistoryReference(href)) continue;
            return false;
        }
        return true;
    }

    public boolean isEnabledForHistoryReference(HistoryReference href) {
        return href != null && href.getHistoryType() != 0;
    }

    public void performActions(List<HistoryReference> hrefs) throws Exception {
        for (HistoryReference href : hrefs) {
            this.performAction(href);
        }
    }

    public abstract void performAction(HistoryReference var1) throws Exception;

    public abstract boolean isEnableForInvoker(Invoker var1);

    public static enum Invoker {
        sites,
        history,
        alerts,
        ascan,
        search,
        fuzz,
        bruteforce,
        hreftable;

    }
}

