<h1><span><img src="https://github.com/RubixML/RubixML/blob/master/docs/img/rubix-ml-logo.png?raw=true" width="45" height="45" alt="Rubix ML logo" /></span> <span>Rubix ML: Machine Learning for PHP</span></h1>

[![PHP from Packagist](https://img.shields.io/packagist/php-v/rubix/ml.svg?style=flat&colorB=8892BF)](https://www.php.net/) [![Latest Stable Version](https://img.shields.io/packagist/v/rubix/ml.svg?style=flat&colorB=orange)](https://packagist.org/packages/rubix/ml) [![Downloads from Packagist](https://img.shields.io/packagist/dt/rubix/ml.svg?style=flat&colorB=red)](https://packagist.org/packages/rubix/ml) [![Build](https://github.com/RubixML/RubixML/workflows/Build/badge.svg)](https://github.com/RubixML/RubixML/actions) [![Documentation Status](https://img.shields.io/readthedocs/rubix-ml.svg?style=flat&colorB=blue)](https://rubix-ml.readthedocs.io/?badge=latest) [![GitHub](https://img.shields.io/github/license/RubixML/RubixML)](https://github.com/RubixML/RubixML/blob/master/LICENSE.md)

A high-level machine learning and deep learning library for the [PHP](https://php.net) language.

- **Developer-friendly** API is delightful to use
- **40+** supervised and unsupervised learning algorithms
- **Support** for ETL, preprocessing, and cross-validation
- **Open source** and free to use commercially

## Installation
Install Rubix ML into your project using [Composer](https://getcomposer.org/):
```sh
$ composer require rubix/ml
```

### Requirements
- [PHP](https://php.net/manual/en/install.php) 7.2 or above

#### Recommended
- [Tensor extension](https://github.com/RubixML/Tensor) for fast Matrix/Vector computing

#### Optional

- [Extras Package](https://github.com/RubixML/Extras) for experimental features
- [SVM extension](https://php.net/manual/en/book.svm.php) for Support Vector Machine engine (libsvm)
- [Mbstring extension](https://www.php.net/manual/en/book.mbstring.php) for fast multibyte string manipulation
- [GD extension](https://php.net/manual/en/book.image.php) for image manipulation
- [Redis extension](https://github.com/phpredis/phpredis) for persisting to a Redis DB
- [Igbinary extension](https://github.com/igbinary/igbinary) for binary serialization of persistables

## Documentation
Read the latest docs [here](https://docs.rubixml.com).

## What is Rubix ML?
Rubix ML is a free open-source library for the PHP language that allows you to build programs that learn from your data. We provide tools for the entire machine learning life cycle from ETL to training, cross-validation, and production with over 40 supervised and unsupervised learning algorithms.

## Getting Started
If you are new to machine learning, we recommend taking a look at the [What is Machine Learning?](https://docs.rubixml.com/en/latest/what-is-machine-learning.html) section to get started. If you are already familiar with basic ML concepts, you can browse the [basic introduction](https://docs.rubixml.com/en/latest/basic-introduction.html) for a brief look at a typical Rubix ML project. From there, you can browse the official tutorials below which range from beginner to advanced skill level.

### Tutorials & Example Projects
Check out these example projects using the Rubix ML library. Most come with instructions and a pre-cleaned dataset.

- [CIFAR-10 Image Recognizer](https://github.com/RubixML/CIFAR-10)
- [Color Clusterer](https://github.com/RubixML/Colors)
- [Credit Default Risk Predictor](https://github.com/RubixML/Credit)
- [Divorce Predictor](https://github.com/RubixML/Divorce)
- [Dota 2 Game Outcome Predictor](https://github.com/RubixML/Dota2)
- [Human Activity Recognizer](https://github.com/RubixML/HAR)
- [Housing Price Predictor](https://github.com/RubixML/Housing)
- [Iris Flower Classifier](https://github.com/RubixML/Iris)
- [MNIST Handwritten Digit Recognizer](https://github.com/RubixML/MNIST)
- [Text Sentiment Analyzer](https://github.com/RubixML/Sentiment)

## Interact With The Community

- [Join Our Telegram Channel](https://t.me/RubixML)
- [Receive Our Newsletter](https://rubixml.com/#get-notified)
- [Meet In The LinkedIn Group](https://www.linkedin.com/groups/8952251/)

## Funding
Rubix ML is funded by donations from the community. You can become a sponsor by making a contribution to one of our funding sources below.

- [Github Sponsors](https://github.com/sponsors/RubixML)

## Contributing
See [CONTRIBUTING.md](CONTRIBUTING.md) for guidelines.

## License
The code is licensed [MIT](LICENSE.md) and the documentation is licensed [CC BY-NC 4.0](https://creativecommons.org/licenses/by-nc/4.0/).
