/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;
import org.netbeans.modules.profiler.snaptracer.impl.swing.LegendFont;
import org.netbeans.modules.profiler.snaptracer.impl.swing.Spacer;

final class TimelineTooltipPainter
extends JPanel {
    private static Color SELECTION_FOREGROUND = Color.BLACK;
    private static Color SELECTION_BACKGROUND = Utils.forceSpeed() ? new Color(255, 255, 255) : new Color(255, 255, 255, 225);
    private static Color HOVER_FOREGROUND = Color.WHITE;
    private static Color HOVER_BACKGROUND = Utils.forceSpeed() ? new Color(80, 80, 80) : new Color(0, 0, 0, 170);
    private JLabel[] valueNames;
    private JLabel[] valuePainters;
    private JLabel[] unitsPainters;
    private final boolean selection;
    private final Color foreground;
    private final Color background;

    TimelineTooltipPainter(boolean bl) {
        this.selection = bl;
        this.foreground = bl ? SELECTION_FOREGROUND : HOVER_FOREGROUND;
        this.background = bl ? SELECTION_BACKGROUND : HOVER_BACKGROUND;
        this.initUI();
    }

    void update(Model model, List<ItemSelection> list) {
        int n = model.getRowsCount();
        if (this.valueNames == null || this.valueNames.length != n) {
            this.initComponents(n);
        }
        for (int i = 0; i < n; ++i) {
            XYItemSelection xYItemSelection = (XYItemSelection)list.get(i);
            long l = xYItemSelection.getItem().getYValue(xYItemSelection.getValueIndex());
            this.valueNames[i].setText(model.getRowName(i));
            this.valuePainters[i].setText(model.getRowValue(i, l));
            this.unitsPainters[i].setText(model.getRowUnits(i));
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.background);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(graphics);
        if (this.selection) {
            graphics.setColor(this.foreground);
            graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }

    private void initUI() {
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
    }

    private void initComponents(int n) {
        this.removeAll();
        this.valueNames = new JLabel[n];
        this.valuePainters = new JLabel[n];
        this.unitsPainters = new JLabel[n];
        int n2 = 0;
        while (n2 < n) {
            JLabel jLabel;
            JLabel jLabel2;
            JLabel jLabel3;
            this.valueNames[n2] = jLabel3 = new JLabel();
            jLabel3.setFont(new LegendFont());
            jLabel3.setForeground(this.foreground);
            jLabel3.setOpaque(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)jLabel3, gridBagConstraints);
            this.valuePainters[n2] = jLabel2 = new JLabel();
            jLabel2.setFont(new LegendFont());
            jLabel2.setForeground(this.foreground);
            jLabel2.setOpaque(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.insets = new Insets(0, 8, 0, 0);
            this.add((Component)jLabel2, gridBagConstraints);
            this.unitsPainters[n2] = jLabel = new JLabel();
            jLabel.setFont(new LegendFont());
            jLabel.setForeground(this.foreground);
            jLabel.setOpaque(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.insets = new Insets(0, 3, 0, 0);
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)Spacer.create(), gridBagConstraints);
        }
    }

    static interface Model {
        public int getRowsCount();

        public String getRowName(int var1);

        public String getRowValue(int var1, long var2);

        public String getRowUnits(int var1);
    }
}

