/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.UnionType;

final class Promises {
    private Promises() {
    }

    static final JSType getTemplateTypeOfThenable(JSTypeRegistry registry, JSType maybeThenable) {
        TemplateType templateType = registry.getIThenableTemplate();
        return maybeThenable.restrictByNotNullOrUndefined().getTemplateTypeMap().getResolvedTemplateType(templateType);
    }

    static final JSType getResolvedType(JSTypeRegistry registry, JSType type) {
        if (type.isUnknownType()) {
            return type;
        }
        if (type.isUnionType()) {
            UnionType.Builder unionTypeBuilder = UnionType.builder(registry);
            for (JSType alternate : type.toMaybeUnionType().getAlternates()) {
                unionTypeBuilder.addAlternate(Promises.getResolvedType(registry, alternate));
            }
            return unionTypeBuilder.build();
        }
        TemplateTypeMap templates = type.getTemplateTypeMap();
        if (templates.hasTemplateKey(registry.getIThenableTemplate())) {
            return Promises.getResolvedType(registry, templates.getResolvedTemplateType(registry.getIThenableTemplate()));
        }
        if (type.isSubtypeOf(registry.getNativeType(JSTypeNative.THENABLE_TYPE))) {
            return registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return type;
    }

    static final JSType wrapInIThenable(JSTypeRegistry registry, JSType maybeThenable) {
        JSType unwrapped = Promises.getResolvedType(registry, maybeThenable);
        return registry.createTemplatizedType(registry.getNativeObjectType(JSTypeNative.I_THENABLE_TYPE), unwrapped);
    }

    static final JSType createAsyncReturnableType(JSTypeRegistry registry, JSType maybeThenable) {
        JSType unknownType = registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        ObjectType iThenableType = registry.getNativeObjectType(JSTypeNative.I_THENABLE_TYPE);
        TemplatizedType iThenableOfUnknownType = registry.createTemplatizedType(iThenableType, unknownType);
        ImmutableList<JSType> alternates = maybeThenable.isUnionType() ? maybeThenable.toMaybeUnionType().getAlternates() : ImmutableList.of(maybeThenable);
        ImmutableList asyncTemplateAlternates = alternates.stream().filter(t -> t.isSubtypeOf(iThenableOfUnknownType)).map(t -> Promises.getTemplateTypeOfThenable(registry, t)).collect(ImmutableList.toImmutableList());
        if (asyncTemplateAlternates.isEmpty()) {
            return unknownType;
        }
        JSType asyncTemplateUnion = registry.createUnionType(asyncTemplateAlternates);
        return registry.createUnionType(asyncTemplateUnion, registry.createTemplatizedType(iThenableType, asyncTemplateUnion));
    }
}

