/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PolyfillUsageFinder;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.jscomp.resources.ResourceLoader;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashSet;
import java.util.Set;

public class RewritePolyfills
implements HotSwapCompilerPass {
    static final DiagnosticType INSUFFICIENT_OUTPUT_VERSION_ERROR = DiagnosticType.disabled("JSC_INSUFFICIENT_OUTPUT_VERSION", "Built-in ''{0}'' not supported in output version {1}");
    private final AbstractCompiler compiler;
    private final PolyfillUsageFinder.Polyfills polyfills;
    private final boolean injectPolyfills;
    private final boolean isolatePolyfills;
    private Set<String> libraries;

    public RewritePolyfills(AbstractCompiler compiler, boolean injectPolyfills, boolean isolatePolyfills) {
        this(compiler, PolyfillUsageFinder.Polyfills.fromTable(ResourceLoader.loadTextResource(RewritePolyfills.class, "js/polyfills.txt")), injectPolyfills, isolatePolyfills);
    }

    @VisibleForTesting
    RewritePolyfills(AbstractCompiler compiler, PolyfillUsageFinder.Polyfills polyfills, boolean injectPolyfills, boolean isolatePolyfills) {
        this.compiler = compiler;
        this.polyfills = polyfills;
        this.injectPolyfills = injectPolyfills;
        this.isolatePolyfills = isolatePolyfills;
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        if (this.isolatePolyfills) {
            Node jscompLookupMethodDecl = IR.var(IR.name("$jscomp$lookupPolyfilledValue"));
            this.compiler.getSynthesizedExternsInputAtEnd().getAstRoot(this.compiler).addChildToBack(jscompLookupMethodDecl);
            this.compiler.reportChangeToEnclosingScope(jscompLookupMethodDecl);
        }
        if (!this.injectPolyfills) {
            return;
        }
        this.libraries = new LinkedHashSet<String>();
        new PolyfillUsageFinder(this.compiler, this.polyfills).traverseExcludingGuarded(scriptRoot, this::inject);
        if (this.libraries.isEmpty()) {
            return;
        }
        Node lastNode = null;
        for (String library : this.libraries) {
            lastNode = this.compiler.ensureLibraryInjected(library, false);
        }
        if (lastNode != null) {
            Node parent = lastNode.getParent();
            this.removeUnneededPolyfills(parent, lastNode.getNext());
            this.compiler.reportChangeToEnclosingScope(parent);
        }
    }

    private void removeUnneededPolyfills(Node parent, Node runtimeEnd) {
        Node node = parent.getFirstChild();
        while (node != null && node != runtimeEnd) {
            Node call;
            Node name;
            Node next = node.getNext();
            if (NodeUtil.isExprCall(node) && (name = (call = node.getFirstChild()).getFirstChild()).matchesQualifiedName("$jscomp.polyfill")) {
                String nativeVersionStr = name.getNext().getNext().getNext().getString();
                FeatureSet outputFeatureSet = this.compiler.getOptions().getOutputFeatureSet();
                if (outputFeatureSet.contains(FeatureSet.valueOf(nativeVersionStr))) {
                    NodeUtil.removeChild(parent, node);
                    NodeUtil.markFunctionsDeleted(node, this.compiler);
                }
            }
            node = next;
        }
    }

    @Override
    public void process(Node externs, Node root) {
        this.hotSwapScript(root, null);
    }

    private void inject(PolyfillUsageFinder.PolyfillUsage polyfillUsage) {
        PolyfillUsageFinder.Polyfill polyfill = polyfillUsage.polyfill();
        FeatureSet outputFeatureSet = this.compiler.getOptions().getOutputFeatureSet();
        FeatureSet featuresRequiredByPolyfill = FeatureSet.valueOf(polyfill.polyfillVersion);
        if (polyfill.kind.equals((Object)PolyfillUsageFinder.Polyfill.Kind.STATIC) && !outputFeatureSet.contains(featuresRequiredByPolyfill)) {
            this.compiler.report(JSError.make(polyfillUsage.node(), INSUFFICIENT_OUTPUT_VERSION_ERROR, polyfillUsage.name(), outputFeatureSet.version()));
        }
        if (!outputFeatureSet.contains(FeatureSet.valueOf(polyfill.nativeVersion)) && !polyfill.library.isEmpty()) {
            this.libraries.add(polyfill.library);
        }
    }
}

