/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.modules;

import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.modules.Module;
import javax.annotation.Nullable;

public final class ModuleMap {
    private final ImmutableMap<String, Module> resolvedModules;
    private final ImmutableMap<String, Module> resolvedClosureModules;

    public ModuleMap(ImmutableMap<String, Module> resolvedModules, ImmutableMap<String, Module> resolvedClosureModules) {
        this.resolvedModules = resolvedModules;
        this.resolvedClosureModules = resolvedClosureModules;
    }

    @Nullable
    public Module getModule(String moduleName) {
        return this.resolvedModules.get(moduleName);
    }

    @Nullable
    public Module getModule(ModuleLoader.ModulePath path) {
        return this.getModule(path.toModuleName());
    }

    public ImmutableMap<String, Module> getModulesByPath() {
        return this.resolvedModules;
    }

    public ImmutableMap<String, Module> getModulesByClosureNamespace() {
        return this.resolvedClosureModules;
    }

    @Nullable
    public Module getClosureModule(String namespace) {
        return this.resolvedClosureModules.get(namespace);
    }

    public static ModuleMap emptyForTesting() {
        return new ModuleMap(ImmutableMap.of(), ImmutableMap.of());
    }
}

